/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.FileInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.FileInnerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.IFileInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class AbstractFileInnerIndex
implements IInnerIndex {
    private RandomAccessFile m_file;
    private IInnerIndexHelper m_helper;

    public AbstractFileInnerIndex(RandomAccessFile file, IInnerIndexHelper helper) {
        this.m_file = file;
        this.m_helper = helper;
    }

    @Override
    public InnerIndexValue getValueAt(InnerIndexLink link) throws IndexAccessException {
        try {
            RandomAccessFile file = this.getIndexFile();
            file.seek(link.getLink());
            FileInnerIndexValue value = ((IFileInnerIndexHelper)this.getHelper()).getIndexFileValueType();
            value.read(file);
            return value;
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
    }

    protected RandomAccessFile getIndexFile() {
        return this.m_file;
    }

    protected IInnerIndexHelper getHelper() {
        return this.m_helper;
    }

    protected MapMarkerIndexValue getValueFor(FileInnerIndexItem item) throws IOException, IndexAccessException {
        if (this.getHelper().supportsMultiValue()) {
            MapMarkerIndexMultiValue multiValue = new MapMarkerIndexMultiValue();
            multiValue.addOffset(((MapMarkerIndexSingleValue)item.getValue().getValue()).getOffset());
            InnerIndexLink link = item.getValue().getNextValueLink();
            while (link.isLink()) {
                InnerIndexValue value = this.getValueAt(link);
                multiValue.addOffset(((MapMarkerIndexSingleValue)value.getValue()).getOffset());
                link = value.getNextValueLink();
            }
            return multiValue;
        }
        return item.getValue().getValue();
    }

    protected FileInnerIndexItem getItemAt(InnerIndexLink link) throws IOException {
        RandomAccessFile file = this.getIndexFile();
        file.seek(link.getLink());
        FileInnerIndexItem item = ((IFileInnerIndexHelper)this.getHelper()).getIndexFileItemType();
        item.read(file);
        return item;
    }

    protected final void updateLink(InnerIndexLink link) throws IOException {
        link.update(this.getIndexFile());
    }

    protected final void addValue(InnerIndexLink link, FileInnerIndexValue value) throws IOException {
        RandomAccessFile file = this.getIndexFile();
        while (link.isLink()) {
            FileInnerIndexValue tempValue = ((IFileInnerIndexHelper)this.getHelper()).getIndexFileValueType();
            file.seek(link.getLink());
            tempValue.read(file);
            link = tempValue.getNextValueLink();
        }
        file.seek(file.length());
        link.setLink(file.getFilePointer());
        this.updateLink(link);
        value.write(file);
    }

    protected void addEntry(InnerIndexLink link, FileInnerIndexItem item) throws IOException {
        RandomAccessFile file = this.getIndexFile();
        file.seek(file.length());
        link.setLink(file.getFilePointer());
        item.write(file);
        this.updateLink(link);
    }
}

