/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.IFileInnerIndexConvertor;
import com.mapinfo.mapmarker.common.dp.binary.index.IInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IInputIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.NonUpdatableInnerIndexLink;
import com.mapinfo.mapmarker.utils.SeekableDataInputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public abstract class AbstractFileInnerIndexConvertor
implements IFileInnerIndexConvertor {
    private SeekableDataInputStream m_inputIndexFile;
    private RandomAccessFile m_innerIndexFile;
    private RandomAccessFile m_finalIndexFile;
    private File m_innerIndexFileRef;
    private IInputIndexFileHelper m_inputHelper;
    private IInnerIndexHelper m_innerIndexHelper;
    private MapMarkerIndexFileMetadata m_finalMetadata;
    private InnerIndexLink m_linkToInnerIndex;

    AbstractFileInnerIndexConvertor(IInputIndexFileHelper inputHelper, IInnerIndexHelper innerHelper, MapMarkerIndexFileMetadata finalMetadata) {
        this.m_inputHelper = inputHelper;
        this.m_innerIndexHelper = innerHelper;
        this.m_finalMetadata = finalMetadata;
    }

    @Override
    public void convert(String path, String inputIndexName, String finalIndexName) throws IOException, IndexAccessException {
        DataCreationLogger.getLogger().logStatus("Creating files.");
        this.openIndexFiles(path, inputIndexName, finalIndexName);
        DataCreationLogger.getLogger().logStatus("Creating inner index file.");
        this.createInnerIndex();
        DataCreationLogger.getLogger().logStatus("Writing final index.");
        this.createFinalIndex();
    }

    @Override
    public void cleanUp() throws IOException {
        if (this.m_innerIndexFileRef != null) {
            this.m_innerIndexFileRef.delete();
        }
    }

    protected abstract IInnerIndex getInnerIndex();

    protected IInnerIndexHelper getInnerIndexHelper() {
        return this.m_innerIndexHelper;
    }

    protected RandomAccessFile getInnerIndexFile() {
        return this.m_innerIndexFile;
    }

    private void createInnerIndex() throws IndexAccessException, IOException {
        this.m_linkToInnerIndex = InnerIndexLink.getNoLinkLink();
        this.m_linkToInnerIndex.write(this.m_innerIndexFile);
        IInnerIndex tempIndex = this.getInnerIndex();
        tempIndex.create(this.m_linkToInnerIndex);
        int count = 0;
        try {
            while (true) {
                MapMarkerIndexKey key = this.m_inputHelper.getIndexKeyType();
                key.read((DataInput)this.m_inputIndexFile);
                MapMarkerIndexValue value = this.m_inputHelper.getIndexValueType();
                value.read((DataInput)this.m_inputIndexFile);
                tempIndex.insert(key, value);
                if (++count % 1000 != 0) continue;
                DataCreationLogger.getLogger().logStatusNoLF("Processing record # " + count + ".\r");
            }
        }
        catch (EOFException EOFEx) {
            this.m_inputIndexFile.close();
            DataCreationLogger.getLogger().logStatus("\nProcessed " + count + " records.");
            return;
        }
    }

    private void createFinalIndex() throws IndexAccessException, IOException {
        IInnerIndex tempIndex = this.getInnerIndex();
        tempIndex.access(this.m_linkToInnerIndex);
        NonUpdatableInnerIndexLink link = new NonUpdatableInnerIndexLink(this.m_linkToInnerIndex);
        try {
            tempIndex.write(link, this.m_finalIndexFile);
        }
        finally {
            this.m_innerIndexFile.close();
            this.m_finalIndexFile.close();
        }
    }

    private void openIndexFiles(String path, String inputIndexName, String finalIndexName) throws IOException {
        File pathFile = new File(path);
        this.m_innerIndexFileRef = File.createTempFile("index", "tmp", pathFile);
        this.m_innerIndexFile = new RandomAccessFile(this.m_innerIndexFileRef, "rw");
        this.m_inputIndexFile = new SeekableDataInputStream(new File(path, inputIndexName));
        this.m_finalIndexFile = new RandomAccessFile(new File(path, finalIndexName), "rw");
        this.m_finalMetadata.write((DataOutput)this.m_finalIndexFile);
    }
}

