/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.AbstractFileInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.FileInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.FileInnerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.IFileInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLinkStack;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.NonUpdatableInnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeFileInnerIndexItem;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;

public class BinaryTreeFileInnerIndex
extends AbstractFileInnerIndex {
    protected TreeFileInnerIndexItem m_Z;
    private InnerIndexLink m_root = InnerIndexLink.getNoLinkLink();

    public BinaryTreeFileInnerIndex(RandomAccessFile file, IFileInnerIndexHelper helper) {
        super(file, helper);
        this.m_Z = (TreeFileInnerIndexItem)helper.getIndexFileItemType();
    }

    @Override
    public void create(InnerIndexLink link) throws IndexAccessException {
        try {
            RandomAccessFile file = this.getIndexFile();
            file.seek(file.length());
            link.setLink(file.getFilePointer());
            this.m_root.write(this.getIndexFile());
            this.addEntry(this.m_root, this.m_Z);
            link.update(file);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5000, (Throwable)IOEx);
        }
    }

    @Override
    public void access(InnerIndexLink link) throws IndexAccessException {
        try {
            RandomAccessFile file = this.getIndexFile();
            file.seek(link.getLink());
            this.m_root.read(file);
            this.m_Z.read(file);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
    }

    @Override
    public boolean insert(MapMarkerIndexKey key, MapMarkerIndexValue value) throws IndexAccessException {
        InnerIndexLink link = this.m_root;
        FileInnerIndexItem newItem = ((IFileInnerIndexHelper)this.getHelper()).makeIndexFileItem(key, value);
        try {
            while (!link.equals(this.m_Z.getSelfLink())) {
                TreeFileInnerIndexItem item = (TreeFileInnerIndexItem)this.getItemAt(link);
                int keyRelation = key.compareTo((Object)item.getKey());
                if (keyRelation == 0) {
                    this.addValue(item.getValue().getNextValueLink(), (FileInnerIndexValue)newItem.getValue());
                    return false;
                }
                if (keyRelation < 0) {
                    link = item.getLeftLink();
                    continue;
                }
                link = item.getRightLink();
            }
            this.addEntry(link, newItem);
            return true;
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5004, (Throwable)IOEx);
        }
    }

    @Override
    public void write(InnerIndexLink link, RandomAccessFile outputFile) throws IndexAccessException {
        InnerIndexLinkStack linkStack = new InnerIndexLinkStack();
        try {
            outputFile.seek(outputFile.length());
            link.setLink(outputFile.getFilePointer());
            link.update(outputFile);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
        InnerIndexLink treeLink = new NonUpdatableInnerIndexLink(this.getRoot());
        while (treeLink != null && !treeLink.equals(this.m_Z.getSelfLink())) {
            TreeFileInnerIndexItem item;
            try {
                item = (TreeFileInnerIndexItem)this.getItemAt(treeLink);
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5002, (Throwable)IOEx);
            }
            try {
                outputFile.seek(outputFile.length());
                treeLink.setLink(outputFile.getFilePointer());
                treeLink.update(outputFile);
                item.getKey().write((DataOutput)outputFile);
                this.getValueFor(item).write((DataOutput)outputFile);
                if (item.getLeftLink().equals(this.m_Z.getSelfLink())) {
                    InnerIndexLink.getNoLinkLink().write(outputFile);
                    treeLink = null;
                } else {
                    treeLink = item.getLeftLink();
                    treeLink.write(outputFile);
                }
                if (item.getRightLink().equals(this.m_Z.getSelfLink())) {
                    InnerIndexLink.getNoLinkLink().write(outputFile);
                } else {
                    item.getRightLink().write(outputFile);
                    linkStack.push(item.getRightLink());
                }
                if (treeLink != null || linkStack.isEmpty()) continue;
                treeLink = linkStack.pop();
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5002, (Throwable)IOEx);
            }
        }
    }

    @Override
    protected void addEntry(InnerIndexLink link, FileInnerIndexItem item) throws IOException {
        TreeFileInnerIndexItem treeItem = (TreeFileInnerIndexItem)item;
        treeItem.getLeftLink().setLink(this.m_Z.getSelfLink().getLink());
        treeItem.getRightLink().setLink(this.m_Z.getSelfLink().getLink());
        super.addEntry(link, item);
    }

    protected InnerIndexLink getRoot() {
        return this.m_root;
    }

    protected InnerIndexLink getLeftLink(InnerIndexLink link) throws IOException {
        return ((TreeFileInnerIndexItem)this.getItemAt(link)).getLeftLink();
    }

    protected InnerIndexLink getRightLink(InnerIndexLink link) throws IOException {
        return ((TreeFileInnerIndexItem)this.getItemAt(link)).getRightLink();
    }
}

