/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.AbstractNIOInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.INIOInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.ISearchableNIOInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLinkStack;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.NonTerminalNIOInnerSubIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.NonUpdatableNIOInnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeNIOInnerIndexItem;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class BinaryTreeNIOInnerIndex
extends AbstractNIOInnerIndex
implements ISearchableNIOInnerIndex {
    protected TreeNIOInnerIndexItem m_Z;
    private NIOInnerIndexLink m_root = new NIOInnerIndexLink();

    public BinaryTreeNIOInnerIndex(RandomAccessDataStream file, INIOInnerIndexHelper helper) {
        super(file, helper);
        this.m_Z = (TreeNIOInnerIndexItem)helper.getIndexFileItemType();
    }

    @Override
    public void create(NIOInnerIndexLink link) throws IndexAccessException {
        try {
            RandomAccessDataStream file = this.getIndexFile();
            file.seek(file.length());
            link.setLink(file.getFilePointer());
            this.m_root.write((DataOutput)this.getIndexFile());
            this.addEntry(this.m_root, this.m_Z);
            link.update(file);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5000, (Throwable)IOEx);
        }
    }

    @Override
    public void access(NIOInnerIndexLink link) throws IndexAccessException {
        try {
            RandomAccessDataStream file = this.getIndexFile();
            file.seek(link.getLink());
            this.m_root.read((DataInput)file);
            this.m_Z.read(file);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
    }

    @Override
    public boolean insert(MapMarkerIndexKey key, MapMarkerIndexValue value) throws IndexAccessException {
        NIOInnerIndexLink link = this.m_root;
        NIOInnerIndexItem newItem = ((INIOInnerIndexHelper)this.getHelper()).makeIndexFileItem(key, value);
        try {
            while (!link.equals(this.m_Z.getSelfLink())) {
                TreeNIOInnerIndexItem item = (TreeNIOInnerIndexItem)this.getItemAt(link);
                int keyRelation = key.compareTo((Object)item.getKey());
                if (keyRelation == 0) {
                    this.addValue((NIOInnerIndexLink)item.getValue().getNextValueLink(), (NIOInnerIndexValue)newItem.getValue());
                    return false;
                }
                if (keyRelation < 0) {
                    link = item.getLeftLink();
                    continue;
                }
                link = item.getRightLink();
            }
            this.addEntry(link, newItem);
            return true;
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5004, (Throwable)IOEx);
        }
    }

    @Override
    public NIOInnerIndexLink search(MapMarkerIndexKey key) throws IndexAccessException {
        NIOInnerIndexLink link = this.m_root;
        try {
            while (!link.equals(this.m_Z.getSelfLink())) {
                TreeNIOInnerIndexItem item = (TreeNIOInnerIndexItem)this.getItemAt(link);
                int keyRelation = key.compareTo((Object)item.getKey());
                if (keyRelation == 0) {
                    if (item.getValue() instanceof NonTerminalNIOInnerSubIndexValue) {
                        NonTerminalNIOInnerSubIndexValue value = (NonTerminalNIOInnerSubIndexValue)item.getValue();
                        return (NIOInnerIndexLink)value.getValue();
                    }
                    return item.getSelfLink();
                }
                if (keyRelation < 0) {
                    link = item.getLeftLink();
                    continue;
                }
                link = item.getRightLink();
            }
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5004, (Throwable)IOEx);
        }
        return null;
    }

    @Override
    public void write(NIOInnerIndexLink link, RandomAccessDataStream outputFile) throws IndexAccessException {
        InnerIndexLinkStack linkStack = new InnerIndexLinkStack();
        try {
            outputFile.seek(outputFile.length());
            link.setLink(outputFile.getFilePointer());
            link.update(outputFile);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
        NIOInnerIndexLink treeLink = new NonUpdatableNIOInnerIndexLink(this.getRoot());
        while (treeLink != null && !treeLink.equals(this.m_Z.getSelfLink())) {
            TreeNIOInnerIndexItem item;
            try {
                item = (TreeNIOInnerIndexItem)this.getItemAt(treeLink);
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5002, (Throwable)IOEx);
            }
            try {
                outputFile.seek(outputFile.length());
                treeLink.setLink(outputFile.getFilePointer());
                treeLink.update(outputFile);
                item.getKey().write((DataOutput)outputFile);
                this.getValueFor(item).write((DataOutput)outputFile);
                if (item.getLeftLink().equals(this.m_Z.getSelfLink())) {
                    new NIOInnerIndexLink().write((DataOutput)outputFile);
                    treeLink = null;
                } else {
                    treeLink = item.getLeftLink();
                    treeLink.write((DataOutput)outputFile);
                }
                if (item.getRightLink().equals(this.m_Z.getSelfLink())) {
                    new NIOInnerIndexLink().write((DataOutput)outputFile);
                } else {
                    item.getRightLink().write((DataOutput)outputFile);
                    linkStack.push(item.getRightLink());
                }
                if (treeLink != null || linkStack.isEmpty()) continue;
                treeLink = (NIOInnerIndexLink)linkStack.pop();
            }
            catch (IOException IOEx) {
                throw new IndexAccessException(5002, (Throwable)IOEx);
            }
        }
    }

    @Override
    protected void addEntry(NIOInnerIndexLink link, NIOInnerIndexItem item) throws IOException {
        TreeNIOInnerIndexItem treeItem = (TreeNIOInnerIndexItem)item;
        treeItem.getLeftLink().setLink(this.m_Z.getSelfLink().getLink());
        treeItem.getRightLink().setLink(this.m_Z.getSelfLink().getLink());
        super.addEntry(link, item);
    }

    protected NIOInnerIndexLink getRoot() {
        return this.m_root;
    }

    protected NIOInnerIndexLink getLeftLink(NIOInnerIndexLink link) throws IOException {
        return ((TreeNIOInnerIndexItem)this.getItemAt(link)).getLeftLink();
    }

    protected NIOInnerIndexLink getRightLink(NIOInnerIndexLink link) throws IOException {
        return ((TreeNIOInnerIndexItem)this.getItemAt(link)).getRightLink();
    }
}

