/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBinaryIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetBrowseMultiLevelIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MultiValueIndexFileConvertor;

public class BrowseIndexer
extends MultiValueIndexFileConvertor {
    public BrowseIndexer(String tempIndexFileName, String finalIndexFileName) {
        super(tempIndexFileName, finalIndexFileName);
    }

    @Override
    protected MapMarkerBinaryIndexFile getIndexFileType() {
        return new MapMarkerStreetBrowseMultiLevelIndexFile();
    }

    @Override
    protected MapMarkerIndexFileMetadata getIndexMetadataType() {
        return new MapMarkerMultiLevelIndexFileMetadata(3);
    }

    @Override
    protected MapMarkerIndexKey getIndexKeyType() {
        return new MapMarkerBrowseMultiLevelIndexKey();
    }

    public static final void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage BroweIndexer <temp_browse_index> <final_bowse_index>");
            System.exit(1);
        }
        BrowseIndexer indexer = new BrowseIndexer(args[0], args[1]);
        try {
            indexer.convert();
        }
        catch (DataCreationException DCEx) {
            System.err.println("Unable to convert index file.");
            System.err.println(DCEx.getMessage());
            DCEx.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

