/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.EOFException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public abstract class GeoInfoSoundexIndexer {
    protected Soundex sndx;

    protected MMJComplexDataFileMetadata getMetadataType() {
        return new MMJComplexDataFileMetadata();
    }

    protected abstract ArrayList makeKeys(GeoInfoDataItem var1, MMJComplexDataFileMetadata var2) throws DataCreationException;

    public void processGeoInfoFile(String geoInfoBaseName) throws DataCreationException {
        RandomAccessFile geoInfoFile = null;
        try {
            geoInfoFile = new RandomAccessFile(geoInfoBaseName + ".jdr", "r");
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to open geoinfo data file: " + geoInfoBaseName + ".jdr");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(e);
        }
        MMJComplexDataFileMetadata metadata = this.getMetadataType();
        try {
            metadata.read((DataInput)geoInfoFile);
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to read the geoinfo metadata.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(e);
        }
        RandomAccessFile tempIndexFile = null;
        try {
            tempIndexFile = new RandomAccessFile(geoInfoBaseName + ".tsx", "rw");
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to create temporary index file for geoinfo.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace(e);
            throw new DataCreationException(e);
        }
        try {
            long pos;
            block17: while (true) {
                GeoInfoDataItem item = null;
                pos = -1L;
                try {
                    pos = geoInfoFile.getFilePointer();
                    item = new GeoInfoDataItem();
                    try {
                        item.read((DataInput)geoInfoFile, (MMJDataFileMetadata)metadata);
                    }
                    catch (MMJEDataCorruptedException e) {
                        DataCreationLogger.getLogger().logInternalError("ERROR: Unable to read geoinfo item at : " + pos);
                        DataCreationLogger.getLogger().logInternalError(e.getMessage());
                        DataCreationLogger.getLogger().logStackTrace(e);
                        throw new DataCreationException(e);
                    }
                }
                catch (EOFException EOFEx) {
                    throw EOFEx;
                }
                catch (IOException e) {
                    throw new DataCreationException(e);
                }
                ArrayList keyList = this.makeKeys(item, metadata);
                if (keyList == null || keyList.size() <= 0) break;
                int i = 0;
                while (true) {
                    if (i >= keyList.size()) continue block17;
                    try {
                        ((ISoundexKey)keyList.get(i)).write((DataOutput)tempIndexFile);
                        tempIndexFile.writeLong(pos);
                    }
                    catch (IOException e) {
                        throw new DataCreationException(e);
                    }
                    ++i;
                }
                break;
            }
            DataCreationLogger.getLogger().logInternalError("ERROR: no keys for geoinfo data item @: " + pos);
            throw new DataCreationException("ERROR: no keys for geoinfo data item @: " + pos);
        }
        catch (EOFException EOFEx) {
            DataCreationLogger.getLogger().logStatus("Finished indexing geoinfo data file.");
            try {
                geoInfoFile.close();
                tempIndexFile.close();
            }
            catch (IOException e) {
                throw new DataCreationException(e);
            }
            DataCreationLogger.getLogger().logStatus("Finished creating temporary soundex index file.");
            return;
        }
    }
}

