/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.DuplicateKeyException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBinaryIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileItem;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndexNonTerminalValue;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class MapMarkerBinaryMultiLevelIndexFile
extends MapMarkerBinaryIndexFile {
    protected int m_levels = -1;
    protected long m_startingOffset = -1L;
    protected boolean m_firstLevelRead = false;
    protected MapMarkerSubIndex m_firstLevel = null;

    public abstract MapMarkerSubIndex getIndexAt(int var1, long var2, boolean var4) throws IOException;

    public abstract MapMarkerSubIndex createIndexAt(int var1);

    @Override
    public void open(String fileName) throws IOException {
        this.file = new RandomAccessFile(fileName, "r");
        this.metadata = this.getIndexMetadataType();
        this.metadata.read((DataInput)this.file);
        this.getLevels();
        this.m_startingOffset = this.file.getFilePointer();
        this.m_firstLevel = this.getIndexAt(0, this.m_startingOffset, this.m_firstLevelRead);
    }

    @Override
    public void create(String fileName, MapMarkerIndexFileMetadata metadata) throws IOException {
        super.create(fileName, metadata);
        this.getLevels();
        this.tree = null;
        this.m_firstLevel = this.createIndexAt(0);
    }

    @Override
    public MapMarkerIndexValue search(MapMarkerIndexKey key) throws IOException {
        MapMarkerMultiLevelIndexKey multiKey = (MapMarkerMultiLevelIndexKey)key;
        if (!this.validateKey(multiKey)) {
            return null;
        }
        Object value = this.m_firstLevel.search(multiKey.getKeyAt(0));
        if (value == null) {
            return null;
        }
        for (int i = 1; i < this.m_levels; ++i) {
            MapMarkerSubIndex subIndex = this.getIndexAt(i, ((MapMarkerSubIndexNonTerminalValue)value).getIndexOffset(), false);
            if ((value = subIndex.search(multiKey.getKeyAt(i))) != null) continue;
            return null;
        }
        return (MapMarkerIndexValue)value;
    }

    @Override
    public void addIndexEntry(MapMarkerIndexKey key, MapMarkerIndexValue value) throws DuplicateKeyException {
        MapMarkerMultiLevelIndexKey multiKey = (MapMarkerMultiLevelIndexKey)key;
        if (!this.validateKey(multiKey)) {
            return;
        }
        MapMarkerSubIndex index = this.m_firstLevel;
        for (int i = 0; i < this.getLevels(); ++i) {
            MapMarkerSubIndexItem item;
            if (index.isTerminal()) {
                index.insert(multiKey.getKeyAt(i), value);
                return;
            }
            try {
                item = index.insert(multiKey.getKeyAt(i), null);
            }
            catch (DuplicateKeyException DKEx) {
                item = index.searchForItem(multiKey.getKeyAt(i));
            }
            if (item.getValue() == null) {
                item.setValue(this.createIndexAt(i + 1));
            }
            index = (MapMarkerSubIndex)item.getValue();
        }
    }

    @Override
    public void write() throws IOException {
        int i;
        DataCreationLogger.getLogger().logStatus("Writing the multiLevel index.");
        this.metadata.write((DataOutput)this.file);
        this.m_firstLevel.write();
        List[] nextSubIndexLinks = new List[this.m_levels - 1];
        for (i = 1; i < this.m_levels - 1; ++i) {
            nextSubIndexLinks[i] = new LinkedList();
        }
        nextSubIndexLinks[0] = this.m_firstLevel.getSubIndexLinks();
        for (i = 0; i < this.m_levels - 2; ++i) {
            Iterator nextSubIndexLinksIterator = nextSubIndexLinks[i].iterator();
            while (nextSubIndexLinksIterator.hasNext()) {
                MapMarkerSubIndexNonTerminalValue link = (MapMarkerSubIndexNonTerminalValue)nextSubIndexLinksIterator.next();
                nextSubIndexLinksIterator.remove();
                link.setIndexOffset(((MapMarkerSubIndex)link.getSubIndex()).write());
                link.update(this.file);
                nextSubIndexLinks[i + 1].addAll(((MapMarkerSubIndex)link.getSubIndex()).getSubIndexLinks());
            }
        }
        Iterator terminalLinksIterator = nextSubIndexLinks[i].iterator();
        while (terminalLinksIterator.hasNext()) {
            MapMarkerSubIndexNonTerminalValue terminalLink = (MapMarkerSubIndexNonTerminalValue)terminalLinksIterator.next();
            terminalLinksIterator.remove();
            terminalLink.setIndexOffset(((MapMarkerSubIndex)terminalLink.getSubIndex()).write());
            terminalLink.update(this.file);
        }
    }

    protected boolean validateKey(MapMarkerMultiLevelIndexKey key) {
        return key.getLevels() == this.m_levels;
    }

    protected int getLevels() {
        if (this.m_levels == -1) {
            MapMarkerMultiLevelIndexFileMetadata multiMetadata = (MapMarkerMultiLevelIndexFileMetadata)this.metadata;
            this.m_levels = multiMetadata.getLevels();
        }
        return this.m_levels;
    }

    @Override
    protected MapMarkerIndexFileItem getIndexItem() {
        return null;
    }

    @Override
    protected MapMarkerIndexFileItem getIndexItem(MapMarkerIndexKey key, MapMarkerIndexValue value) {
        return null;
    }
}

