/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.DuplicateKeyException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerListSubIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerSubIndexNextIndexValue;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class MapMarkerListSubIndex
extends MapMarkerSubIndex {
    protected List m_list = null;
    protected boolean m_sorted = true;

    public MapMarkerListSubIndex(long indexOrigin, RandomAccessFile indexFile, boolean readFully) throws IOException {
        super(indexOrigin, indexFile, readFully);
        if (this.m_readFully) {
            this.readFully();
        }
    }

    public MapMarkerListSubIndex(RandomAccessFile indexFile) {
        super(indexFile);
    }

    @Override
    public MapMarkerSubIndexItem insert(MapMarkerIndexKey key, MapMarkerIndexValue value) throws DuplicateKeyException {
        MapMarkerListSubIndexItem item = (MapMarkerListSubIndexItem)this.getIndexItem((Comparable)key, value);
        if (this.m_list == null) {
            this.m_list = new LinkedList();
        } else {
            MapMarkerSubIndexItem previousItem = this.searchForItem(key);
            if (previousItem != null) {
                if (this.m_isTerminal) {
                    throw new DuplicateKeyException("Duplicate key found: " + key);
                }
                return item;
            }
            this.m_sorted = false;
        }
        this.m_list.add(item);
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFully() throws IOException {
        this.m_list = new LinkedList();
        RandomAccessFile randomAccessFile = this.m_indexFile;
        synchronized (randomAccessFile) {
            this.m_indexFile.seek(this.m_indexOrigin);
            int itemCount = this.m_indexFile.readShort();
            for (int i = 0; i < itemCount; ++i) {
                MapMarkerListSubIndexItem item = (MapMarkerListSubIndexItem)this.getIndexItem();
                item.read(this.m_indexFile);
                this.m_list.add(item);
            }
        }
        this.m_sorted = false;
    }

    protected void sort() {
        if (this.m_sorted) {
            return;
        }
        Collections.sort(this.m_list);
        this.m_sorted = true;
    }

    @Override
    public long write() throws IOException {
        this.m_indexFile.seek(this.m_indexFile.length());
        long offset = this.m_indexFile.getFilePointer();
        if (this.m_isTerminal) {
            this.m_indexFile.writeShort(this.m_list.size());
            this.sort();
            for (MapMarkerListSubIndexItem item : this.m_list) {
                item.write(this.m_indexFile);
            }
        } else {
            this.m_indexFile.writeShort(this.m_list.size());
            this.sort();
            MapMarkerListSubIndexItem[] newItems = new MapMarkerListSubIndexItem[this.m_list.size()];
            Iterator listIterator = this.m_list.iterator();
            int i = 0;
            while (listIterator.hasNext()) {
            }
            MapMarkerListSubIndexItem originalItem = (MapMarkerListSubIndexItem)listIterator.next();
            newItems[i] = new MapMarkerListSubIndexItem(originalItem.getKey(), this.getSubIndexValue());
            long itemOffset = ((MapMarkerSubIndex)newItems[i].getValue()).write();
            MapMarkerSubIndexNextIndexValue newValue = (MapMarkerSubIndexNextIndexValue)newItems[i].getValue();
            newItems[i].setValue(newValue);
            ++i;
            this.m_indexFile.seek(offset);
            this.m_indexFile.skipBytes(2);
            for (i = 0; i < newItems.length; ++i) {
                newItems[i].write(this.m_indexFile);
            }
        }
        return offset;
    }

    @Override
    public MapMarkerSubIndexItem searchForItem(MapMarkerIndexKey key) {
        if (this.m_list == null) {
            return null;
        }
        return this.searchList(key);
    }

    @Override
    public Object search(MapMarkerIndexKey key) throws IOException {
        MapMarkerSubIndexItem item = null;
        if (this.m_readFully) {
            item = this.searchList(key);
            if (item == null) {
                return null;
            }
            return item.getValue();
        }
        item = this.searchFile(key);
        if (item == null) {
            return null;
        }
        return item.getValue();
    }

    protected MapMarkerSubIndexItem searchList(MapMarkerIndexKey key) {
        this.sort();
        for (MapMarkerListSubIndexItem item : this.m_list) {
            int keyRelation = key.compareTo((Object)item.getKey());
            if (keyRelation == 0) {
                return item;
            }
            if (keyRelation >= 0) continue;
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MapMarkerSubIndexItem searchFile(MapMarkerIndexKey key) throws IOException {
        MapMarkerListSubIndexItem item = (MapMarkerListSubIndexItem)this.getIndexItem();
        RandomAccessFile randomAccessFile = this.m_indexFile;
        synchronized (randomAccessFile) {
            this.m_indexFile.seek(this.m_indexOrigin);
            short itemCount = this.m_indexFile.readShort();
            short i = 0;
            while (i < itemCount) {
                item.read(this.m_indexFile);
                int keyRelation = key.compareTo((Object)item.getKey());
                if (keyRelation == 0) {
                    return item;
                }
                if (keyRelation <= 0) continue;
                return null;
            }
        }
        return null;
    }

    @Override
    public MapMarkerSubIndexItem getIndexItem() {
        return new MapMarkerListSubIndexItem(this.getSubIndexKey(), this.getSubIndexValue());
    }

    @Override
    public MapMarkerSubIndexItem getIndexItem(Comparable key, Object value) {
        return new MapMarkerListSubIndexItem(key, value);
    }
}

