/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBinaryIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetMultiLevelIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexStreetDataIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.SingleValueIndexFileConvertor;

public class MiSoundexMultiLevelStreetIndexFileConvertor
extends SingleValueIndexFileConvertor {
    public MiSoundexMultiLevelStreetIndexFileConvertor(String originalIndexFileName, String newIndexFileName) {
        super(originalIndexFileName, newIndexFileName);
    }

    @Override
    protected MapMarkerIndexKey getIndexKeyType() {
        return new MapMarkerStreetMultiLevelIndexKey();
    }

    @Override
    protected MapMarkerIndexValue getIndexValueType() {
        return new MiSoundexStreetDataIndexValue();
    }

    @Override
    protected MapMarkerBinaryIndexFile getIndexFileType() {
        return new MapMarkerStreetMultiLevelIndexFile();
    }

    @Override
    protected MapMarkerIndexFileMetadata getIndexMetadataType() {
        return new MapMarkerMultiLevelIndexFileMetadata(3);
    }

    public static final void main(String[] args) {
        if (args.length != 2) {
            System.err.println("MiSoundexMultiLevelStreetIndexFileConvertor <original index> <new index>.");
            System.exit(1);
        }
        MiSoundexMultiLevelStreetIndexFileConvertor convertor = new MiSoundexMultiLevelStreetIndexFileConvertor(args[0], args[1]);
        try {
            convertor.convert();
        }
        catch (DataCreationException DCEx) {
            System.err.println("ERROR: Unable to convert street file.");
            System.err.println(DCEx.getMessage());
            DCEx.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

