/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.AbstractFileInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IInnerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IMultiLevelInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.INonTerminalInnerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.NonUpdatableInnerIndexLink;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MultiLevelFileInnerIndex
extends AbstractFileInnerIndex {
    private InnerIndexLink m_linkToFirstLevel = InnerIndexLink.getNoLinkLink();

    public MultiLevelFileInnerIndex(RandomAccessFile file, IMultiLevelInnerIndexHelper helper) {
        super(file, helper);
    }

    @Override
    public void create(InnerIndexLink link) throws IndexAccessException {
        RandomAccessFile file = this.getIndexFile();
        try {
            file.seek(file.length());
            link.setLink(file.getFilePointer());
            this.m_linkToFirstLevel.write(file);
            link.update(file);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5000, (Throwable)IOEx);
        }
    }

    @Override
    public void access(InnerIndexLink link) throws IndexAccessException {
        RandomAccessFile file = this.getIndexFile();
        try {
            file.seek(link.getLink());
            this.m_linkToFirstLevel.read(file);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
    }

    @Override
    public boolean insert(MapMarkerIndexKey key, MapMarkerIndexValue value) throws IndexAccessException {
        IInnerSubIndex currentLevel;
        int i;
        IMultiLevelInnerIndexHelper helper = (IMultiLevelInnerIndexHelper)this.getHelper();
        MapMarkerMultiLevelIndexKey multiKey = (MapMarkerMultiLevelIndexKey)key;
        InnerIndexLink link = this.m_linkToFirstLevel;
        for (i = 0; i < helper.getNumberOfLevels() - 1; ++i) {
            currentLevel = helper.getIndexForLevel(i, this.getIndexFile());
            if (link.isLink()) {
                currentLevel.access(link);
            } else {
                currentLevel.create(link);
            }
            link = ((INonTerminalInnerSubIndex)((Object)currentLevel)).getNextIndexLevelLink(multiKey.getKeyAt(i));
        }
        currentLevel = helper.getIndexForLevel(i, this.getIndexFile());
        if (link.isLink()) {
            currentLevel.access(link);
        } else {
            currentLevel.create(link);
        }
        return currentLevel.insert(multiKey.getKeyAt(i), value);
    }

    @Override
    public void write(InnerIndexLink link, RandomAccessFile outputFile) throws IndexAccessException {
        InnerIndexLink subIndexLink;
        int i;
        try {
            outputFile.seek(outputFile.length());
            link.setLink(outputFile.getFilePointer());
            link.update(outputFile);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
        NonUpdatableInnerIndexLink noUpdateLink = new NonUpdatableInnerIndexLink(this.m_linkToFirstLevel);
        IMultiLevelInnerIndexHelper helper = (IMultiLevelInnerIndexHelper)this.getHelper();
        List[] subIndexLinkLists = new List[helper.getNumberOfLevels()];
        for (int i2 = 0; i2 < helper.getNumberOfLevels(); ++i2) {
            subIndexLinkLists[i2] = new LinkedList();
        }
        subIndexLinkLists[0].add(noUpdateLink);
        for (i = 0; i < helper.getNumberOfLevels() - 1; ++i) {
            DataCreationLogger.getLogger().logStatus("Writing level " + i + " containing " + subIndexLinkLists[i].size() + " sub-indexes.");
            Iterator nonTerminalLinksIterator = subIndexLinkLists[i].iterator();
            while (nonTerminalLinksIterator.hasNext()) {
                subIndexLink = (InnerIndexLink)nonTerminalLinksIterator.next();
                nonTerminalLinksIterator.remove();
                IInnerSubIndex currentLevel = helper.getIndexForLevel(i, this.getIndexFile());
                currentLevel.access(subIndexLink);
                currentLevel.write(subIndexLink, outputFile);
                subIndexLinkLists[i + 1].addAll(((INonTerminalInnerSubIndex)((Object)currentLevel)).getNextLevelSubIndexLinks());
            }
        }
        Iterator terminalSubIndexLinksIterator = subIndexLinkLists[i].iterator();
        DataCreationLogger.getLogger().logStatus("Writing level " + i + " containing " + subIndexLinkLists[i].size() + " sub-indexes.");
        while (terminalSubIndexLinksIterator.hasNext()) {
            subIndexLink = (InnerIndexLink)terminalSubIndexLinksIterator.next();
            terminalSubIndexLinksIterator.remove();
            IInnerSubIndex currentLevel = helper.getIndexForLevel(i, this.getIndexFile());
            currentLevel.access(subIndexLink);
            currentLevel.write(subIndexLink, outputFile);
        }
    }
}

