/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.AbstractNIOInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.INIOInnerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.INIOMultiLevelInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.INonTerminalInnerSubIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.NonUpdatableNIOInnerIndexLink;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class MultiLevelNIOInnerIndex
extends AbstractNIOInnerIndex {
    private NIOInnerIndexLink m_linkToFirstLevel = new NIOInnerIndexLink();

    public MultiLevelNIOInnerIndex(RandomAccessDataStream stream, INIOMultiLevelInnerIndexHelper helper) {
        super(stream, helper);
    }

    protected NIOInnerIndexLink getLinkToFirstLevel() {
        return this.m_linkToFirstLevel;
    }

    @Override
    public void create(NIOInnerIndexLink link) throws IndexAccessException {
        RandomAccessDataStream file = this.getIndexFile();
        try {
            file.seek(file.length());
            link.setLink(file.getFilePointer());
            this.m_linkToFirstLevel.write((DataOutput)file);
            link.update(file);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5000, (Throwable)IOEx);
        }
    }

    @Override
    public void access(NIOInnerIndexLink link) throws IndexAccessException {
        RandomAccessDataStream file = this.getIndexFile();
        try {
            file.seek(link.getLink());
            this.m_linkToFirstLevel.read((DataInput)file);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
    }

    @Override
    public boolean insert(MapMarkerIndexKey key, MapMarkerIndexValue value) throws IndexAccessException {
        INIOInnerSubIndex currentLevel;
        int i;
        INIOMultiLevelInnerIndexHelper helper = (INIOMultiLevelInnerIndexHelper)this.getHelper();
        MapMarkerMultiLevelIndexKey multiKey = (MapMarkerMultiLevelIndexKey)key;
        NIOInnerIndexLink link = this.m_linkToFirstLevel;
        for (i = 0; i < helper.getNumberOfLevels() - 1; ++i) {
            currentLevel = helper.getIndexForLevel(i, this.getIndexFile());
            if (link.isLink()) {
                currentLevel.access(link);
            } else {
                currentLevel.create(link);
            }
            link = (NIOInnerIndexLink)((INonTerminalInnerSubIndex)((Object)currentLevel)).getNextIndexLevelLink(multiKey.getKeyAt(i));
        }
        currentLevel = helper.getIndexForLevel(i, this.getIndexFile());
        if (link.isLink()) {
            currentLevel.access(link);
        } else {
            currentLevel.create(link);
        }
        return currentLevel.insert(multiKey.getKeyAt(i), value);
    }

    @Override
    public void write(NIOInnerIndexLink link, RandomAccessDataStream outputFile) throws IndexAccessException {
        NIOInnerIndexLink subIndexLink;
        int i;
        try {
            outputFile.seek(outputFile.length());
            link.setLink(outputFile.getFilePointer());
            link.update(outputFile);
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5002, (Throwable)IOEx);
        }
        NonUpdatableNIOInnerIndexLink noUpdateLink = new NonUpdatableNIOInnerIndexLink(this.m_linkToFirstLevel);
        INIOMultiLevelInnerIndexHelper helper = (INIOMultiLevelInnerIndexHelper)this.getHelper();
        List[] subIndexLinkLists = new List[helper.getNumberOfLevels()];
        for (int i2 = 0; i2 < helper.getNumberOfLevels(); ++i2) {
            subIndexLinkLists[i2] = new LinkedList();
        }
        subIndexLinkLists[0].add(noUpdateLink);
        for (i = 0; i < helper.getNumberOfLevels() - 1; ++i) {
            DataCreationLogger.getLogger().logStatus("Writing level " + i + " containing " + subIndexLinkLists[i].size() + " sub-indexes.");
            Iterator nonTerminalLinksIterator = subIndexLinkLists[i].iterator();
            while (nonTerminalLinksIterator.hasNext()) {
                subIndexLink = (NIOInnerIndexLink)nonTerminalLinksIterator.next();
                nonTerminalLinksIterator.remove();
                INIOInnerSubIndex currentLevel = helper.getIndexForLevel(i, this.getIndexFile());
                currentLevel.access(subIndexLink);
                currentLevel.write(subIndexLink, outputFile);
                subIndexLinkLists[i + 1].addAll(((INonTerminalInnerSubIndex)((Object)currentLevel)).getNextLevelSubIndexLinks());
            }
        }
        Iterator terminalSubIndexLinksIterator = subIndexLinkLists[i].iterator();
        DataCreationLogger.getLogger().logStatus("Writing level " + i + " containing " + subIndexLinkLists[i].size() + " sub-indexes.");
        while (terminalSubIndexLinksIterator.hasNext()) {
            subIndexLink = (NIOInnerIndexLink)terminalSubIndexLinksIterator.next();
            terminalSubIndexLinksIterator.remove();
            INIOInnerSubIndex currentLevel = helper.getIndexForLevel(i, this.getIndexFile());
            currentLevel.access(subIndexLink);
            currentLevel.write(subIndexLink, outputFile);
        }
    }
}

