/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBinaryIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerMultiLevelIndexFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetAlternateDataMiSoundexIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MultiValueIndexFileConvertor;

public class MultiValueMiSoundexIndexFileConvertor
extends MultiValueIndexFileConvertor {
    public MultiValueMiSoundexIndexFileConvertor(String originalIndexFileName, String newIndexFileName) {
        super(originalIndexFileName, newIndexFileName);
    }

    @Override
    protected MapMarkerIndexKey getIndexKeyType() {
        return new MapMarkerStreetMultiLevelIndexKey();
    }

    @Override
    protected MapMarkerBinaryIndexFile getIndexFileType() {
        return new MapMarkerStreetAlternateDataMiSoundexIndexFile();
    }

    @Override
    protected MapMarkerIndexFileMetadata getIndexMetadataType() {
        return new MapMarkerMultiLevelIndexFileMetadata(3);
    }

    public static final void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: MultiValueMiSoundexIndexFileConvertor <temp_index> <final_index>");
            System.exit(1);
        }
        DataCreationLogger.getLogger().setErrorLog((String)null, true);
        DataCreationLogger.getLogger().setInternalErrorLog((String)null, true);
        DataCreationLogger.getLogger().setStatusLog((String)null, true);
        MultiValueMiSoundexIndexFileConvertor convertor = new MultiValueMiSoundexIndexFileConvertor(args[0], args[1]);
        try {
            convertor.convert();
        }
        catch (DataCreationException DCEx) {
            System.err.println("ERROR: Unable to convert index file.");
            System.err.println(DCEx.getMessage());
            DCEx.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

