/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.utils.IRandomAccessStream;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class NIOInnerIndexLink
extends InnerIndexLink {
    public NIOInnerIndexLink() {
    }

    public NIOInnerIndexLink(long link) {
        super(link);
    }

    @Override
    public void write(DataOutput out) throws IOException {
        this.setLinkToLink(((IRandomAccessStream)out).getFilePointer());
        out.writeLong(this.getLink());
    }

    @Override
    public void read(DataInput in) throws IOException {
        this.setLinkToLink(((IRandomAccessStream)in).getFilePointer());
        this.setLink(in.readLong());
    }

    public void update(RandomAccessDataStream stream) throws IOException {
        if (this.getLinkToLink() != -1L) {
            long currentOffset = stream.getFilePointer();
            stream.seek(this.getLinkToLink());
            this.write((DataOutput)stream);
            stream.seek(currentOffset);
        }
    }
}

