/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.BinaryTreeFileInnerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.FileInnerIndexItem;
import com.mapinfo.mapmarker.common.dp.binary.index.IFileInnerIndexHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexAccessException;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.RedBlackTreeFileInnerIndexItem;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RedBlackTreeFileInnerIndex
extends BinaryTreeFileInnerIndex {
    public RedBlackTreeFileInnerIndex(RandomAccessFile file, IFileInnerIndexHelper helper) {
        super(file, helper);
    }

    @Override
    public void create(InnerIndexLink link) throws IndexAccessException {
        super.create(link);
        try {
            this.makeBlack(this.m_Z.getSelfLink());
        }
        catch (IOException IOEx) {
            throw new IndexAccessException(5000, (Throwable)IOEx);
        }
    }

    @Override
    protected void addEntry(InnerIndexLink link, FileInnerIndexItem item) throws IOException {
        super.addEntry(link, item);
        this.findParent((RedBlackTreeFileInnerIndexItem)item);
        this.balance(item.getSelfLink());
    }

    private void findParent(RedBlackTreeFileInnerIndexItem item) throws IOException {
        if (item.getSelfLink().equals(this.getRoot())) {
            return;
        }
        InnerIndexLink link = this.getRoot();
        while (true) {
            RedBlackTreeFileInnerIndexItem parent;
            if ((parent = (RedBlackTreeFileInnerIndexItem)this.getItemAt(link)).getLeftLink().equals(item.getSelfLink()) || parent.getRightLink().equals(item.getSelfLink())) {
                InnerIndexLink parentLink = item.getParent();
                parentLink.setLink(parent.getSelfLink().getLink());
                this.updateLink(parentLink);
                return;
            }
            int keyRelation = item.getKey().compareTo((Object)parent.getKey());
            if (keyRelation < 0) {
                link = parent.getLeftLink();
                continue;
            }
            if (keyRelation <= 0) continue;
            link = parent.getRightLink();
        }
    }

    private void balance(InnerIndexLink node) throws IOException {
        while (!this.getRoot().equals(node) && this.isRed(this.getParentLink(node))) {
            InnerIndexLink uncle;
            if (this.getParentLink(node).equals(this.getLeftLink(this.getParentLink(this.getParentLink(node))))) {
                uncle = this.getRightLink(this.getParentLink(this.getParentLink(node)));
                if (this.isRed(uncle)) {
                    this.makeBlack(this.getParentLink(node));
                    this.makeBlack(uncle);
                    this.makeRed(this.getParentLink(this.getParentLink(node)));
                    node = this.getParentLink(this.getParentLink(node));
                    continue;
                }
                if (node.equals(this.getRightLink(this.getParentLink(node)))) {
                    node = this.getParentLink(node);
                    this.leftRotate(node);
                }
                this.makeBlack(this.getParentLink(node));
                this.makeRed(this.getParentLink(this.getParentLink(node)));
                this.rightRotate(this.getParentLink(this.getParentLink(node)));
                continue;
            }
            uncle = this.getLeftLink(this.getParentLink(this.getParentLink(node)));
            if (this.isRed(uncle)) {
                this.makeBlack(this.getParentLink(node));
                this.makeBlack(uncle);
                this.makeRed(this.getParentLink(this.getParentLink(node)));
                node = this.getParentLink(this.getParentLink(node));
                continue;
            }
            if (node.equals(this.getLeftLink(this.getParentLink(node)))) {
                node = this.getParentLink(node);
                this.rightRotate(node);
            }
            this.makeBlack(this.getParentLink(node));
            this.makeRed(this.getParentLink(this.getParentLink(node)));
            this.leftRotate(this.getParentLink(this.getParentLink(node)));
        }
        this.makeBlack(this.getRoot());
    }

    private InnerIndexLink updateLink(InnerIndexLink dest, InnerIndexLink src) throws IOException {
        return this.updateLink(dest, src.getLink());
    }

    private InnerIndexLink updateLink(InnerIndexLink dest, long src) throws IOException {
        dest.setLink(src);
        this.updateLink(dest);
        return dest;
    }

    private void leftRotate(InnerIndexLink node) throws IOException {
        InnerIndexLink y = this.getRightLink(node);
        InnerIndexLink t = this.updateLink(this.getRightLink(node), this.getLeftLink(y));
        if (t.isLink()) {
            this.updateLink(this.getParentLink(t), node);
        }
        this.updateLink(this.getParentLink(y), this.getParentLink(node));
        if (!this.getParentLink(node).isLink()) {
            this.updateLink(this.getRoot(), y.getLink());
        } else {
            t = node.equals(this.getLeftLink(this.getParentLink(node))) ? this.getLeftLink(this.getParentLink(node)) : this.getRightLink(this.getParentLink(node));
            this.updateLink(t, y);
        }
        this.updateLink(this.getLeftLink(y), node);
        this.updateLink(this.getParentLink(node), y);
    }

    private void rightRotate(InnerIndexLink node) throws IOException {
        InnerIndexLink y = this.getLeftLink(node);
        InnerIndexLink t = this.updateLink(this.getLeftLink(node), this.getRightLink(y));
        if (t.isLink()) {
            this.updateLink(this.getParentLink(t), node);
        }
        this.updateLink(this.getParentLink(y), this.getParentLink(node));
        if (!this.getParentLink(node).isLink()) {
            this.updateLink(this.getRoot(), y.getLink());
        } else {
            t = node.equals(this.getLeftLink(this.getParentLink(node))) ? this.getLeftLink(this.getParentLink(node)) : this.getRightLink(this.getParentLink(node));
            this.updateLink(t, y);
        }
        this.updateLink(this.getRightLink(y), node);
        this.updateLink(this.getParentLink(node), y);
    }

    private void updateItem(RedBlackTreeFileInnerIndexItem item) throws IOException {
        RandomAccessFile file = this.getIndexFile();
        file.seek(item.getSelfLink().getLink());
        item.write(file);
    }

    private InnerIndexLink getParentLink(InnerIndexLink link) throws IOException {
        return ((RedBlackTreeFileInnerIndexItem)this.getItemAt(link)).getParent();
    }

    private boolean isRed(InnerIndexLink link) throws IOException {
        return ((RedBlackTreeFileInnerIndexItem)this.getItemAt(link)).isRed();
    }

    private void makeRed(InnerIndexLink link) throws IOException {
        if (this.isRed(link)) {
            return;
        }
        RedBlackTreeFileInnerIndexItem item = (RedBlackTreeFileInnerIndexItem)this.getItemAt(link);
        item.makeRed();
        this.updateItem(item);
    }

    protected void makeBlack(InnerIndexLink link) throws IOException {
        if (!this.isRed(link)) {
            return;
        }
        RedBlackTreeFileInnerIndexItem item = (RedBlackTreeFileInnerIndexItem)this.getItemAt(link);
        item.makeBlack();
        this.updateItem(item);
    }
}

