/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.FileInnerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeFileInnerIndexItem;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RedBlackTreeFileInnerIndexItem
extends TreeFileInnerIndexItem {
    private InnerIndexLink m_parent = InnerIndexLink.getNoLinkLink();
    private boolean m_bIsRed;

    public RedBlackTreeFileInnerIndexItem(MapMarkerIndexKey key, FileInnerIndexValue value) {
        super(key, value);
        this.makeRed();
    }

    public boolean isRed() {
        return this.m_bIsRed;
    }

    public void makeRed() {
        this.m_bIsRed = true;
    }

    public void makeBlack() {
        this.m_bIsRed = false;
    }

    public InnerIndexLink getParent() {
        return this.m_parent;
    }

    @Override
    public void write(RandomAccessFile out) throws IOException {
        super.write(out);
        this.m_parent.write(out);
        out.writeBoolean(this.m_bIsRed);
    }

    @Override
    public void read(RandomAccessFile in) throws IOException {
        super.read(in);
        this.m_parent.read(in);
        this.m_bIsRed = in.readBoolean();
    }
}

