/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.binary.index;

import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.TreeNIOInnerIndexItem;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class RedBlackTreeNIOInnerIndexItem
extends TreeNIOInnerIndexItem {
    private NIOInnerIndexLink m_parent = new NIOInnerIndexLink();
    private boolean m_bIsRed;

    public RedBlackTreeNIOInnerIndexItem(MapMarkerIndexKey key, NIOInnerIndexValue value) {
        super(key, value);
        this.makeRed();
    }

    public boolean isRed() {
        return this.m_bIsRed;
    }

    public void makeRed() {
        this.m_bIsRed = true;
    }

    public void makeBlack() {
        this.m_bIsRed = false;
    }

    public NIOInnerIndexLink getParent() {
        return this.m_parent;
    }

    @Override
    public void write(RandomAccessDataStream out) throws IOException {
        super.write(out);
        this.m_parent.write((DataOutput)out);
        out.writeBoolean(this.m_bIsRed);
    }

    @Override
    public void read(RandomAccessDataStream in) throws IOException {
        super.read(in);
        this.m_parent.read((DataInput)in);
        this.m_bIsRed = in.readBoolean();
    }
}

