/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.intermediate;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.File;
import java.io.IOException;

public abstract class AbstractFileTempDataRecordHandler
implements ITempDataRecordHandler {
    private String m_path;
    private File m_file;
    private RandomAccessDataStream m_dataFile;

    public AbstractFileTempDataRecordHandler(String path) {
        this.m_path = path;
    }

    @Override
    public void open() throws DataSourceException {
        try {
            this.m_file = File.createTempFile("tmp", null, new File(this.m_path));
            this.m_dataFile = new RandomAccessDataStream(this.m_file);
        }
        catch (IOException IOEx) {
            throw new DataSourceException("Unable to create file in: " + this.m_path, (Throwable)IOEx);
        }
    }

    @Override
    public void close() throws DataSourceException {
        if (this.m_dataFile == null && this.m_file == null) {
            DataCreationLogger.getLogger().logInternalError("AbstractFileTempDataRecordHandler never opened");
            return;
        }
        try {
            this.m_dataFile.close();
            this.m_file.delete();
        }
        catch (IOException IOEx) {
            throw new DataSourceException("Unable to close", (Throwable)IOEx);
        }
    }

    protected RandomAccessDataStream getDataFile() {
        return this.m_dataFile;
    }
}

