/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.intermediate;

import com.mapinfo.mapmarker.common.dp.binary.IDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateDataItem;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateSegmentDataItem;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class IntermediateStreetDataItem
extends IntermediateDataItem
implements IDataItem {
    private IntermediateSegmentDataItem m_segment;
    private ArrayList m_browseKeys;

    public void setSegment(IntermediateSegmentDataItem segment) {
        this.m_segment = segment;
    }

    public IntermediateSegmentDataItem getSegment() {
        return this.m_segment;
    }

    public void setBrowseKeys(ArrayList keys) {
        this.m_browseKeys = keys;
    }

    public ArrayList getBrowseKeys() {
        return this.m_browseKeys;
    }

    public void writeBrowseKeys(DataOutput out) throws IOException, MMJEDataCorruptedException {
        if (this.m_browseKeys != null) {
            int numKeys = this.m_browseKeys.size();
            out.writeByte(numKeys);
            for (int i = 0; i < numKeys; ++i) {
                MapMarkerBrowseMultiLevelIndexKey key = (MapMarkerBrowseMultiLevelIndexKey)this.m_browseKeys.get(i);
                key.write(out);
            }
        } else {
            out.writeByte(0);
        }
    }

    @Override
    public void write(DataOutput out) throws IOException, MMJEDataCorruptedException {
        super.write(out);
        this.writeBrowseKeys(out);
        this.m_segment.write(out);
    }

    public void addBrowseKey(MapMarkerBrowseMultiLevelIndexKey key) {
        if (this.m_browseKeys == null) {
            this.m_browseKeys = new ArrayList();
        }
        this.m_browseKeys.add(key);
    }

    public void readBrowseKeys(DataInput in) throws IOException, MMJEDataCorruptedException {
        int numKeys = in.readUnsignedByte();
        for (int i = 0; i < numKeys; ++i) {
            MapMarkerBrowseMultiLevelIndexKey key = new MapMarkerBrowseMultiLevelIndexKey();
            key.read(in);
            this.addBrowseKey(key);
        }
    }

    protected IntermediateSegmentDataItem getIntermediateSegmentDataItemType() {
        return new IntermediateSegmentDataItem();
    }

    @Override
    public void read(DataInput in) throws IOException, MMJEDataCorruptedException {
        super.read(in);
        this.readBrowseKeys(in);
        this.m_segment = this.getIntermediateSegmentDataItemType();
        this.m_segment.read(in);
    }
}

