/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.intermediate;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.TempDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.index.InnerIndexLink;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.NIOInnerIndexLink;
import com.mapinfo.mapmarker.common.dp.intermediate.AbstractFileTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.IDataRecordID;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateFileStreetDataRecordID;
import com.mapinfo.mapmarker.utils.RandomAccessDataStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class ListFileTempDataRecordHandler
extends AbstractFileTempDataRecordHandler {
    List m_keys;
    Iterator m_keyIterator;

    public ListFileTempDataRecordHandler(String path) {
        super(path);
    }

    @Override
    public void open() throws DataSourceException {
        super.open();
        this.m_keys = new ArrayList();
    }

    @Override
    public void close() throws DataSourceException {
        super.close();
        if (this.m_keys == null) {
            DataCreationLogger.getLogger().logInternalError("ListFileTempDataRecordHandler never opened");
            return;
        }
        this.m_keys.clear();
        this.m_keys = null;
        this.m_keyIterator = null;
    }

    @Override
    public void addTempDataRecord(TempDataRecord record) throws DataSourceException {
        KeyListEntry entry = new KeyListEntry(record.getRecordKey());
        int index = this.m_keys.indexOf(entry);
        if (index < 0) {
            this.m_keys.add(entry);
        } else {
            entry = (KeyListEntry)this.m_keys.get(index);
        }
        try {
            entry.addID(this.getDataFile(), (IDataRecordID)record.getDataRecordIDs().get(0));
        }
        catch (IOException IOEx) {
            throw new DataSourceException("Unable to add ID.", (Throwable)IOEx);
        }
    }

    @Override
    public boolean hasNextTempDataRecord() {
        if (this.m_keyIterator == null) {
            this.sortAndSetupIterator();
        }
        return this.m_keyIterator.hasNext();
    }

    @Override
    public TempDataRecord getNextTempDataRecord() throws DataSourceException {
        if (this.m_keyIterator == null) {
            this.sortAndSetupIterator();
        }
        TempDataRecord record = null;
        if (this.m_keyIterator.hasNext()) {
            KeyListEntry entry = (KeyListEntry)this.m_keyIterator.next();
            this.m_keyIterator.remove();
            try {
                record = entry.getTempDataRecord(this.getDataFile());
            }
            catch (IOException IOEx) {
                throw new DataSourceException("Unable to access TempDataRecord for entry.", (Throwable)IOEx);
            }
        }
        return record;
    }

    @Override
    public int getTempDataRecordCount() throws DataSourceException {
        return this.m_keys.size();
    }

    private void sortAndSetupIterator() {
        Collections.sort(this.m_keys);
        this.m_keyIterator = this.m_keys.iterator();
    }

    private static class IntermediateFileStreetDataRecordIDListEntry {
        private IntermediateFileStreetDataRecordID m_ID;
        private NIOInnerIndexLink m_next;

        public IntermediateFileStreetDataRecordIDListEntry() {
            this(null);
        }

        public IntermediateFileStreetDataRecordIDListEntry(IntermediateFileStreetDataRecordID ID) {
            this.m_ID = ID;
            this.m_next = new NIOInnerIndexLink();
        }

        public IntermediateFileStreetDataRecordID getID() {
            return this.m_ID;
        }

        public InnerIndexLink getNextLink() {
            return this.m_next;
        }

        public void write(RandomAccessDataStream stream) throws IOException {
            stream.writeLong(this.m_ID.getOffset());
            this.m_next.write((DataOutput)stream);
        }

        public void read(RandomAccessDataStream stream) throws IOException {
            this.m_ID = new IntermediateFileStreetDataRecordID(stream.readLong());
            this.m_next.read((DataInput)stream);
        }
    }

    private static class IntermediateFileStreetDataRecordIDList {
        private NIOInnerIndexLink m_head = new NIOInnerIndexLink();
        private NIOInnerIndexLink m_tail = new NIOInnerIndexLink();

        public long create(RandomAccessDataStream stream) throws IOException {
            stream.seek(stream.length());
            long offset = stream.getFilePointer();
            this.m_head.write((DataOutput)stream);
            this.m_tail.setLink(offset);
            this.m_tail.write((DataOutput)stream);
            return offset;
        }

        public void access(RandomAccessDataStream stream, long offsetToList) throws IOException {
            stream.seek(offsetToList);
            this.m_head.read((DataInput)stream);
            this.m_tail.read((DataInput)stream);
        }

        public void add(RandomAccessDataStream stream, IntermediateFileStreetDataRecordID ID) throws IOException {
            NIOInnerIndexLink link = new NIOInnerIndexLink();
            stream.seek(this.m_tail.getLink());
            link.read((DataInput)stream);
            stream.seek(stream.length());
            link.setLink(stream.getFilePointer());
            IntermediateFileStreetDataRecordIDListEntry entry = new IntermediateFileStreetDataRecordIDListEntry(ID);
            entry.write(stream);
            this.m_tail.setLink(entry.getNextLink().getLinkToLink());
            this.m_tail.update(stream);
            link.update(stream);
        }

        public IntermediateFileStreetDataRecordIDListEntry getFirstEntry(RandomAccessDataStream stream) throws IOException {
            IntermediateFileStreetDataRecordIDListEntry entry = new IntermediateFileStreetDataRecordIDListEntry();
            stream.seek(this.m_head.getLink());
            entry.read(stream);
            return entry;
        }

        public IntermediateFileStreetDataRecordIDListEntry getEntryAt(RandomAccessDataStream stream, InnerIndexLink link) throws IOException {
            IntermediateFileStreetDataRecordIDListEntry entry = null;
            if (link.isLink()) {
                entry = new IntermediateFileStreetDataRecordIDListEntry();
                stream.seek(link.getLink());
                entry.read(stream);
            }
            return entry;
        }
    }

    private static class KeyListEntry
    implements Comparable {
        private MapMarkerIndexKey m_key;
        private long m_IDListOffset;

        public KeyListEntry(MapMarkerIndexKey key) {
            this.m_key = key;
            this.m_IDListOffset = InnerIndexLink.getNoLinkLink().getLink();
        }

        public MapMarkerIndexKey getKey() {
            return this.m_key;
        }

        public void addID(RandomAccessDataStream stream, IDataRecordID ID) throws IOException {
            IntermediateFileStreetDataRecordIDList list = new IntermediateFileStreetDataRecordIDList();
            if (this.m_IDListOffset == InnerIndexLink.getNoLinkLink().getLink()) {
                this.m_IDListOffset = list.create(stream);
            } else {
                list.access(stream, this.m_IDListOffset);
            }
            list.add(stream, (IntermediateFileStreetDataRecordID)ID);
        }

        public TempDataRecord getTempDataRecord(RandomAccessDataStream stream) throws IOException {
            IntermediateFileStreetDataRecordIDList list = new IntermediateFileStreetDataRecordIDList();
            list.access(stream, this.m_IDListOffset);
            IntermediateFileStreetDataRecordIDListEntry IDEntry = list.getFirstEntry(stream);
            TempDataRecord record = new TempDataRecord(this.getKey(), IDEntry.getID());
            while ((IDEntry = list.getEntryAt(stream, IDEntry.getNextLink())) != null) {
                record.addDataRecordID(IDEntry.getID());
            }
            return record;
        }

        public int compareTo(Object that) {
            return this.m_key.compareTo((Object)((KeyListEntry)that).m_key);
        }

        public boolean equals(Object that) {
            return this.compareTo(that) == 0;
        }
    }
}

