/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.tab;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.ICentroidDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;
import java.util.Iterator;

public class TabCentroidDataSourceRecordImpl
extends TabDataSourceRecord
implements ICentroidDataSourceRecord {
    private String m_precisionFieldKey;
    private String m_useCentroidFieldKey;

    public TabCentroidDataSourceRecordImpl(TabDataSourceRecordObjects objects, String precisionFieldKey, String useCentroidFieldKey) {
        super(objects);
        this.m_precisionFieldKey = precisionFieldKey;
        this.m_useCentroidFieldKey = useCentroidFieldKey;
    }

    @Override
    public boolean hasPrecision() throws DataSourceException {
        return this.hasField(this.m_precisionFieldKey);
    }

    @Override
    public int getPrecision() throws DataSourceException {
        String fieldName = this.getFieldName(this.m_precisionFieldKey);
        if (fieldName != null) {
            return this.getFieldIntValue(fieldName);
        }
        return 0;
    }

    @Override
    public boolean hasCentroid() throws DataSourceException {
        boolean temp = this.hasField(this.m_useCentroidFieldKey);
        if (!temp) {
            return true;
        }
        String tempName = this.getFieldName(this.m_useCentroidFieldKey);
        return tempName.equals("YES");
    }

    @Override
    public DirectPosition getCentroid() throws DataSourceException {
        ArrayList points = super.getRecordPoints();
        if (points.size() != 1) {
            DataCreationLogger.getLogger().logInternalError("TabCentroidDataSourceRecord:: centroid is not a single point.");
            throw new DataSourceException(8);
        }
        Iterator it = points.iterator();
        DirectPosition centroid = (DirectPosition)it.next();
        return centroid;
    }
}

