/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.tab;

import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSource;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.data.ICursor;
import com.mapinfo.midev.data.IDataSourceTable;
import com.mapinfo.midev.data.ITable;
import com.mapinfo.midev.data.ITableMetadata;
import com.mapinfo.midev.dp.tab.NativeDataProvider;
import com.mapinfo.midev.feature.AttributeType;
import com.mapinfo.midev.feature.IAttributeDefinition;
import com.mapinfo.midev.feature.IFeature;
import com.mapinfo.midev.feature.IGeometryAttributeDefinition;
import com.mapinfo.midev.feature.util.AttributeDefinitionCollection;
import com.mapinfo.midev.table.Table;
import com.mapinfo.midev.tabledepot.TableDepot;
import java.io.File;
import java.util.Properties;

public class TabFileDataSource
implements IDataSource {
    private IDataSourceTable m_miTable;
    private ICursor m_records;
    private Properties m_dataSourceProperties;
    private ITableMetadata m_tabMetaData;
    private String m_geometryColumnName;
    private CoordSys m_coordSys;
    private int m_recordCount;

    public TabFileDataSource(Properties dataProperties) {
        this.m_dataSourceProperties = dataProperties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void open(String[] tabFileArgs) throws DataSourceException {
        String m_tabFileName;
        block14: {
            m_tabFileName = tabFileArgs[0];
            DataCreationLogger.getLogger().logStatus("Opening tab file: " + m_tabFileName);
            File tabFile = new File(m_tabFileName);
            String tabFilePath = tabFile.getAbsoluteFile().getParent();
            String tabFileName = tabFile.getName();
            if (tabFilePath == null || tabFileName == null || tabFilePath.equals("") && tabFileName.equals("")) break block14;
            int startRow = 0;
            int endRow = 0;
            if (tabFileArgs.length > 2) {
                try {
                    startRow = Integer.parseInt(tabFileArgs[1]);
                    endRow = Integer.parseInt(tabFileArgs[2]);
                }
                catch (NumberFormatException e) {
                    DataCreationLogger.getLogger().logInternalError("Exception: TabFileDataSource:: open(): Bad starting or ending row number.");
                    DataCreationLogger.getLogger().logInternalError(e.getMessage());
                    DataCreationLogger.getLogger().logStackTrace(e);
                    throw new DataSourceException(11, m_tabFileName, (Throwable)e);
                }
            }
            if (startRow >= 0 && endRow >= startRow) {
                try {
                    String query;
                    Table table;
                    TableDepot tableDepot;
                    String tableName;
                    NativeDataProvider dp = NativeDataProvider.getInstance();
                    this.m_miTable = dp.openTable(new File(tabFilePath, tabFileName));
                    if (startRow == 0 && endRow == 0) {
                        DataCreationLogger.getLogger().logStatus("Reading all records from " + m_tabFileName);
                        tableName = this.m_miTable.getDefinition().getName();
                        tableDepot = new TableDepot();
                        table = new Table(this.m_miTable);
                        tableDepot.add(tableName, (ITable)table);
                        query = "select count(*) from \"" + tableName + "\"";
                        ICursor countCursor = tableDepot.search(query);
                        this.m_recordCount = countCursor.next().getInt(0);
                        countCursor.dispose();
                        query = "select * from \"" + tableName + "\"";
                        this.m_records = tableDepot.search(query);
                    } else {
                        DataCreationLogger.getLogger().logStatus("Reading records " + startRow + " to " + endRow + " from " + m_tabFileName);
                        tableName = this.m_miTable.getDefinition().getName();
                        tableDepot = new TableDepot();
                        table = new Table(this.m_miTable);
                        tableDepot.add(tableName, (ITable)table);
                        query = "select * from \"" + tableName + "\" where MI_KEY >= " + startRow + " and MI_KEY <= " + endRow;
                        DataCreationLogger.getLogger().logStatus("From else Query with table Name " + query);
                        this.m_records = tableDepot.search(query);
                    }
                }
                catch (Exception e) {
                    DataCreationLogger.getLogger().logInternalError("Exception: TabFileDataSource:: open(): Unable to open tab file.");
                    DataCreationLogger.getLogger().logInternalError(e.getMessage());
                    DataCreationLogger.getLogger().logStackTrace(e);
                    throw new DataSourceException(10, m_tabFileName, (Throwable)e);
                }
                catch (Error e) {
                    DataCreationLogger.getLogger().logInternalError("Error: TabFileDataSource:: open(): Error reading tab file.");
                    DataCreationLogger.getLogger().logInternalError(e.getMessage());
                    DataCreationLogger.getLogger().logStackTrace(e);
                    throw new DataSourceException(10, m_tabFileName, (Throwable)e);
                }
                try {
                    this.m_tabMetaData = this.m_miTable.getMetadata();
                    AttributeDefinitionCollection attributeDefinitions = this.m_tabMetaData.getAttributeDefinitions();
                    for (IAttributeDefinition attributeDefinition : attributeDefinitions) {
                        if (attributeDefinition.getDataType() != AttributeType.FEATURE_GEOMETRY) continue;
                        this.m_coordSys = ((IGeometryAttributeDefinition)attributeDefinition).getSpatialInfo().getCoordSys();
                        this.m_geometryColumnName = attributeDefinition.getName();
                    }
                }
                catch (RuntimeException e) {
                    DataCreationLogger.getLogger().logInternalError("Error: TabFileDataSource:: open(): Error getting metadata from tab file.");
                    DataCreationLogger.getLogger().logInternalError(e.getMessage());
                    DataCreationLogger.getLogger().logStackTrace(e);
                    throw new DataSourceException(15, m_tabFileName, (Throwable)e);
                }
            } else {
                DataCreationLogger.getLogger().logInternalError("Exception: TabFileDataSource:: open(): Invalid starting (" + startRow + ") and ending (" + endRow + ") row numbers.");
                throw new DataSourceException(11, m_tabFileName, null);
            }
        }
        DataCreationLogger.getLogger().logInternalError("Error: TabFileDataSource:: open(): Could not determine path and/or filename to source tab file.");
        throw new DataSourceException(10, m_tabFileName, null);
        DataCreationLogger.getLogger().logStatus("Data source contains " + this.m_recordCount + " records.");
    }

    private static void reverse(byte[] bytes) {
        int len = bytes.length;
        for (int i = 0; i < len - 1 - i; ++i) {
            byte b = bytes[i];
            bytes[i] = bytes[len - i - 1];
            bytes[len - i - 1] = b;
        }
    }

    @Override
    public IDataSourceRecordObjects getNextDataSourceRecordObjects() throws DataSourceException {
        TabDataSourceRecordObjects dataRecordObjects = null;
        try {
            if (this.m_records != null && this.m_records.hasNext()) {
                IFeature currentRecord = this.m_records.next();
                dataRecordObjects = new TabDataSourceRecordObjects(currentRecord, this.m_tabMetaData, this.m_dataSourceProperties, this.m_geometryColumnName, this.m_coordSys);
            }
        }
        catch (Exception e) {
            throw new DataSourceException(13, (Throwable)e);
        }
        return dataRecordObjects;
    }

    @Override
    public void close() throws DataSourceException {
        if (DebugLevel.getDebugLevel((int)5) >= 1) {
            DataCreationLogger.getLogger().logMemoryUsage();
            DataCreationLogger.getLogger().logStatus("Closing tab file.");
        }
        try {
            if (this.m_records != null) {
                this.m_records.dispose();
            }
            if (this.m_miTable != null) {
                this.m_miTable.close();
            }
        }
        catch (Exception e) {
            throw new DataSourceException(12, (Throwable)e);
        }
        if (DebugLevel.getDebugLevel((int)5) >= 1) {
            DataCreationLogger.getLogger().logMemoryUsageWithGC();
        }
    }

    @Override
    public int getRecordCount() {
        return this.m_recordCount;
    }
}

