/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.common.dp.tab;

import com.mapinfo.mapmarker.common.dp.AbstractStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IAddressDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUnitDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.tab.TabAddressDataSourceRecordImpl;
import com.mapinfo.mapmarker.common.dp.tab.TabDataSourceRecordObjects;
import com.mapinfo.mapmarker.common.dp.tab.TabRangeDataSourceRecordImpl;
import com.mapinfo.mapmarker.common.dp.tab.TabSacDataSourceRecordImpl;
import com.mapinfo.mapmarker.common.dp.tab.TabSegmentDataSourceRecordImpl;
import com.mapinfo.mapmarker.common.dp.tab.TabUnitDataSourceRecordImpl;
import java.io.PrintWriter;
import java.util.ArrayList;

public class TabStreetDataSourceRecord
extends AbstractStreetDataSourceRecord {
    public TabStreetDataSourceRecord(TabDataSourceRecordObjects objects) {
        this.m_leftSacRecord = new TabSacDataSourceRecordImpl(objects, "street_leftSac");
        this.m_rightSacRecord = new TabSacDataSourceRecordImpl(objects, "street_rightSac");
        this.m_addressRecord = this.makeAddressRecord(objects);
        this.m_segmentRecord = this.makeSegmentRecord(objects);
    }

    public TabStreetDataSourceRecord(TabDataSourceRecordObjects objects, IIntermediateDataFileFormatHandler fileHandler) {
        this.m_IntermediateFileHandler = fileHandler;
        this.m_leftSacRecord = new TabSacDataSourceRecordImpl(objects, "street_leftSac");
        this.m_rightSacRecord = new TabSacDataSourceRecordImpl(objects, "street_rightSac");
        this.m_addressRecord = this.makeAddressRecord(objects);
        this.m_segmentRecord = this.makeSegmentRecord(objects);
    }

    public static void writeSampleProperties(PrintWriter writer) {
        AbstractStreetDataSourceRecord.writeSampleProperties(writer);
    }

    protected IAddressDataSourceRecord makeAddressRecord(TabDataSourceRecordObjects objects) {
        return new TabAddressDataSourceRecordImpl(objects, "street_genericField1", "street_genericField2", "street_genericField3", "street_genericField4", "street_mainAddress", "street_alternateMainAddress");
    }

    protected ISegmentDataSourceRecord makeSegmentRecord(TabDataSourceRecordObjects objects) {
        IUnitDataSourceRecord leftUnitRecord = this.makeLeftUnitRecord(objects);
        ArrayList<IUnitDataSourceRecord> leftUnits = new ArrayList<IUnitDataSourceRecord>(1);
        leftUnits.add(leftUnitRecord);
        IUnitDataSourceRecord rightUnitRecord = this.makeRightUnitRecord(objects);
        ArrayList<IUnitDataSourceRecord> rightUnits = new ArrayList<IUnitDataSourceRecord>(1);
        rightUnits.add(rightUnitRecord);
        IRangeDataSourceRecord leftRangeRecord = this.makeLeftRangeRecord(objects, leftUnits);
        IRangeDataSourceRecord rightRangeRecord = this.makeRightRangeRecord(objects, rightUnits);
        ArrayList<IRangeDataSourceRecord> ranges = new ArrayList<IRangeDataSourceRecord>(2);
        ranges.add(leftRangeRecord);
        ranges.add(rightRangeRecord);
        return this.makeSegmentRecord(objects, ranges);
    }

    protected ISegmentDataSourceRecord makeSegmentRecord(TabDataSourceRecordObjects objects, ArrayList ranges) {
        return new TabSegmentDataSourceRecordImpl(objects, "street_leftAreaName1", "street_leftAreaName2", "street_leftAreaName3", "street_leftAreaName4", "street_leftPostCode1", "street_leftPostCode2", "street_rightAreaName1", "street_rightAreaName2", "street_rightAreaName3", "street_rightAreaName4", "street_rightPostCode1", "street_rightPostCode2", "street_segmentId", ranges);
    }

    protected IUnitDataSourceRecord makeLeftUnitRecord(TabDataSourceRecordObjects objects) {
        return new TabUnitDataSourceRecordImpl(objects, "street_leftLowUnit", "street_leftHighUnit", "street_leftUnitType", "street_leftUnitPlaceName", "street_leftUnitAddFlds");
    }

    protected IUnitDataSourceRecord makeRightUnitRecord(TabDataSourceRecordObjects objects) {
        return new TabUnitDataSourceRecordImpl(objects, "street_rightLowUnit", "street_rightHighUnit", "street_rightUnitType", "street_rightUnitPlaceName", "street_rightUnitAddFlds");
    }

    protected IRangeDataSourceRecord makeLeftRangeRecord(TabDataSourceRecordObjects objects, ArrayList leftUnits) {
        return new TabRangeDataSourceRecordImpl(objects, "street_fromLeft", "street_toLeft", "street_leftRangeStatus", "street_leftPlaceName", leftUnits, true, "street_leftRangeAddFlds");
    }

    protected IRangeDataSourceRecord makeRightRangeRecord(TabDataSourceRecordObjects objects, ArrayList rightUnits) {
        return new TabRangeDataSourceRecordImpl(objects, "street_fromRight", "street_toRight", "street_rightRangeStatus", "street_rightPlaceName", rightUnits, false, "street_rightRangeAddFlds");
    }
}

