/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PublicAPI;
import java.io.Serializable;

@PublicAPI
public final class Angle
implements Serializable {
    private final AngularUnit m_unit;
    private final double m_value;
    static final double GREAT_CIRCLE_DEGREE_AS_METER = 111194.87428468118;

    public Angle(double value, AngularUnit unit) {
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)((Object)unit));
        this.m_value = value;
        this.m_unit = unit;
    }

    public AngularUnit getUnit() {
        return this.m_unit;
    }

    public double getValue() {
        return this.m_value;
    }

    public double getValue(AngularUnit au) {
        return AngularUnit.convert(this.m_value, this.m_unit, au);
    }

    public double getNormalizedValue() {
        double value = this.getValue(AngularUnit.DEGREE);
        if ((value < 0.0 || value > 360.0) && (value %= 360.0) < 0.0) {
            value += 360.0;
        }
        return AngularUnit.convert(value, AngularUnit.DEGREE, this.m_unit);
    }

    public double getNormalizedValue(AngularUnit unit) {
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)((Object)unit));
        return AngularUnit.convert(this.getNormalizedValue(), this.m_unit, unit);
    }

    public boolean equivalent(Angle angle) {
        return this.equivalent(angle, 0.0);
    }

    public boolean equivalent(Angle angle, double tolerance) {
        if (angle == null) {
            return false;
        }
        return Math.abs(angle.getValue(AngularUnit.DEGREE) - this.getValue(AngularUnit.DEGREE)) <= tolerance;
    }

    public static Length convert(Angle angle) {
        double degrees = angle.getValue(AngularUnit.DEGREE);
        double meters = degrees * 111194.87428468118;
        return new Length(meters, LinearUnit.METER);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Angle angle = (Angle)o;
        if (Double.compare(angle.m_value, this.m_value) != 0) {
            return false;
        }
        return this.m_unit == angle.m_unit;
    }

    public int hashCode() {
        int result = 17;
        result = 29 * result + this.m_unit.hashCode();
        long temp = this.m_value != 0.0 ? Double.doubleToLongBits(this.m_value) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Angle[" + this.m_value + " " + (Object)((Object)this.m_unit) + "]";
    }
}

