/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PrivateAPI;
import com.mapinfo.midev.util.PublicAPI;

@PublicAPI
public enum AreaUnit {
    SQUARE_INCH(Math.pow(LinearUnit.INCH.getMetersPerUnit(), 2.0), "sq in", "square inch"),
    SQUARE_FOOT(Math.pow(LinearUnit.FOOT.getMetersPerUnit(), 2.0), "sq ft", "square foot"),
    SQUARE_YARD(Math.pow(LinearUnit.YARD.getMetersPerUnit(), 2.0), "sq yd", "square yard"),
    SQUARE_MILE(Math.pow(LinearUnit.MILE.getMetersPerUnit(), 2.0), "sq mi", "square mile"),
    SQUARE_MILLIMETER(Math.pow(LinearUnit.MILLIMETER.getMetersPerUnit(), 2.0), "sq mm", "square millimeter"),
    SQUARE_CENTIMETER(Math.pow(LinearUnit.CENTIMETER.getMetersPerUnit(), 2.0), "sq cm", "square centimeter"),
    SQUARE_METER(Math.pow(LinearUnit.METER.getMetersPerUnit(), 2.0), "sq m", "square meter"),
    SQUARE_KILOMETER(Math.pow(LinearUnit.KILOMETER.getMetersPerUnit(), 2.0), "sq km", "square kilometer"),
    SQUARE_SURVEY_FOOT(Math.pow(LinearUnit.SURVEY_FOOT.getMetersPerUnit(), 2.0), "sq sft", "square survey foot"),
    SQUARE_NAUTICAL_MILE(Math.pow(LinearUnit.NAUTICAL_MILE.getMetersPerUnit(), 2.0), "sq nmi", "square nautical mile"),
    SQUARE_LINK(Math.pow(LinearUnit.LINK.getMetersPerUnit(), 2.0), "sq li", "square link"),
    SQUARE_CHAIN(Math.pow(LinearUnit.CHAIN.getMetersPerUnit(), 2.0), "sq ch", "square chain"),
    SQUARE_ROD(Math.pow(LinearUnit.ROD.getMetersPerUnit(), 2.0), "sq rd", "square rod"),
    ACRE(4046.8564224, "acre", "acre"),
    ARE(100.0, "a", "are"),
    HECTARE(10000.0, "ha", "hectare"),
    PERCH(25.29285264, "perch", "perch"),
    ROOD(1011.7141056, "rood", "rood");

    private final String m_mapInfoCode;
    private final String m_displayName;
    private final double m_squareMetersPerUnit;

    private AreaUnit(double squareMetersPerUnit, String mapInfoCode, String displayName) {
        this.m_squareMetersPerUnit = squareMetersPerUnit;
        this.m_mapInfoCode = mapInfoCode;
        this.m_displayName = displayName;
    }

    public double getSquareMetersPerUnit() {
        return this.m_squareMetersPerUnit;
    }

    @PrivateAPI
    public String getMapInfoCode() {
        return this.m_mapInfoCode;
    }

    @PrivateAPI
    public String getDisplayName() {
        return this.m_displayName;
    }

    public static double convert(double area, AreaUnit fromUnit, AreaUnit toUnit) {
        ArgumentValidator.assertNotNullReference((String)"fromUnit", (Object)((Object)fromUnit));
        ArgumentValidator.assertNotNullReference((String)"toUnit", (Object)((Object)toUnit));
        double result = area;
        if (fromUnit != toUnit) {
            result = area * (fromUnit.m_squareMetersPerUnit / toUnit.m_squareMetersPerUnit);
        }
        return result;
    }

    @PrivateAPI
    public static AreaUnit getFromMapInfoCode(String code) {
        ArgumentValidator.assertNotNullReference((String)"code", (Object)code);
        String trimmedCode = AreaUnit.trim(code);
        for (AreaUnit areaUnit : AreaUnit.values()) {
            if (!trimmedCode.equals(areaUnit.m_mapInfoCode)) continue;
            return areaUnit;
        }
        return null;
    }

    private static String trim(String inputString) {
        return inputString.trim().replaceAll("\\s+", " ").toLowerCase();
    }

    @PrivateAPI
    public static AreaUnit fromLinearUnit(LinearUnit linearUnit) {
        try {
            return AreaUnit.valueOf("SQUARE_" + linearUnit.name());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

