/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.unit.PaperUnit;
import com.mapinfo.midev.util.ArgumentValidator;
import java.io.Serializable;

public final class PaperDimension
implements Serializable {
    private final double m_width;
    private final double m_height;
    private final PaperUnit m_unit;

    public PaperDimension(double width, double height, PaperUnit unit) {
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)unit);
        if (width <= 0.0) {
            throw new IllegalArgumentException("Width must be greater than 0: " + width);
        }
        if (height <= 0.0) {
            throw new IllegalArgumentException("Height must be greater than 0: " + height);
        }
        this.m_width = width;
        this.m_height = height;
        this.m_unit = unit;
    }

    public double getWidth() {
        return this.m_width;
    }

    public double getHeight() {
        return this.m_height;
    }

    public PaperUnit getUnit() {
        return this.m_unit;
    }

    public static PaperDimension convert(PaperDimension dimension, PaperUnit unit, Integer dotsPerInch) {
        ArgumentValidator.assertNotNullReference((String)"dimension", (Object)dimension);
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)unit);
        if (unit == dimension.m_unit) {
            return dimension;
        }
        double width = PaperUnit.convert(dimension.m_width, dimension.m_unit, unit, dotsPerInch);
        double height = PaperUnit.convert(dimension.m_height, dimension.m_unit, unit, dotsPerInch);
        return new PaperDimension(width, height, unit);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaperDimension that = (PaperDimension)o;
        if (Double.compare(that.m_height, this.m_height) != 0) {
            return false;
        }
        if (Double.compare(that.m_width, this.m_width) != 0) {
            return false;
        }
        return this.m_unit == that.m_unit;
    }

    public int hashCode() {
        long temp = this.m_width != 0.0 ? Double.doubleToLongBits(this.m_width) : 0L;
        int result = (int)(temp ^ temp >>> 32);
        temp = this.m_height != 0.0 ? Double.doubleToLongBits(this.m_height) : 0L;
        result = 29 * result + (int)(temp ^ temp >>> 32);
        result = 29 * result + this.m_unit.hashCode();
        return result;
    }

    public String toString() {
        return "PaperDimension{m_width=" + this.m_width + ", m_height=" + this.m_height + ", m_unit=" + this.m_unit + '}';
    }
}

