/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.unit.PaperUnit;
import com.mapinfo.midev.util.ArgumentValidator;
import java.io.Serializable;

public final class PaperPoint
implements Serializable {
    private final double m_x;
    private final double m_y;
    private final PaperUnit m_unit;

    public PaperPoint(double x, double y, PaperUnit unit) {
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)unit);
        this.m_unit = unit;
        this.m_x = x;
        this.m_y = y;
    }

    public PaperUnit getUnit() {
        return this.m_unit;
    }

    public double getX() {
        return this.m_x;
    }

    public double getY() {
        return this.m_y;
    }

    public static PaperPoint convert(PaperPoint point, PaperUnit unit, Integer dotsPerInch) {
        ArgumentValidator.assertNotNullReference((String)"point", (Object)point);
        ArgumentValidator.assertNotNullReference((String)"unit", (Object)unit);
        if (unit == point.m_unit) {
            return point;
        }
        double x = PaperUnit.convert(point.getX(), point.getUnit(), unit, dotsPerInch);
        double y = PaperUnit.convert(point.getY(), point.getUnit(), unit, dotsPerInch);
        return new PaperPoint(x, y, unit);
    }
}

