/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.unit;

import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.unit.TimeUnit;

public enum VelocityUnit {
    MPH(LinearUnit.MILE, TimeUnit.HOUR),
    KPH(LinearUnit.KILOMETER, TimeUnit.HOUR),
    MTPS(LinearUnit.METER, TimeUnit.SECOND),
    MTPM(LinearUnit.METER, TimeUnit.MINUTE);

    private final LinearUnit m_linearUnit;
    private final TimeUnit m_timeUnit;

    private VelocityUnit(LinearUnit distanceUnit, TimeUnit timeUnit) {
        this.m_linearUnit = distanceUnit;
        this.m_timeUnit = timeUnit;
    }

    public LinearUnit getLinearUnit() {
        return this.m_linearUnit;
    }

    public TimeUnit getTimeUnit() {
        return this.m_timeUnit;
    }

    public static double convert(double value, VelocityUnit fromUnit, VelocityUnit toUnit) {
        double result = value;
        result = TimeUnit.convert(result, toUnit.getTimeUnit(), fromUnit.getTimeUnit());
        result = LinearUnit.convert(result, fromUnit.getLinearUnit(), toUnit.getLinearUnit());
        return result;
    }
}

