/*
 * Decompiled with CFR 0.152.
 */
package com.pb.spectrum.gav.accumulator;

import com.pb.spectrum.gav.accumulator.Accumulator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SummaryAccumulator
implements Accumulator {
    private static final Log log = LogFactory.getLog(SummaryAccumulator.class);
    private static final String TOTAL_RECORDS = "V";
    private static final String POSTAL_CODE_CORRECTED = "C";
    private static final String POSTAL_CODE_RETAINED = "P";
    private static final String POSTAL_CODE_INVALID = "U";
    private static final String COUNTRY_CODE_USA = "USA";
    private static final String COUNTRY_CODE_CAN = "CAN";
    private static final String VALIDATED_ON_INPUT = "100";
    private static final String streetMismatch = "StreetName";
    private static final String houseMismatch = "HouseNumber";
    private static final String numberRangeMismatch = "ApartmentNumber";
    private static final String StatusField = "Status";
    private static final String ConfidenceField = "Confidence";
    private static final String PrecisionField = "PrecisionCode";
    private static final String HousenumberMatchedField = "Housenumber.Matched";
    private static final String StreetNameMatchedField = "StreetName.Matched";
    private static final String CityMatchedField = "City.Matched";
    private static final String PostalcodeMatchedField = "Postalcode.Matched";
    private static final String StateProvinceMatchedField = "StateProvince.Matched";
    private Total[] totals = new Total[44];
    private int fieldCount = 0;
    private final int TOTAL_INPUT = this.newTotal("TOTAL_INPUT");
    private final int MATCHED = this.newTotal("MATCHED");
    private final int UNMATCHED = this.newTotal("UNMATCHED");
    private final int HSE_MATCHED = this.newTotal("HSE_MATCHED");
    private final int STR_MATCHED = this.newTotal("STR_MATCHED");
    private final int CTY_MATCHED = this.newTotal("CTY_MATCHED");
    private final int PCD_MATCHED = this.newTotal("PCD_MATCHED");
    private final int STE_MATCHED = this.newTotal("STE_MATCHED");
    private final int CONF_0 = this.newTotal("CONF_0");
    private final int CONF_10 = this.newTotal("CONF_10");
    private final int CONF_20 = this.newTotal("CONF_20");
    private final int CONF_30 = this.newTotal("CONF_30");
    private final int CONF_40 = this.newTotal("CONF_40");
    private final int CONF_50 = this.newTotal("CONF_50");
    private final int CONF_60 = this.newTotal("CONF_60");
    private final int CONF_70 = this.newTotal("CONF_70");
    private final int CONF_80 = this.newTotal("CONF_80");
    private final int CONF_90 = this.newTotal("CONF_90");
    private final int CONF_100 = this.newTotal("CONF_100");
    private final int CONF_LOW = this.newTotal("CONF_LOW");
    private final int CONF_MID = this.newTotal("CONF_MID");
    private final int CONF_HIGH = this.newTotal("CONF_HIGH");
    private final int PRECISION_B1 = this.newTotal("PRECISION_B1");
    private final int PRECISION_B2 = this.newTotal("PRECISION_B2");
    private final int PRECISION_Z1 = this.newTotal("PRECISION_Z1");
    private final int PRECISION_Z2 = this.newTotal("PRECISION_Z2");
    private final int PRECISION_Z3 = this.newTotal("PRECISION_Z3");
    private final int PRECISION_G1 = this.newTotal("PRECISION_G1");
    private final int PRECISION_G2 = this.newTotal("PRECISION_G2");
    private final int PRECISION_G3 = this.newTotal("PRECISION_G3");
    private final int PRECISION_G4 = this.newTotal("PRECISION_G4");
    private final int PRECISION_SX = this.newTotal("PRECISION_SX");
    private final int PRECISION_SL = this.newTotal("PRECISION_SL");
    private final int PRECISION_SG = this.newTotal("PRECISION_SG");
    private final int PRECISION_SC = this.newTotal("PRECISION_SC");
    private final int PRECISION_S0 = this.newTotal("PRECISION_S0");
    private final int PRECISION_S1 = this.newTotal("PRECISION_S1");
    private final int PRECISION_S2 = this.newTotal("PRECISION_S2");
    private final int PRECISION_S3 = this.newTotal("PRECISION_S3");
    private final int PRECISION_S4 = this.newTotal("PRECISION_S4");
    private final int PRECISION_S5 = this.newTotal("PRECISION_S5");
    private final int PRECISION_S6 = this.newTotal("PRECISION_S6");
    private final int PRECISION_S7 = this.newTotal("PRECISION_S7");
    private final int PRECISION_S8 = this.newTotal("PRECISION_S8");

    public SummaryAccumulator() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("totals.length is " + this.totals.length));
            log.debug((Object)("that last total object was inserted at position " + this.fieldCount));
        }
        assert (this.totals.length == this.fieldCount);
    }

    private int newTotal(String label) {
        this.totals[this.fieldCount] = new Total(label);
        return this.fieldCount++;
    }

    private void incrementTotals() {
        this.totals[this.TOTAL_INPUT].increment();
    }

    @Override
    public void accumulate(HashMap<String, String> input, List outputList, HashMap<String, String> options) {
        if (outputList != null) {
            int rowCount = outputList.size();
            this.incrementTotals();
            if (rowCount != 0) {
                HashMap thisRec = (HashMap)outputList.get(0);
                String status = (String)thisRec.get(StatusField);
                if (status == null) {
                    status = "";
                }
                if (status.equals("F")) {
                    this.totals[this.UNMATCHED].increment();
                } else {
                    this.totals[this.MATCHED].increment();
                }
                if (Boolean.parseBoolean((String)thisRec.get(HousenumberMatchedField))) {
                    this.totals[this.HSE_MATCHED].increment();
                }
                if (Boolean.parseBoolean((String)thisRec.get(StreetNameMatchedField))) {
                    this.totals[this.STR_MATCHED].increment();
                }
                if (Boolean.parseBoolean((String)thisRec.get(CityMatchedField))) {
                    this.totals[this.CTY_MATCHED].increment();
                }
                if (Boolean.parseBoolean((String)thisRec.get(PostalcodeMatchedField))) {
                    this.totals[this.PCD_MATCHED].increment();
                }
                if (Boolean.parseBoolean((String)thisRec.get(StateProvinceMatchedField))) {
                    this.totals[this.STE_MATCHED].increment();
                }
                if (thisRec.get(ConfidenceField) != null) {
                    int confidenceValue = Integer.parseInt((String)thisRec.get(ConfidenceField));
                    switch (confidenceValue / 10) {
                        case 0: {
                            this.totals[this.CONF_0].increment();
                            break;
                        }
                        case 1: {
                            this.totals[this.CONF_10].increment();
                            break;
                        }
                        case 2: {
                            this.totals[this.CONF_20].increment();
                            break;
                        }
                        case 3: {
                            this.totals[this.CONF_30].increment();
                            break;
                        }
                        case 4: {
                            this.totals[this.CONF_40].increment();
                            break;
                        }
                        case 5: {
                            this.totals[this.CONF_50].increment();
                            break;
                        }
                        case 6: {
                            this.totals[this.CONF_60].increment();
                            break;
                        }
                        case 7: {
                            this.totals[this.CONF_70].increment();
                            break;
                        }
                        case 8: {
                            this.totals[this.CONF_80].increment();
                            break;
                        }
                        case 9: {
                            this.totals[this.CONF_90].increment();
                            break;
                        }
                        case 10: {
                            this.totals[this.CONF_100].increment();
                        }
                    }
                    if (confidenceValue < 40) {
                        this.totals[this.CONF_LOW].increment();
                    } else if (confidenceValue < 85) {
                        this.totals[this.CONF_MID].increment();
                    } else {
                        this.totals[this.CONF_HIGH].increment();
                    }
                    switch (confidenceValue) {
                        case 0: {
                            this.totals[this.CONF_0].increment();
                            break;
                        }
                        case 1: {
                            this.totals[this.CONF_10].increment();
                            break;
                        }
                        case 2: {
                            this.totals[this.CONF_20].increment();
                            break;
                        }
                        case 3: {
                            this.totals[this.CONF_30].increment();
                            break;
                        }
                        case 4: {
                            this.totals[this.CONF_40].increment();
                            break;
                        }
                        case 5: {
                            this.totals[this.CONF_50].increment();
                            break;
                        }
                        case 6: {
                            this.totals[this.CONF_60].increment();
                            break;
                        }
                        case 7: {
                            this.totals[this.CONF_70].increment();
                            break;
                        }
                        case 8: {
                            this.totals[this.CONF_80].increment();
                            break;
                        }
                        case 9: {
                            this.totals[this.CONF_90].increment();
                            break;
                        }
                        case 10: {
                            this.totals[this.CONF_100].increment();
                        }
                    }
                }
                if (thisRec.get(PrecisionField) != null) {
                    switch (((String)thisRec.get(PrecisionField)).substring(0, 2)) {
                        case "B1": {
                            this.totals[this.PRECISION_B1].increment();
                            break;
                        }
                        case "B2": {
                            this.totals[this.PRECISION_B2].increment();
                            break;
                        }
                        case "Z1": {
                            this.totals[this.PRECISION_Z1].increment();
                            break;
                        }
                        case "Z2": {
                            this.totals[this.PRECISION_Z2].increment();
                            break;
                        }
                        case "Z3": {
                            this.totals[this.PRECISION_Z3].increment();
                            break;
                        }
                        case "G1": {
                            this.totals[this.PRECISION_G1].increment();
                            break;
                        }
                        case "G2": {
                            this.totals[this.PRECISION_G2].increment();
                            break;
                        }
                        case "G3": {
                            this.totals[this.PRECISION_G3].increment();
                            break;
                        }
                        case "G4": {
                            this.totals[this.PRECISION_G4].increment();
                            break;
                        }
                        case "SX": {
                            this.totals[this.PRECISION_SX].increment();
                            break;
                        }
                        case "SL": {
                            this.totals[this.PRECISION_SL].increment();
                            break;
                        }
                        case "SG": {
                            this.totals[this.PRECISION_SG].increment();
                            break;
                        }
                        case "SC": {
                            this.totals[this.PRECISION_SC].increment();
                            break;
                        }
                        case "S0": {
                            this.totals[this.PRECISION_S0].increment();
                            break;
                        }
                        case "S1": {
                            this.totals[this.PRECISION_S1].increment();
                            break;
                        }
                        case "S2": {
                            this.totals[this.PRECISION_S2].increment();
                            break;
                        }
                        case "S3": {
                            this.totals[this.PRECISION_S3].increment();
                            break;
                        }
                        case "S4": {
                            this.totals[this.PRECISION_S4].increment();
                            break;
                        }
                        case "S5": {
                            this.totals[this.PRECISION_S5].increment();
                            break;
                        }
                        case "S6": {
                            this.totals[this.PRECISION_S6].increment();
                            break;
                        }
                        case "S7": {
                            this.totals[this.PRECISION_S7].increment();
                            break;
                        }
                        case "S8": {
                            this.totals[this.PRECISION_S8].increment();
                        }
                    }
                }
            }
        }
    }

    @Override
    public Map generateReportMap() {
        int totalsLength = this.totals.length;
        HashMap<String, Object> reportMap = new HashMap<String, Object>(totalsLength + 1);
        for (int i = 0; i < totalsLength; ++i) {
            Total thisTotal = this.totals[i];
            reportMap.put(thisTotal.getLabel(), thisTotal.getTotal());
        }
        reportMap.put("TIME_STAMP", Long.toString(System.currentTimeMillis()));
        return reportMap;
    }

    private static class Total {
        private String label;
        private int total;

        public Total(String label) {
            this.label = label;
            this.total = 0;
        }

        public String getLabel() {
            return this.label;
        }

        public int getTotal() {
            return this.total;
        }

        public void increment() {
            ++this.total;
        }
    }
}

