/*
 * Decompiled with CFR 0.152.
 */
package com.pb.spectrum.gav.spd;

import com.pb.spectrum.gav.data.SpdInfo;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class SpdUtils {
    private static List<String> item;
    private static ArrayList<SpdInfo> spdInfoList;
    private static boolean isGTAAvailable;

    public static void getSpdInfo(Properties prop) {
        int count = Integer.parseInt((String)prop.get("DICTIONARY_COUNT"));
        spdInfoList = new ArrayList();
        for (int i = 0; i < count; ++i) {
            String spdValue;
            if (!prop.containsKey("BASE_DB" + String.valueOf(i)) || (spdValue = (String)prop.get("BASE_DB" + String.valueOf(i))) == null) continue;
            SpdInfo spdInfo = new SpdInfo();
            item = Arrays.asList(spdValue.split("\\s*;\\s*"));
            spdInfo.setQualifierName(item.get(0));
            spdInfo.setSpdPath(item.get(1));
            spdInfo.setSpdType(item.get(2));
            if (item.get(2).equalsIgnoreCase("GTA")) {
                SpdUtils.setGTAAvailable(true);
            }
            spdInfo.setCountryCode(item.get(3));
            spdInfoList.add(spdInfo);
        }
    }

    public static ArrayList<SpdInfo> getSPDInfoList() {
        return spdInfoList;
    }

    public static String buildGTACountryCode() {
        ArrayList<String> buildCountryCode = new ArrayList<String>();
        for (int i = 0; i < spdInfoList.size(); ++i) {
            if (!spdInfoList.get(i).getSpdType().equals("GTA")) continue;
            buildCountryCode.add(spdInfoList.get(i).getCountryCode());
        }
        return StringUtils.join(buildCountryCode, (String)",");
    }

    public static boolean isGTAAvailable() {
        return isGTAAvailable;
    }

    public static void setGTAAvailable(boolean gtaCheck) {
        isGTAAvailable = gtaCheck;
    }

    static {
        spdInfoList = new ArrayList();
        isGTAAvailable = false;
    }
}

