/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.index.rtree;

import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.index.rtree.IEnvelopeDecorator;
import com.mapinfo.midev.index.rtree.IRTreeEnvelopeSearch;
import com.mapinfo.midev.index.rtree.IRTreeHelper;
import com.mapinfo.midev.index.rtree.RTreeCursor;
import com.mapinfo.midev.index.rtree.RTreeUtilities;
import com.mapinfo.midev.index.rtree.RamBasedHelper;
import com.mapinfo.midev.util.PublicAPI;

@PublicAPI
public final class RTree<E> {
    private static final int DEFAULT_NODE_CAPACITY = 10;
    private final IEnvelopeDecorator<E> m_decorator;
    private final IRTreeHelper m_helper;
    private final RTreeUtilities<E> m_rTreeUtilities;

    public RTree(IEnvelopeDecorator<E> decorator) {
        this(decorator, 10, 5);
    }

    public RTree(IEnvelopeDecorator<E> decorator, int maxCapacity, int minCapacity) {
        this(decorator, new RamBasedHelper(maxCapacity, minCapacity));
    }

    public RTree(IEnvelopeDecorator<E> decorator, IRTreeHelper helper) {
        this.m_helper = helper;
        this.m_decorator = decorator;
        this.m_rTreeUtilities = new RTreeUtilities<E>(this.m_helper, this.m_decorator);
    }

    public void remove(E o) {
        this.m_rTreeUtilities.delete(o);
    }

    public void add(E o) {
        if (this.m_decorator.getEnvelope(o) != null && !this.m_decorator.getEnvelope(o).isEmpty()) {
            this.m_rTreeUtilities.insert(o);
        }
    }

    public RTreeCursor<E> search(IRTreeEnvelopeSearch rs) {
        return new RTreeCursor<E>(this.m_helper.getRootNode(), rs, this.m_decorator);
    }

    public Envelope getEnvelope() {
        return this.m_helper.getRootNode().getBounds();
    }

    public void clear() {
        this.m_helper.clear();
    }
}

