/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.index.rtree;

import com.mapinfo.midev.index.rtree.IEnvelopeDecorator;
import com.mapinfo.midev.index.rtree.IRTreeEnvelopeSearch;
import com.mapinfo.midev.index.rtree.IRTreeNode;
import com.mapinfo.midev.index.rtree.RTreeUtilities;
import com.mapinfo.midev.util.PublicAPI;
import java.util.NoSuchElementException;

@PublicAPI
public class RTreeCursor<E> {
    private final int[] m_searchStatus;
    private final IRTreeEnvelopeSearch m_rs;
    private IRTreeNode m_nextLeafEntry;
    private boolean m_hasNext;
    private final RTreeUtilities<E> m_rTreeUtilities;

    RTreeCursor(IRTreeNode root, IRTreeEnvelopeSearch rs, IEnvelopeDecorator<E> decorator) {
        this.m_rs = rs;
        this.m_rTreeUtilities = new RTreeUtilities<E>(null, decorator);
        this.m_searchStatus = new int[root.getLevel() + 1];
        if (root.size() > 0 && rs.testEnvelope(root.getBounds(), root.isLeaf())) {
            this.hasNextNode(root, 0);
        } else {
            this.m_hasNext = false;
        }
    }

    public boolean hasNext() {
        return this.m_hasNext;
    }

    public E next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        Object data = this.m_nextLeafEntry.getChild(this.m_searchStatus[0]);
        this.m_hasNext = this.findNext(this.m_nextLeafEntry);
        return (E)data;
    }

    private boolean hasNextNode(IRTreeNode node, int starPos) {
        if (node.isLeaf()) {
            for (int n = starPos; n < node.size(); ++n) {
                this.m_searchStatus[0] = n;
                if (!this.m_rs.testEnvelope(this.m_rTreeUtilities.getSubEnvelope(node, n), true)) continue;
                this.m_hasNext = true;
                this.m_nextLeafEntry = node;
                return true;
            }
        } else {
            for (int n = starPos; n < node.size(); ++n) {
                this.m_searchStatus[node.getLevel()] = n;
                if (!this.m_rs.testEnvelope(this.m_rTreeUtilities.getSubEnvelope(node, n), false) || !this.hasNextNode((IRTreeNode)node.getChild(n), 0)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean findNext(IRTreeNode node) {
        int level = node.getLevel();
        while (this.m_searchStatus[level] < node.size()) {
            int n = level;
            this.m_searchStatus[n] = this.m_searchStatus[n] + 1;
            if (!this.hasNextNode(node, this.m_searchStatus[level])) continue;
            return true;
        }
        if (node.isRoot()) {
            return false;
        }
        return this.findNext(node.getParent());
    }
}

