/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.index.rtree;

import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.index.rtree.IRTreeNode;

class RTreeNode
implements IRTreeNode {
    private Object[] m_children;
    private int m_size;
    private RTreeNode m_parent;
    private Envelope m_env;
    private int m_level;

    RTreeNode(RTreeNode parent, int maxCapacity, int level) {
        this.m_parent = parent;
        this.m_children = new Object[maxCapacity];
        this.m_level = level;
    }

    @Override
    public boolean isLeaf() {
        return this.m_level == 0;
    }

    @Override
    public boolean isRoot() {
        return this.m_parent == null;
    }

    @Override
    public RTreeNode getParent() {
        return this.m_parent;
    }

    @Override
    public void setParent(IRTreeNode parent) {
        this.m_parent = (RTreeNode)parent;
    }

    @Override
    public void clear() {
        this.m_parent = null;
        this.m_level = 0;
        this.m_children = new Object[this.m_children.length];
        this.m_size = 0;
        this.m_env.setEmpty();
    }

    @Override
    public int getLevel() {
        return this.m_level;
    }

    @Override
    public Envelope getBounds() {
        return this.m_env;
    }

    @Override
    public int size() {
        return this.m_size;
    }

    @Override
    public Object getChild(int index) {
        return this.m_children[index];
    }

    @Override
    public void setLevel(int level) {
        this.m_level = level;
    }

    @Override
    public void setBounds(Envelope env) {
        this.m_env = env;
    }

    @Override
    public void addChild(Object data) {
        this.m_children[this.m_size++] = data;
    }

    @Override
    public void removeChild(int index) {
        int numMoved = this.m_size - index - 1;
        if (numMoved > 0) {
            System.arraycopy(this.m_children, index + 1, this.m_children, index, numMoved);
        }
        --this.m_size;
        this.m_children[this.m_size] = null;
    }
}

