/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryFactory;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.util.ArgumentValidator;
import com.mapinfo.midev.util.PublicAPI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

@PublicAPI
public final class CurveBuilder {
    private final SpatialInfo m_spatialInfo;
    private final List<CurveSegment> m_curveSegments = new LinkedList<CurveSegment>();
    private IDirectPositionList m_points;

    CurveBuilder(SpatialInfo spatialInfo) {
        this.m_spatialInfo = spatialInfo;
    }

    public CurveBuilder withLineString(DirectPosition ... positions) {
        ArgumentValidator.assertNotEmpty((String)"positions", (Object[])positions);
        this.convertPointsToCurveSegment(positions[0]);
        IDirectPositionList directPositionList = GeometryFactory.createDirectPositionArray(positions);
        this.m_curveSegments.add(new LineString(this.m_spatialInfo, directPositionList));
        return this;
    }

    public CurveBuilder withLineString(Iterable<DirectPosition> positions) {
        ArgumentValidator.assertNotEmptyIterable((String)"positions", positions);
        IDirectPositionList directPositionList = GeometryFactory.createDirectPositionArray(positions);
        this.convertPointsToCurveSegment(directPositionList.getDirectPosition(0, new DirectPosition()));
        this.m_curveSegments.add(new LineString(this.m_spatialInfo, directPositionList));
        return this;
    }

    public CurveBuilder withLineString(IDirectPositionList positions) {
        if (positions.size() == 0) {
            throw new IllegalArgumentException("positions cannot be empty");
        }
        this.convertPointsToCurveSegment(positions.getDirectPosition(0, new DirectPosition()));
        this.m_curveSegments.add(new LineString(this.m_spatialInfo, positions));
        return this;
    }

    public CurveBuilder withPoint(double x, double y) {
        return this.withPoint(GeometryFactory.pos(x, y));
    }

    public CurveBuilder withPoint(String x, String y) {
        return this.withPoint(GeometryFactory.pos(x, y));
    }

    public CurveBuilder withPoint(DirectPosition position) {
        if (this.m_points == null) {
            this.m_points = new DirectPositionArray();
            if (!this.m_curveSegments.isEmpty()) {
                DirectPosition endPoint = this.m_curveSegments.get(this.m_curveSegments.size() - 1).getEndPosition();
                this.m_points.add(endPoint);
            }
        }
        this.m_points.add(position);
        return this;
    }

    public ICurve build() {
        this.convertPointsToCurveSegment(null);
        if (this.m_curveSegments.size() == 0) {
            throw new InvalidGeometryException("At least one line string is required to build a curve");
        }
        ArrayList<CurveSegment> contiguous = new ArrayList<CurveSegment>(this.m_curveSegments.size());
        DirectPosition previous = null;
        for (CurveSegment segment : this.m_curveSegments) {
            if (previous != null) {
                segment = this.makeContiguous(segment, previous);
            }
            contiguous.add(segment);
            previous = segment.getEndPosition();
        }
        return new Curve(this.m_spatialInfo, contiguous);
    }

    private CurveSegment makeContiguous(CurveSegment segment, DirectPosition previous) {
        if (segment.getStartPosition().equals((Object)previous)) {
            return segment;
        }
        if (segment.getEndPosition().equals((Object)previous)) {
            return segment.reverse();
        }
        DirectPositionArray positions = new DirectPositionArray(segment.getControlPointCount() + 1);
        positions.add(previous);
        positions.addAll(segment.getControlPoints());
        return new LineString(segment.getSpatialInfo(), positions);
    }

    private void convertPointsToCurveSegment(DirectPosition next) {
        if (this.m_points != null) {
            if (this.m_points.size() == 1 && next != null) {
                this.m_points.add(next);
            }
            this.m_curveSegments.add(new LineString(this.m_spatialInfo, this.m_points));
            this.m_points = null;
        }
    }
}

