/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IDirectPositionMutator;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.ILineString;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.InvalidGeometryConversionException;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.geometry.impl.GeometryFactory;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.MultiCurve;
import com.mapinfo.midev.geometry.impl.MultiPoint;
import com.mapinfo.midev.geometry.impl.MultiPolygon;
import com.mapinfo.midev.geometry.impl.Polygon;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.util.GeometryVisitor;
import com.mapinfo.midev.geometry.util.IGeometryVisitor;
import com.mapinfo.midev.geometry.util.VisitorResult;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.util.ArgumentValidator;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.commons.lang3.mutable.MutableInt;

public final class GeometryUtilities {
    private GeometryUtilities() {
    }

    public static ComputationType getDefaultComputationType(CoordSys csys) {
        ComputationType ct = CoordSysUtilities.isEngineering((CoordSys)csys) ? ComputationType.CARTESIAN : ComputationType.SPHERICAL;
        return ct;
    }

    public static Orientation orientation(IRing ring) {
        IDirectPositionList dpl = ring.getCurveSegmentCount() == 1 ? (ring.isLinear() ? ring.getCurveSegment(0).getControlPoints() : ring.getCurveSegment(0).asLineString().getControlPoints()) : ring.asLineString().getControlPoints();
        return GeometryUtilities.orientation(dpl);
    }

    public static Orientation orientation(IDirectPositionList dpl) throws InvalidGeometryException {
        DirectPosition last;
        if (dpl.isEmpty()) {
            throw new InvalidGeometryException("Direct position list is empty.");
        }
        DirectPosition first = dpl.getDirectPosition(0, new DirectPosition());
        if (!first.equals((Object)(last = dpl.getDirectPosition(dpl.size() - 1, new DirectPosition())))) {
            throw new InvalidGeometryException("Direct position list is not closed.");
        }
        DirectPosition ref = dpl.getDirectPosition(0, new DirectPosition());
        double total = MeasurementUtilities.signedCartesianArea(dpl, ref);
        Orientation orient = total > 0.0 ? Orientation.CLOCKWISE : (total < 0.0 ? Orientation.COUNTER_CLOCKWISE : Orientation.UNKNOWN);
        return orient;
    }

    public static IFeatureGeometry formFeatureGeometry(GeometryFactory factory, List<IGeometry> geomList) {
        BitSet geometryTypes = new BitSet(3);
        ArrayList<IPoint> points = new ArrayList<IPoint>();
        ArrayList<ICurve> curves = new ArrayList<ICurve>();
        ArrayList<IPolygon> polys = new ArrayList<IPolygon>();
        for (IGeometry g : geomList) {
            if (g instanceof ICurveSegment) {
                g = factory.newCurve((ICurveSegment)g);
            }
            if (g instanceof IPoint) {
                geometryTypes.set(0, true);
                points.add((IPoint)g);
                continue;
            }
            if (g instanceof ICurve) {
                geometryTypes.set(1, true);
                curves.add((ICurve)g);
                continue;
            }
            if (g instanceof IPolygon) {
                geometryTypes.set(2, true);
                polys.add((IPolygon)g);
                continue;
            }
            throw new UnsupportedOperationException();
        }
        if (!geometryTypes.get(1) && !geometryTypes.get(2)) {
            if (geomList.size() == 1) {
                return (IPoint)geomList.get(0);
            }
            return factory.newMultiPoint(points);
        }
        if (!geometryTypes.get(0) && !geometryTypes.get(2)) {
            return factory.newMultiCurve(curves);
        }
        if (!geometryTypes.get(0) && !geometryTypes.get(1)) {
            return factory.newMultiPolygon(polys);
        }
        ArrayList<FeatureGeometry> featureList = new ArrayList<FeatureGeometry>();
        if (geometryTypes.get(0)) {
            featureList.add(factory.newMultiPoint(points));
        }
        if (geometryTypes.get(1)) {
            featureList.add(factory.newMultiCurve(curves));
        }
        if (geometryTypes.get(2)) {
            featureList.add(factory.newMultiPolygon(polys));
        }
        return factory.newMultiFeatureGeometry(featureList);
    }

    public static IFeatureGeometry convertToFeatureGeometry(IGeometry iGeometry) {
        if (iGeometry instanceof IFeatureGeometry) {
            return (IFeatureGeometry)iGeometry;
        }
        GeometryFactory geometryFactory = new GeometryFactory(iGeometry.getSpatialInfo());
        if (iGeometry instanceof ICurve) {
            return geometryFactory.newMultiCurve((ICurve)iGeometry);
        }
        if (iGeometry instanceof ILineString) {
            return geometryFactory.newMultiCurve((ILineString)iGeometry);
        }
        if (iGeometry instanceof ICurveSegment) {
            return geometryFactory.newMultiCurve((ICurveSegment)iGeometry);
        }
        if (iGeometry instanceof IPolygon) {
            return geometryFactory.newMultiPolygon((IPolygon)iGeometry);
        }
        if (iGeometry instanceof IRing) {
            return geometryFactory.newMultiPolygon((IRing)iGeometry);
        }
        throw new UnsupportedOperationException("Unsupported type: " + iGeometry.getClass());
    }

    public static IGeometry upcastGeometry(IGeometry geometry, GeometryType geometryTypeToUpcast) {
        FeatureGeometry result = null;
        GeometryType geometryType = geometry.getType();
        GeometryFactory geometryFactory = new GeometryFactory(geometry.getSpatialInfo());
        switch (geometryTypeToUpcast) {
            case POINT: 
            case CURVE: 
            case ELLIPSE: 
            case LEGACY_ARC: 
            case LEGACY_TEXT: 
            case LINE_STRING: 
            case POLYGON: 
            case RECTANGLE: 
            case RING: 
            case ROUNDED_RECTANGLE: {
                result = null;
                break;
            }
            case MULTI_CURVE: {
                if (geometryType == GeometryType.LINE_STRING) {
                    result = geometryFactory.newMultiCurve((ILineString)geometry);
                    break;
                }
                if (geometryType != GeometryType.CURVE) break;
                result = geometryFactory.newMultiCurve((ICurve)geometry);
                break;
            }
            case MULTI_POINT: {
                if (geometryType != GeometryType.POINT) break;
                result = geometryFactory.newMultiPoint((IPoint)geometry);
                break;
            }
            case MULTI_POLYGON: {
                if (geometryType == GeometryType.POLYGON) {
                    result = geometryFactory.newMultiPolygon((IPolygon)geometry);
                    break;
                }
                if (geometryType == GeometryType.CURVE) {
                    result = geometryFactory.newMultiPolygon((ICurve)geometry);
                    break;
                }
                if (geometryType == GeometryType.LINE_STRING) {
                    result = geometryFactory.newMultiPolygon((ILineString)geometry);
                    break;
                }
                if (geometryType == GeometryType.RECTANGLE) {
                    result = geometryFactory.newMultiPolygon((IRectangle)geometry);
                    break;
                }
                if (geometryType != GeometryType.RING) break;
                result = geometryFactory.newMultiPolygon((IRing)geometry);
                break;
            }
            case MULTI_FEATURE_GEOMETRY: {
                result = geometryFactory.newMultiFeatureGeometry(geometry);
                break;
            }
            default: {
                result = null;
            }
        }
        if (result == null) {
            throw new InvalidGeometryConversionException(geometryType, geometryTypeToUpcast);
        }
        return result;
    }

    public static IGeometry downcastGeometry(IGeometry geometry, GeometryType geometryTypeToDowncast) {
        IGeometry result = null;
        GeometryType geometryType = geometry.getType();
        switch (geometryTypeToDowncast) {
            case POINT: {
                if (geometryType != GeometryType.MULTI_POINT || ((IMultiPoint)geometry).getPointCount() != 1) break;
                result = (IGeometry)((IMultiPoint)geometry).iterator().next();
                break;
            }
            case POLYGON: {
                if (geometryType != GeometryType.MULTI_POLYGON || ((IMultiPolygon)geometry).getPolygonCount() != 1) break;
                result = (IGeometry)((IMultiPolygon)geometry).iterator().next();
                break;
            }
            case CURVE: 
            case LINE_STRING: {
                if (geometryType != GeometryType.MULTI_CURVE || ((IMultiCurve)geometry).getCurveCount() != 1) break;
                result = (IGeometry)((IMultiCurve)geometry).iterator().next();
                break;
            }
            case RING: {
                if (geometryType == GeometryType.POLYGON) {
                    result = ((IPolygon)geometry).getExteriorRing();
                    break;
                }
                if (geometryType != GeometryType.MULTI_POLYGON || ((IMultiPolygon)geometry).getPolygonCount() != 1) break;
                IPolygon firstPolygon = (IPolygon)((IMultiPolygon)geometry).iterator().next();
                result = GeometryUtilities.downcastGeometry(firstPolygon, geometryTypeToDowncast);
                break;
            }
            case MULTI_POINT: {
                if (geometryType != GeometryType.MULTI_FEATURE_GEOMETRY || ((IMultiFeatureGeometry)geometry).getCount(GeometryType.MULTI_POINT) != 1) break;
                result = ((IMultiFeatureGeometry)geometry).getMultiPointIterator().next();
                break;
            }
            case MULTI_CURVE: {
                if (geometryType != GeometryType.MULTI_FEATURE_GEOMETRY || ((IMultiFeatureGeometry)geometry).getCount(GeometryType.MULTI_CURVE) != 1) break;
                result = ((IMultiFeatureGeometry)geometry).getMultiCurveIterator().next();
                break;
            }
            case MULTI_POLYGON: {
                if (geometryType != GeometryType.MULTI_FEATURE_GEOMETRY || ((IMultiFeatureGeometry)geometry).getCount(GeometryType.MULTI_POLYGON) != 1) break;
                result = ((IMultiFeatureGeometry)geometry).getMultiPolygonIterator().next();
                break;
            }
            default: {
                result = null;
            }
        }
        if (result == null) {
            throw new InvalidGeometryConversionException(geometryType, geometryTypeToDowncast);
        }
        return result;
    }

    public static boolean canUpcastGeometry(IGeometry geometry, GeometryType geometryTypeToUpcast) {
        boolean result = false;
        GeometryType geometryType = geometry.getType();
        switch (geometryTypeToUpcast) {
            case POINT: 
            case CURVE: 
            case ELLIPSE: 
            case LEGACY_ARC: 
            case LEGACY_TEXT: 
            case LINE_STRING: 
            case POLYGON: 
            case RECTANGLE: 
            case RING: 
            case ROUNDED_RECTANGLE: {
                result = false;
                break;
            }
            case MULTI_CURVE: {
                if (geometryType != GeometryType.LINE_STRING && geometryType != GeometryType.CURVE) break;
                result = true;
                break;
            }
            case MULTI_FEATURE_GEOMETRY: {
                result = true;
                break;
            }
            case MULTI_POINT: {
                if (geometryType != GeometryType.POINT) break;
                result = true;
                break;
            }
            case MULTI_POLYGON: {
                if (geometryType != GeometryType.LINE_STRING && geometryType != GeometryType.CURVE && geometryType != GeometryType.POLYGON && geometryType != GeometryType.RECTANGLE && geometryType != GeometryType.RING) break;
                result = true;
            }
        }
        return result;
    }

    public static boolean canDowncastGeometry(IGeometry geometry, GeometryType geometryTypeToDowncast) {
        boolean result = false;
        GeometryType geometryType = geometry.getType();
        switch (geometryTypeToDowncast) {
            case ELLIPSE: 
            case LEGACY_ARC: 
            case LEGACY_TEXT: 
            case RECTANGLE: 
            case ROUNDED_RECTANGLE: 
            case MULTI_FEATURE_GEOMETRY: {
                result = false;
                break;
            }
            case POINT: {
                if (geometryType != GeometryType.MULTI_POINT || ((IMultiPoint)geometry).getPointCount() != 1) break;
                result = true;
                break;
            }
            case POLYGON: {
                if (geometryType != GeometryType.MULTI_POLYGON || ((IMultiPolygon)geometry).getPolygonCount() != 1) break;
                result = true;
                break;
            }
            case CURVE: 
            case LINE_STRING: {
                if (geometryType != GeometryType.MULTI_CURVE || ((IMultiCurve)geometry).getCurveCount() != 1) break;
                result = true;
                break;
            }
            case RING: {
                if (geometryType != GeometryType.POLYGON && (geometryType != GeometryType.MULTI_POLYGON || ((IMultiPolygon)geometry).getPolygonCount() != 1)) break;
                result = true;
                break;
            }
            case MULTI_CURVE: {
                if (geometryType != GeometryType.MULTI_FEATURE_GEOMETRY || ((IMultiFeatureGeometry)geometry).getCount(GeometryType.MULTI_CURVE) != 1) break;
                result = true;
                break;
            }
            case MULTI_POINT: {
                if (geometryType != GeometryType.MULTI_FEATURE_GEOMETRY || ((IMultiFeatureGeometry)geometry).getCount(GeometryType.MULTI_POINT) != 1) break;
                result = true;
                break;
            }
            case MULTI_POLYGON: {
                if (geometryType != GeometryType.MULTI_FEATURE_GEOMETRY || ((IMultiFeatureGeometry)geometry).getCount(GeometryType.MULTI_POLYGON) != 1) break;
                result = true;
            }
        }
        return result;
    }

    public static IMultiPolygon convertToFeatureGeometry(Envelope envelope) {
        DirectPosition ll = envelope.getLowerLeft();
        DirectPosition ur = envelope.getUpperRight();
        double[] xArray = new double[]{ll.getX(), ll.getX(), ur.getX(), ur.getX(), ll.getX()};
        double[] yArray = new double[]{ll.getY(), ur.getY(), ur.getY(), ll.getY(), ll.getY()};
        DirectPositionArray dpa = new DirectPositionArray(xArray, yArray, xArray.length);
        return new GeometryFactory(envelope.getSpatialInfo()).newMultiPolygon(dpa, GeometryType.LINE_STRING);
    }

    public static IGeometry convertIfNecessary(IGeometry geometry, CoordSys coordSys) {
        if (!geometry.getCoordSys().equivalent(coordSys)) {
            geometry = geometry.getCopy(coordSys);
        }
        return geometry;
    }

    public static IFeatureGeometry convertIfNecessary(IFeatureGeometry geometry, CoordSys coordSys) {
        return (IFeatureGeometry)GeometryUtilities.convertIfNecessary((IGeometry)geometry, coordSys);
    }

    public static Envelope convertIfNecessary(Envelope env, SpatialInfo spatialInfo) {
        if (!env.getSpatialInfo().equals(spatialInfo)) {
            env = env.getCopy(spatialInfo);
        }
        return env;
    }

    public static int getNodeCount(IGeometry geom) {
        final MutableInt result = new MutableInt();
        IGeometryVisitor visitor = new IGeometryVisitor(){

            @Override
            public VisitorResult points(DirectPosition pt) {
                result.increment();
                return VisitorResult.CONTINUE;
            }

            @Override
            public VisitorResult edges(IDirectPositionList pts) {
                result.add(pts.size());
                return VisitorResult.CONTINUE;
            }
        };
        GeometryVisitor.visit(geom, visitor);
        return result.intValue();
    }

    public static IDirectPositionList getNodes(IGeometry geom) {
        DirectPositionArray result = new DirectPositionArray();
        return GeometryUtilities.getNodes(geom, result);
    }

    public static IDirectPositionList getNodes(IGeometry geom, final IDirectPositionList result) {
        IGeometryVisitor visitor = new IGeometryVisitor(){

            @Override
            public VisitorResult points(DirectPosition pt) {
                result.add(pt);
                return VisitorResult.CONTINUE;
            }

            @Override
            public VisitorResult edges(IDirectPositionList pts) {
                result.addAll(pts);
                return VisitorResult.CONTINUE;
            }
        };
        GeometryVisitor.visit(geom, visitor);
        return result;
    }

    public static IFeatureGeometry cleanGeometryPoints(IFeatureGeometry featureGeometry) {
        switch (featureGeometry.getType()) {
            case MULTI_CURVE: {
                return GeometryUtilities.cleanGeometryPoints((IMultiCurve)featureGeometry);
            }
            case MULTI_POINT: {
                return GeometryUtilities.cleanGeometryPoints((IMultiPoint)featureGeometry);
            }
            case MULTI_POLYGON: {
                return GeometryUtilities.cleanGeometryPoints((IMultiPolygon)featureGeometry);
            }
        }
        return featureGeometry;
    }

    private static MultiPoint cleanGeometryPoints(IMultiPoint multiPoint) {
        LinkedHashSet<DirectPosition> hashSet = new LinkedHashSet<DirectPosition>();
        IDirectPositionIterator i = multiPoint.getDirectPositionIterator();
        while (i.hasNext()) {
            DirectPosition point = new DirectPosition();
            i.nextDirectPosition(point);
            hashSet.add(point);
        }
        DirectPositionArray result = new DirectPositionArray(hashSet.size());
        for (DirectPosition directPosition : hashSet) {
            result.add(directPosition);
        }
        return new MultiPoint(multiPoint.getSpatialInfo(), result);
    }

    private static MultiPolygon cleanGeometryPoints(IMultiPolygon multiPolygon) {
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (IPolygon polygon : multiPolygon) {
            ArrayList<Ring> innerRings = new ArrayList<Ring>();
            ILineString outerRingCurve = GeometryUtilities.cleanGeometryPoints(polygon.getExteriorRing().asLineString());
            Iterator<IRing> iterator = polygon.getInteriorRingIterator();
            while (iterator.hasNext()) {
                IRing ring = iterator.next();
                ILineString innerRingCurve = GeometryUtilities.cleanGeometryPoints(ring.asLineString());
                innerRings.add(new Ring(ring.getSpatialInfo(), (CurveSegment)((Object)innerRingCurve)));
            }
            if (innerRings.size() > 0) {
                polygons.add(new Polygon(polygon.getSpatialInfo(), new Ring(polygon.getSpatialInfo(), (CurveSegment)((Object)outerRingCurve)), innerRings));
                continue;
            }
            polygons.add(new Polygon(polygon.getSpatialInfo(), new Ring(polygon.getSpatialInfo(), (CurveSegment)((Object)outerRingCurve))));
        }
        return new MultiPolygon(multiPolygon.getSpatialInfo(), polygons);
    }

    private static MultiCurve cleanGeometryPoints(IMultiCurve multiCurve) {
        ArrayList<Curve> result = new ArrayList<Curve>();
        for (ICurve curve : multiCurve) {
            result.add(new Curve(multiCurve.getSpatialInfo(), (CurveSegment)((Object)GeometryUtilities.cleanGeometryPoints(curve.asLineString()))));
        }
        return new MultiCurve(multiCurve.getSpatialInfo(), result);
    }

    private static ILineString cleanGeometryPoints(ILineString lineString) {
        DirectPositionArray directPositionList = new DirectPositionArray();
        IDirectPositionIterator pointIterator = lineString.getControlPointIterator();
        DirectPosition directPositionA = new DirectPosition();
        DirectPosition directPositionB = new DirectPosition();
        pointIterator.nextDirectPosition(directPositionA);
        directPositionList.add(directPositionA);
        while (pointIterator.hasNext()) {
            pointIterator.nextDirectPosition(directPositionB);
            if (directPositionA.equalsXY(directPositionB)) continue;
            directPositionList.add(directPositionB);
            directPositionA.set(directPositionB);
        }
        return new LineString(lineString.getSpatialInfo(), directPositionList);
    }

    public static IGeometry transform(IGeometry geometry, IDirectPositionMutator mutator) {
        ArgumentValidator.assertNotNullReference((String)"geometry", (Object)geometry);
        ArgumentValidator.assertNotNullReference((String)"mutator", (Object)mutator);
        GeometryFactory factory = new GeometryFactory(geometry.getSpatialInfo());
        switch (geometry.getType()) {
            case POINT: {
                DirectPosition pos = ((IPoint)geometry).getDirectPosition();
                return factory.newPoint(mutator.transform(pos, pos));
            }
            case MULTI_POINT: {
                IDirectPositionList positions = ((IMultiPoint)geometry).getPositions();
                DirectPositionArray mutated = new DirectPositionArray(positions.size());
                IDirectPositionIterator it = positions.getDirectPositionIterator();
                while (it.hasNext()) {
                    DirectPosition pos = it.nextDirectPosition(new DirectPosition());
                    mutated.add(mutator.transform(pos, pos));
                }
                return factory.newMultiPoint(mutated);
            }
            case LINE_STRING: {
                ILineString lineString = (ILineString)geometry;
                IDirectPositionList positions = lineString.getControlPoints();
                DirectPositionArray mutated = new DirectPositionArray(positions.size());
                IDirectPositionIterator it = positions.getDirectPositionIterator();
                while (it.hasNext()) {
                    DirectPosition pos = it.nextDirectPosition(new DirectPosition());
                    mutated.add(mutator.transform(pos, pos));
                }
                return factory.newLineString(mutated);
            }
            case CURVE: {
                ICurve curve = (ICurve)geometry;
                ArrayList<ICurveSegment> mutatedSegments = new ArrayList<ICurveSegment>(curve.getCurveSegmentCount());
                for (int i = 0; i < curve.getCurveSegmentCount(); ++i) {
                    mutatedSegments.add((ICurveSegment)GeometryUtilities.transform(curve.getCurveSegment(i), mutator));
                }
                return factory.newCurve(mutatedSegments);
            }
            case MULTI_CURVE: {
                IMultiCurve multiCurve = (IMultiCurve)geometry;
                ArrayList<ICurve> mutated = new ArrayList<ICurve>(multiCurve.getCurveCount());
                for (ICurve curve : multiCurve) {
                    mutated.add((ICurve)GeometryUtilities.transform(curve, mutator));
                }
                return factory.newMultiCurve(mutated);
            }
            case RING: {
                IRing ring = (IRing)geometry;
                ArrayList<ICurveSegment> mutated = new ArrayList<ICurveSegment>(ring.getCurveSegmentCount());
                for (ICurveSegment curveSegment : ring) {
                    mutated.add((ICurveSegment)GeometryUtilities.transform(curveSegment, mutator));
                }
                return factory.newRing(mutated);
            }
            case POLYGON: {
                IPolygon polygon = (IPolygon)geometry;
                IRing mutatedOuter = (IRing)GeometryUtilities.transform(polygon.getExteriorRing(), mutator);
                ArrayList<IRing> mutatedInners = new ArrayList<IRing>(polygon.getInteriorRingCount());
                Iterator<IRing> it = polygon.getInteriorRingIterator();
                while (it.hasNext()) {
                    mutatedInners.add((IRing)GeometryUtilities.transform(it.next(), mutator));
                }
                return factory.newPolygon(mutatedOuter, mutatedInners);
            }
            case MULTI_POLYGON: {
                IMultiPolygon multiPolygon = (IMultiPolygon)geometry;
                ArrayList<IPolygon> mutated = new ArrayList<IPolygon>(multiPolygon.getPolygonCount());
                for (IPolygon polygon : multiPolygon) {
                    mutated.add((IPolygon)GeometryUtilities.transform(polygon, mutator));
                }
                return factory.newMultiPolygon(mutated);
            }
            case MULTI_FEATURE_GEOMETRY: {
                IMultiFeatureGeometry geometries = (IMultiFeatureGeometry)geometry;
                ArrayList<IFeatureGeometry> mutated = new ArrayList<IFeatureGeometry>(geometries.getFeatureGeometryCount());
                for (IFeatureGeometry part : geometries) {
                    mutated.add((IFeatureGeometry)GeometryUtilities.transform(part, mutator));
                }
                return factory.newMultiFeatureGeometry(mutated);
            }
            case RECTANGLE: {
                IRectangle rectangle = (IRectangle)geometry;
                DirectPosition ll = rectangle.getLowerLeft();
                DirectPosition ur = rectangle.getUpperRight();
                return factory.newRectangle(mutator.transform(ll, new DirectPosition()), mutator.transform(ur, new DirectPosition()));
            }
            case ROUNDED_RECTANGLE: {
                ILegacyRoundedRectangle rectangle = (ILegacyRoundedRectangle)geometry;
                return factory.newRoundedRectangle(mutator.transform(rectangle.getLowerLeft(), new DirectPosition()), mutator.transform(rectangle.getUpperRight(), new DirectPosition()), rectangle.getCornerRadiusX(), rectangle.getCornerRadiusY());
            }
            case ELLIPSE: {
                ILegacyEllipse ellipse = (ILegacyEllipse)geometry;
                return factory.newEllipse(mutator.transform(ellipse.getLowerLeft(), new DirectPosition()), mutator.transform(ellipse.getUpperRight(), new DirectPosition()));
            }
            case LEGACY_TEXT: {
                ILegacyText text = (ILegacyText)geometry;
                IRectangle rect = text.getRectangle();
                return factory.newLegacyText((IRectangle)GeometryUtilities.transform(rect, mutator), text.getText(), text.getAngle(), text.getTextCalloutType(), mutator.transform(text.getCalloutTarget(), new DirectPosition()));
            }
            case LEGACY_ARC: {
                ILegacyArc arc = (ILegacyArc)geometry;
                IRectangle rect = arc.getRectangle();
                return factory.newLegacyArc((IRectangle)GeometryUtilities.transform(rect, mutator), arc.getBeginAngle(), arc.getEndAngle());
            }
        }
        throw new Error("Unsupported geometry type " + (Object)((Object)geometry.getType()));
    }

    public static enum Orientation {
        COUNTER_CLOCKWISE,
        CLOCKWISE,
        UNKNOWN;

    }
}

