/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.GeographicCoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.AffineTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.ILineString;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.InvalidComputationTypeException;
import com.mapinfo.midev.geometry.InvalidGeometryOperationException;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.UnsupportedGeometryOperationException;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.AreaUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.MathUtil;
import java.awt.geom.Point2D;
import java.util.Iterator;

public final class MeasurementUtilities {
    public static final double EARTH_RADIUS = 6370997.0;
    private static final LinearUnit DEFAULT_LINEAR_UNIT = LinearUnit.METER;
    private static final double PI_DIV_2 = 1.5707963267948966;

    private MeasurementUtilities() {
    }

    public static Length length(IMultiCurve multiCurve) {
        return MeasurementUtilities.length(multiCurve, GeometryUtilities.getDefaultComputationType(multiCurve.getCoordSys()));
    }

    public static Length length(IMultiCurve multiCurve, ComputationType ct) {
        if (multiCurve.isEmpty()) {
            MeasurementUtilities.checkComputationType(multiCurve.getCoordSys(), ct);
            return new Length(0.0, LinearUnit.METER, ct);
        }
        Iterator iter = multiCurve.iterator();
        Length first = MeasurementUtilities.length((ICurve)iter.next(), ct);
        double total = first.getValue();
        while (iter.hasNext()) {
            total += MeasurementUtilities.length((ICurve)iter.next(), ct).getValue();
        }
        return new Length(total, first.getUnit(), first.getComputationType());
    }

    public static Length length(ICurve curve) {
        return MeasurementUtilities.length(curve, GeometryUtilities.getDefaultComputationType(curve.getCoordSys()));
    }

    public static Length length(ICurve curve, ComputationType ct) {
        Iterator iter = curve.iterator();
        Length first = MeasurementUtilities.length((ICurveSegment)iter.next(), ct);
        double total = first.getValue();
        while (iter.hasNext()) {
            total += MeasurementUtilities.length((ICurveSegment)iter.next(), ct).getValue();
        }
        return new Length(total, first.getUnit(), first.getComputationType());
    }

    public static Length length(ICurveSegment cs) {
        return MeasurementUtilities.length(cs, GeometryUtilities.getDefaultComputationType(cs.getCoordSys()));
    }

    public static Length length(ICurveSegment cs, ComputationType ct) {
        Length len;
        switch (cs.getType()) {
            case LINE_STRING: {
                len = MeasurementUtilities.length((ILineString)cs, ct);
                break;
            }
            default: {
                throw new UnsupportedGeometryOperationException("Invalid geometry type: " + (Object)((Object)cs.getType()));
            }
        }
        return len;
    }

    public static Length perimeter(IMultiPolygon multiPolygon) {
        return MeasurementUtilities.perimeter(multiPolygon, GeometryUtilities.getDefaultComputationType(multiPolygon.getCoordSys()));
    }

    public static Length perimeter(IMultiPolygon multiPolygon, ComputationType ct) {
        if (multiPolygon.isEmpty()) {
            MeasurementUtilities.checkComputationType(multiPolygon.getCoordSys(), ct);
            return new Length(0.0, LinearUnit.METER, ct);
        }
        Iterator iter = multiPolygon.iterator();
        Length first = MeasurementUtilities.perimeter((IPolygon)iter.next(), ct);
        double total = first.getValue();
        while (iter.hasNext()) {
            total += MeasurementUtilities.perimeter((IPolygon)iter.next(), ct).getValue();
        }
        return new Length(total, first.getUnit(), first.getComputationType());
    }

    public static Length perimeter(IPolygon polygon) {
        return MeasurementUtilities.perimeter(polygon, GeometryUtilities.getDefaultComputationType(polygon.getCoordSys()));
    }

    public static Length perimeter(IPolygon polygon, ComputationType ct) {
        IRing exterior = polygon.getExteriorRing();
        Length first = MeasurementUtilities.perimeter(exterior, ct);
        double total = first.getValue();
        Iterator<IRing> iter = polygon.getInteriorRingIterator();
        while (iter.hasNext()) {
            total += MeasurementUtilities.perimeter(iter.next(), ct).getValue();
        }
        return new Length(total, first.getUnit(), first.getComputationType());
    }

    public static Length perimeter(IRing ring) {
        return MeasurementUtilities.perimeter(ring, GeometryUtilities.getDefaultComputationType(ring.getCoordSys()));
    }

    public static Length perimeter(IRing ring, ComputationType ct) {
        Iterator iter = ring.iterator();
        Length first = MeasurementUtilities.length((ICurveSegment)iter.next(), ct);
        double total = first.getValue();
        while (iter.hasNext()) {
            total += MeasurementUtilities.length((ICurveSegment)iter.next(), ct).getValue();
        }
        return new Length(total, first.getUnit(), first.getComputationType());
    }

    public static DirectPosition getPointAtDistance(ICurve curve, Length len) {
        return MeasurementUtilities.getPointAtDistance(curve.iterator(), len);
    }

    public static DirectPosition getPointAtDistance(ICurveSegment cs, Length len) throws InvalidGeometryOperationException {
        DirectPosition dp;
        ComputationType ct = len.getComputationType();
        double csLenValue = cs.getLength(ct).getValue(len.getUnit());
        if (len.getValue() < 0.0 || csLenValue < len.getValue()) {
            throw new IllegalArgumentException("len must be in range [0, " + csLenValue + "]");
        }
        switch (cs.getType()) {
            case LINE_STRING: {
                dp = MeasurementUtilities.getPointAtDistance((ILineString)cs, len);
                break;
            }
            default: {
                throw new InvalidGeometryOperationException("Invalid geometry type: " + (Object)((Object)cs.getType()));
            }
        }
        return dp;
    }

    public static DirectPosition getPointAtDistance(IRing ring, Length len) {
        return MeasurementUtilities.getPointAtDistance(ring.iterator(), len);
    }

    private static Length length(ILineString ls, ComputationType ct) {
        CoordSys csys = ls.getCoordSys();
        LinearUnit lu = CoordSysUtilities.getLinearUnit((CoordSys)csys);
        if (lu == null) {
            lu = DEFAULT_LINEAR_UNIT;
        }
        IDirectPositionIterator iter = ls.getControlPointIterator();
        DirectPosition left = iter.nextDirectPosition(new DirectPosition());
        DirectPosition right = new DirectPosition();
        double total = 0.0;
        while (iter.hasNext()) {
            right = iter.nextDirectPosition(right);
            switch (ct) {
                case CARTESIAN: {
                    total += MeasurementUtilities.cartesianLength(left, right, csys).getValue(lu);
                    break;
                }
                case SPHERICAL: {
                    total += MeasurementUtilities.sphericalLength(left, right, csys).getValue(lu);
                    break;
                }
                default: {
                    throw new InvalidComputationTypeException(ct);
                }
            }
            left.set(right);
        }
        return new Length(total, lu, ct);
    }

    public static Length length(DirectPosition start, DirectPosition end, CoordSys csys) {
        switch (GeometryUtilities.getDefaultComputationType(csys)) {
            case SPHERICAL: {
                return MeasurementUtilities.sphericalLength(start, end, csys);
            }
            case CARTESIAN: {
                return MeasurementUtilities.cartesianLength(start, end, csys);
            }
        }
        throw new InvalidComputationTypeException(GeometryUtilities.getDefaultComputationType(csys));
    }

    public static Length cartesianLength(DirectPosition start, DirectPosition end, CoordSys csys) throws InvalidGeometryOperationException {
        if (CoordSysUtilities.isLongLat((CoordSys)csys)) {
            throw new InvalidGeometryOperationException("Invalid computation type: CARTESIAN. Cannot perform cartesian operation on geometry with a long/lat coordinate system.");
        }
        DirectPosition newStart = new DirectPosition();
        DirectPosition newEnd = new DirectPosition();
        AffineTransform inverseAT = csys.getAffineTransform().createInverse();
        inverseAT.transform(start, newStart);
        inverseAT.transform(end, newEnd);
        double len = Point2D.distance(newStart.getX(), newStart.getY(), newEnd.getX(), newEnd.getY());
        return new Length(len, CoordSysUtilities.getLinearUnit((CoordSys)csys), ComputationType.CARTESIAN);
    }

    public static Length sphericalLength(DirectPosition start, DirectPosition end, CoordSys csys) throws InvalidGeometryOperationException {
        if (CoordSysUtilities.isEngineering((CoordSys)csys)) {
            throw new InvalidGeometryOperationException("Invalid computation type: SPHERICAL. Cannot perform spherical operation on geometry with an engineering coordinate system.");
        }
        GeographicCoordSys geographicCoordSys = (GeographicCoordSys)csys;
        DirectPosition newStart = MeasurementUtilities.convertToLongLatRadians(start, new DirectPosition(), geographicCoordSys);
        DirectPosition newEnd = MeasurementUtilities.convertToLongLatRadians(end, new DirectPosition(), geographicCoordSys);
        double len = MeasurementUtilities.computeGreatCircleDistanceInRadians(newStart, newEnd) * 6370997.0;
        return new Length(len, LinearUnit.METER, ComputationType.SPHERICAL);
    }

    private static double computeGreatCircleDistanceInRadians(DirectPosition start, DirectPosition end) {
        double sinx = Math.sin((end.getX() - start.getX()) / 2.0);
        double siny = Math.sin((end.getY() - start.getY()) / 2.0);
        double tmp = siny * siny + Math.cos(start.getY()) * Math.cos(end.getY()) * sinx * sinx;
        tmp = Math.sqrt(Math.max(tmp, 0.0));
        return Math.asin(Math.min(tmp, 1.0)) * 2.0;
    }

    private static DirectPosition convertToLongLatRadians(DirectPosition source, DirectPosition destination, GeographicCoordSys csys) {
        destination.set(source);
        if (!csys.getAffineTransform().isIdentity()) {
            AffineTransform inverseAT = csys.getAffineTransform().createInverse();
            inverseAT.transform(destination, destination);
        }
        if (csys.getProjection() != null) {
            csys.getProjection().toLongLat(destination, destination);
        }
        AngularUnit au = csys.getAngularUnit();
        destination.setXY(AngularUnit.convert((double)destination.getX(), (AngularUnit)au, (AngularUnit)AngularUnit.RADIAN), AngularUnit.convert((double)destination.getY(), (AngularUnit)au, (AngularUnit)AngularUnit.RADIAN));
        destination.setY(MathUtil.clip((double)destination.getY(), (double)-1.5707963267948966, (double)1.5707963267948966));
        return destination;
    }

    public static Length length(DirectPosition start, DirectPosition end, CoordSys csys, ComputationType ct) {
        Length len;
        switch (ct) {
            case CARTESIAN: {
                len = MeasurementUtilities.cartesianLength(start, end, csys);
                break;
            }
            case SPHERICAL: {
                len = MeasurementUtilities.sphericalLength(start, end, csys);
                break;
            }
            default: {
                throw new InvalidComputationTypeException(ct);
            }
        }
        return len;
    }

    private static DirectPosition getPointAtDistance(Iterator<ICurveSegment> iter, Length len) {
        ComputationType ct = len.getComputationType();
        LinearUnit lu = len.getUnit();
        double delta = len.getValue();
        ICurveSegment theSegment = null;
        double totalLen = 0.0;
        while (iter.hasNext()) {
            theSegment = iter.next();
            double segLen = theSegment.getLength(ct).getValue(lu);
            totalLen += segLen;
            if (delta <= segLen) break;
            delta -= segLen;
            theSegment = null;
        }
        if (theSegment == null) {
            throw new InvalidGeometryOperationException("len must be in range [0, " + totalLen + "]");
        }
        DirectPosition dp = MeasurementUtilities.getPointAtDistance(theSegment, new Length(delta, lu, ct));
        return dp;
    }

    private static DirectPosition getPointAtDistance(ILineString ls, Length len) {
        SpatialInfo si = ls.getSpatialInfo();
        ComputationType ct = len.getComputationType();
        double delta = len.getValue();
        LinearUnit lu = len.getUnit();
        double dist = 0.0;
        IDirectPositionIterator i = ls.getControlPoints().getDirectPositionIterator();
        DirectPosition left = i.nextDirectPosition(new DirectPosition());
        DirectPosition right = new DirectPosition();
        while (i.hasNext()) {
            right = i.nextDirectPosition(right);
            switch (ct) {
                case CARTESIAN: {
                    dist = MeasurementUtilities.cartesianLength(left, right, si.getCoordSys()).getValue(lu);
                    break;
                }
                case SPHERICAL: {
                    dist = MeasurementUtilities.sphericalLength(left, right, si.getCoordSys()).getValue(lu);
                    break;
                }
                default: {
                    throw new InvalidComputationTypeException(ct);
                }
            }
            if (delta <= dist) break;
            delta -= dist;
            left.set(right);
        }
        DirectPosition dp = delta == 0.0 ? left : (delta == dist ? right : MeasurementUtilities.getPointAtDistance(left, right, si, new Length(delta, lu)));
        return dp;
    }

    private static DirectPosition getPointAtDistance(DirectPosition start, DirectPosition end, SpatialInfo si, Length len) {
        double curdist;
        double diff;
        DirectPosition target = new DirectPosition(end);
        double distance = Math.abs(len.getValue(LinearUnit.METER));
        double tolerance = si.getToleranceLength().getValue(LinearUnit.METER);
        for (int i = 0; i < 10 && !(Math.abs(diff = distance / (curdist = MeasurementUtilities.length(start, target, si.getCoordSys()).getValue(LinearUnit.METER)) - 1.0) < tolerance); ++i) {
            double deltaX = (target.getX() - start.getX()) * diff;
            double deltaY = (target.getY() - start.getY()) * diff;
            target.offsetXY(deltaX, deltaY);
        }
        return target;
    }

    public static double signedCartesianArea(IDirectPositionList dpl, DirectPosition ref) {
        if (dpl.isEmpty()) {
            return 0.0;
        }
        IDirectPositionIterator i = dpl.getDirectPositionIterator();
        DirectPosition prev = i.nextDirectPosition(new DirectPosition());
        DirectPosition cur = new DirectPosition();
        double refYx2 = 2.0 * ref.getY();
        double total = 0.0;
        while (i.hasNext()) {
            i.nextDirectPosition(cur);
            total += (cur.getX() - prev.getX()) * (cur.getY() + prev.getY() - refYx2);
            prev.set(cur);
        }
        return total / 2.0;
    }

    public static Area area(IRing ring) {
        return MeasurementUtilities.area(ring, GeometryUtilities.getDefaultComputationType(ring.getCoordSys()));
    }

    public static Area area(IRing ring, ComputationType ct) {
        Area area;
        MeasurementUtilities.checkComputationType(ring.getCoordSys(), ct);
        switch (ct) {
            case CARTESIAN: {
                area = MeasurementUtilities.cartesianArea(ring);
                break;
            }
            case SPHERICAL: {
                area = MeasurementUtilities.sphericalArea(ring);
                break;
            }
            default: {
                throw new InvalidComputationTypeException(ct);
            }
        }
        return area;
    }

    private static Area cartesianArea(IRing ring) {
        double area = 0.0;
        DirectPosition ref = new DirectPosition();
        for (ICurveSegment seg : ring) {
            if (seg.isLinear()) {
                IDirectPositionList dpl = seg.getControlPoints();
                dpl.getDirectPosition(0, ref);
                area += MeasurementUtilities.signedCartesianArea(dpl, ref);
                continue;
            }
            throw new UnsupportedGeometryOperationException("Invalid computation type: " + (Object)((Object)seg.getType()));
        }
        LinearUnit lu = CoordSysUtilities.getLinearUnit((CoordSys)ring.getCoordSys());
        AreaUnit au = AreaUnit.fromLinearUnit((LinearUnit)lu);
        return new Area(Math.abs(area), au, ComputationType.CARTESIAN);
    }

    private static Area sphericalArea(IRing ring) {
        DirectPosition ref = ring.getEnvelope().getCenter();
        CoordSys csys = ring.getCoordSys();
        double totalArea = 0.0;
        for (ICurveSegment seg : ring) {
            if (seg.isLinear()) {
                totalArea += MeasurementUtilities.signedSphericalArea(seg.getControlPoints(), ref, csys);
                continue;
            }
            totalArea += MeasurementUtilities.signedSphericalArea(seg.asLineString().getControlPoints(), ref, csys);
        }
        return new Area(Math.abs(totalArea), AreaUnit.SQUARE_METER, ComputationType.SPHERICAL);
    }

    public static Area area(IPolygon polygon) {
        return MeasurementUtilities.area(polygon, GeometryUtilities.getDefaultComputationType(polygon.getCoordSys()));
    }

    public static Area area(IPolygon polygon, ComputationType ct) {
        MeasurementUtilities.checkComputationType(polygon.getCoordSys(), ct);
        Area area = MeasurementUtilities.area(polygon.getExteriorRing(), ct);
        AreaUnit au = area.getUnit();
        double total = area.getValue();
        Iterator<IRing> iter = polygon.getInteriorRingIterator();
        while (iter.hasNext()) {
            total -= MeasurementUtilities.area(iter.next(), ct).getValue();
        }
        return new Area(total, au, ct);
    }

    public static Area area(IMultiPolygon multiPolygon) {
        return MeasurementUtilities.area(multiPolygon, GeometryUtilities.getDefaultComputationType(multiPolygon.getCoordSys()));
    }

    public static Area area(IMultiPolygon multiPolygon, ComputationType ct) {
        if (multiPolygon.isEmpty()) {
            MeasurementUtilities.checkComputationType(multiPolygon.getCoordSys(), ct);
            return new Area(0.0, AreaUnit.SQUARE_METER, ct);
        }
        Iterator iter = multiPolygon.iterator();
        Area first = MeasurementUtilities.area((IPolygon)iter.next(), ct);
        double total = first.getValue();
        while (iter.hasNext()) {
            total += MeasurementUtilities.area((IPolygon)iter.next(), ct).getValue();
        }
        return new Area(total, first.getUnit(), ct);
    }

    private static double signedSphericalArea(IDirectPositionList dpl, DirectPosition refPos, CoordSys csys) {
        if (CoordSysUtilities.isEngineering((CoordSys)csys)) {
            throw new InvalidComputationTypeException(GeometryUtilities.getDefaultComputationType(csys));
        }
        GeographicCoordSys geographicCoordSys = (GeographicCoordSys)csys;
        DirectPosition center = MeasurementUtilities.convertToLongLatRadians(refPos, new DirectPosition(), geographicCoordSys);
        DirectPosition coord = new DirectPosition();
        DirectPosition previous = new DirectPosition();
        DirectPosition curVec = new DirectPosition();
        DirectPosition prevVec = new DirectPosition();
        double prevA = 0.0;
        double area = 0.0;
        boolean isfirstTime = true;
        IDirectPositionIterator i = dpl.getDirectPositionIterator();
        while (i.hasNext()) {
            coord = MeasurementUtilities.convertToLongLatRadians(i.nextDirectPosition(coord), coord, geographicCoordSys);
            curVec.setX(coord.getX() - center.getX());
            curVec.setY(coord.getY() - center.getY());
            double a = MeasurementUtilities.computeGreatCircleDistanceInRadians(coord, center);
            if (!isfirstTime) {
                double b = MeasurementUtilities.computeGreatCircleDistanceInRadians(coord, previous);
                double c = prevA;
                double s = (a + b + c) / 2.0;
                double t = Math.tan(s / 2.0) * Math.tan((s - a) / 2.0) * Math.tan((s - b) / 2.0) * Math.tan((s - c) / 2.0);
                double E = Math.abs(4.0 * Math.atan(Math.sqrt(Math.abs(t))));
                area = curVec.getX() * prevVec.getY() - curVec.getY() * prevVec.getX() > 0.0 ? (area += E) : (area -= E);
            }
            prevA = a;
            previous.set(coord);
            prevVec.set(curVec);
            isfirstTime = false;
        }
        return area *= MathUtil.square((double)6370997.0);
    }

    public static void checkComputationType(CoordSys csys, ComputationType ct) {
        if (CoordSysUtilities.isLongLat((CoordSys)csys) && ct != ComputationType.SPHERICAL) {
            throw new InvalidComputationTypeException(ct);
        }
        if (CoordSysUtilities.isProjected((CoordSys)csys) && ct != ComputationType.SPHERICAL && ct != ComputationType.CARTESIAN) {
            throw new InvalidComputationTypeException(ct);
        }
        if (CoordSysUtilities.isEngineering((CoordSys)csys) && ct != ComputationType.CARTESIAN) {
            throw new InvalidComputationTypeException(ct);
        }
    }
}

