/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.geometry.CurveBuilder;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.MultiCurve;
import com.mapinfo.midev.util.PublicAPI;
import java.util.LinkedList;
import java.util.List;

@PublicAPI
public class MultiCurveBuilder {
    private final SpatialInfo m_spatialInfo;
    private final List<Curve> m_curves = new LinkedList<Curve>();

    MultiCurveBuilder(SpatialInfo spatialInfo) {
        this.m_spatialInfo = spatialInfo;
    }

    public MultiCurveBuilder withLineString(DirectPosition ... positions) {
        this.m_curves.add((Curve)new CurveBuilder(this.m_spatialInfo).withLineString(positions).build());
        return this;
    }

    public MultiCurveBuilder withLineString(Iterable<DirectPosition> positions) {
        this.m_curves.add((Curve)new CurveBuilder(this.m_spatialInfo).withLineString(positions).build());
        return this;
    }

    public MultiCurveBuilder withLineString(IDirectPositionList positions) {
        this.m_curves.add((Curve)new CurveBuilder(this.m_spatialInfo).withLineString(positions).build());
        return this;
    }

    public IMultiCurve build() {
        return new MultiCurve(this.m_spatialInfo, this.m_curves);
    }
}

