/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryFactory;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.MultiPoint;
import com.mapinfo.midev.util.PublicAPI;

@PublicAPI
public class MultiPointBuilder {
    private final SpatialInfo m_spatialInfo;
    private final IDirectPositionList m_positions = new DirectPositionArray();

    MultiPointBuilder(SpatialInfo spatialInfo) {
        this.m_spatialInfo = spatialInfo;
    }

    public MultiPointBuilder withPoint(DirectPosition position) {
        this.m_positions.add(position);
        return this;
    }

    public MultiPointBuilder withPoint(double x, double y) {
        this.m_positions.add(GeometryFactory.pos(x, y));
        return this;
    }

    public MultiPointBuilder withPoint(String x, String y) {
        this.m_positions.add(GeometryFactory.pos(x, y));
        return this;
    }

    public IMultiPoint build() {
        return new MultiPoint(this.m_spatialInfo, this.m_positions);
    }
}

