/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IPolygonBuilder;
import com.mapinfo.midev.geometry.PolygonContainer;
import com.mapinfo.midev.geometry.PolygonRingBuilder;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Polygon;

public class PolygonBuilder
implements IPolygonBuilder<IPolygon> {
    private final PolygonContainer m_container;
    private final SpatialInfo m_spatialInfo;

    PolygonBuilder(SpatialInfo spatialInfo) {
        this.m_spatialInfo = spatialInfo;
        this.m_container = new PolygonContainer();
    }

    @Override
    public PolygonRingBuilder<IPolygon> withOuterRing() {
        return new PolygonRingBuilder<IPolygon>(this.m_spatialInfo, this, this.m_container, true);
    }

    @Override
    public PolygonRingBuilder<IPolygon> withInnerRing() {
        return new PolygonRingBuilder<IPolygon>(this.m_spatialInfo, this, this.m_container, false);
    }

    @Override
    public IPolygon build() {
        return new Polygon(this.m_spatialInfo, this.m_container.getOuterRing(), this.m_container.getInnerRings());
    }
}

