/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.GeometryFactory;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IPolygonBuilder;
import com.mapinfo.midev.geometry.PolygonContainer;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.util.PublicAPI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@PublicAPI
public final class PolygonRingBuilder<T> {
    private final SpatialInfo m_spatialInfo;
    private final PolygonContainer m_container;
    private final boolean m_outerRing;
    private final IPolygonBuilder<T> m_parent;
    private List<CurveSegment> m_curveSegments = new ArrayList<CurveSegment>();
    private IDirectPositionList m_points;

    PolygonRingBuilder(SpatialInfo spatialInfo, IPolygonBuilder<T> parent, PolygonContainer container, boolean outerRing) {
        this.m_spatialInfo = spatialInfo;
        this.m_container = container;
        this.m_outerRing = outerRing;
        this.m_parent = parent;
    }

    public PolygonRingBuilder<T> withLineString(DirectPosition ... positions) {
        this.convertPointsToCurveSegment(positions[0]);
        this.m_curveSegments.add(new LineString(this.m_spatialInfo, GeometryFactory.createDirectPositionArray(positions)));
        return this;
    }

    public PolygonRingBuilder<T> withLineString(Iterable<DirectPosition> positions) {
        LineString lineString = new LineString(this.m_spatialInfo, GeometryFactory.createDirectPositionArray(positions));
        this.convertPointsToCurveSegment(lineString.getStartPosition());
        this.m_curveSegments.add(lineString);
        return this;
    }

    public PolygonRingBuilder<T> withLineString(IDirectPositionList positions) {
        this.convertPointsToCurveSegment(positions.getDirectPosition(0, new DirectPosition()));
        this.m_curveSegments.add(new LineString(this.m_spatialInfo, positions));
        return this;
    }

    public PolygonRingBuilder<T> withPoint(double x, double y) {
        return this.withPoint(GeometryFactory.pos(x, y));
    }

    public PolygonRingBuilder<T> withPoint(String x, String y) {
        return this.withPoint(GeometryFactory.pos(x, y));
    }

    public PolygonRingBuilder<T> withPoint(DirectPosition position) {
        if (this.m_points == null) {
            this.m_points = new DirectPositionArray();
            if (!this.m_curveSegments.isEmpty()) {
                DirectPosition endPoint = this.m_curveSegments.get(this.m_curveSegments.size() - 1).getEndPosition();
                this.m_points.add(endPoint);
            }
        }
        this.m_points.add(position);
        return this;
    }

    public IPolygonBuilder<T> build() {
        this.convertPointsToCurveSegment(null);
        ArrayList<CurveSegment> contiguous = new ArrayList<CurveSegment>(this.m_curveSegments.size());
        DirectPosition start = null;
        DirectPosition last = null;
        Iterator<CurveSegment> it = this.m_curveSegments.iterator();
        while (it.hasNext()) {
            CurveSegment segment = it.next();
            if (start == null) {
                start = segment.getStartPosition();
            }
            if (last != null || this.m_curveSegments.size() == 1) {
                segment = this.makeContiguous(segment, last, !it.hasNext(), start);
            }
            contiguous.add(segment);
            last = segment.getEndPosition();
        }
        if (this.m_outerRing) {
            this.m_container.setOuterRing(new Ring(this.m_spatialInfo, contiguous));
        } else {
            this.m_container.addInnerRing(new Ring(this.m_spatialInfo, contiguous));
        }
        return this.m_parent;
    }

    private CurveSegment makeContiguous(CurveSegment segment, DirectPosition last, boolean close, DirectPosition start) {
        DirectPositionArray positions;
        if (last != null && !segment.getStartPosition().equals((Object)last)) {
            positions = new DirectPositionArray(segment.getControlPointCount() + 1);
            positions.add(last);
            positions.addAll(segment.getControlPoints());
            segment = new LineString(segment.getSpatialInfo(), positions);
        }
        if (close && !segment.getEndPosition().equals((Object)start)) {
            positions = new DirectPositionArray(segment.getControlPointCount() + 1);
            positions.addAll(segment.getControlPoints());
            positions.add(start);
            segment = new LineString(segment.getSpatialInfo(), positions);
        }
        return segment;
    }

    private void convertPointsToCurveSegment(DirectPosition next) {
        if (this.m_points != null) {
            if (this.m_points.size() == 1 && next != null) {
                this.m_points.add(next);
            }
            this.m_curveSegments.add(new LineString(this.m_spatialInfo, this.m_points));
            this.m_points = null;
        }
    }
}

