/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.CurveSegmentList;
import java.util.Iterator;
import java.util.List;

class ClosedCurveSegmentList
extends CurveSegmentList {
    ClosedCurveSegmentList(CurveSegment cs) throws InvalidGeometryException {
        super(cs);
        if (!this.isClosed()) {
            throw new InvalidGeometryException("Curve segment is not closed.");
        }
    }

    ClosedCurveSegmentList(List<CurveSegment> curveSegments) throws InvalidGeometryException {
        super(curveSegments);
        if (!this.isClosed()) {
            throw new InvalidGeometryException("Curve segment is not closed.");
        }
    }

    private ClosedCurveSegmentList(int size) {
        super(size);
    }

    @Override
    public ClosedCurveSegmentList getCopy() {
        ClosedCurveSegmentList ccsl = new ClosedCurveSegmentList(this.size());
        Iterator<CurveSegment> iter = super.getCopy().iterator();
        while (iter.hasNext()) {
            ccsl.addCurveSegment(iter.next());
        }
        return ccsl;
    }

    @Override
    public ClosedCurveSegmentList getCopy(CoordSys csys) {
        ClosedCurveSegmentList ccsl = new ClosedCurveSegmentList(this.size());
        Iterator<CurveSegment> iter = super.getCopy(csys).iterator();
        while (iter.hasNext()) {
            ccsl.addCurveSegment(iter.next());
        }
        return ccsl;
    }

    @Override
    public ClosedCurveSegmentList reverse() {
        ClosedCurveSegmentList ccsl = new ClosedCurveSegmentList(this.size());
        Iterator<CurveSegment> iter = super.reverse().iterator();
        while (iter.hasNext()) {
            ccsl.addCurveSegment(iter.next());
        }
        return ccsl;
    }
}

