/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.UnmodifiableDirectPositionArray;

public abstract class CurveSegment
implements ICurveSegment {
    private final IDirectPositionList m_dpa;
    private final SpatialInfo m_spatialInfo;
    private Envelope m_envelope = null;
    private ICurveSegment m_leftSibling = null;
    private ICurveSegment m_rightSibling = null;

    protected CurveSegment(SpatialInfo si, IDirectPositionList dpa) {
        this.m_spatialInfo = si;
        this.m_dpa = dpa;
    }

    protected CurveSegment(SpatialInfo si, IDirectPositionList ptList, Envelope bounds) {
        this(si, ptList);
        this.m_envelope = bounds;
    }

    @Override
    public boolean zSet() {
        return this.m_dpa.zSet();
    }

    @Override
    public boolean zAllSet() {
        return this.m_dpa.zAllSet();
    }

    @Override
    public boolean mSet() {
        return this.m_dpa.mSet();
    }

    @Override
    public boolean mAllSet() {
        return this.m_dpa.mAllSet();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public boolean isEmpty() {
        return this.m_dpa.isEmpty();
    }

    @Override
    public int getControlPointCount() {
        return this.m_dpa.size();
    }

    @Override
    public DirectPosition getControlPoint(int i, DirectPosition dp) {
        return this.m_dpa.getDirectPosition(i, dp);
    }

    @Override
    public IDirectPositionIterator getControlPointIterator() {
        return this.m_dpa.getDirectPositionIterator();
    }

    @Override
    public boolean isClosed() {
        return this.getEndPosition().equals((Object)this.getStartPosition());
    }

    @Override
    public IDirectPositionList getControlPoints() {
        return new UnmodifiableDirectPositionArray(this.m_dpa);
    }

    @Override
    public DirectPosition getStartPosition() {
        return this.m_dpa.getDirectPosition(0, new DirectPosition());
    }

    @Override
    public DirectPosition getEndPosition() {
        return this.m_dpa.getDirectPosition(this.m_dpa.size() - 1, new DirectPosition());
    }

    void setLeftSibling(ICurveSegment ls) {
        this.m_leftSibling = ls;
    }

    void setRightSibling(ICurveSegment rs) {
        this.m_rightSibling = rs;
    }

    ICurveSegment getLeftSibling() {
        return this.m_leftSibling;
    }

    ICurveSegment getRightSibling() {
        return this.m_rightSibling;
    }

    @Override
    public Envelope getEnvelope() {
        if (this.m_envelope == null) {
            this.m_envelope = new Envelope(this.getSpatialInfo());
            this.m_envelope.extend(this.m_dpa);
        }
        return this.m_envelope.getCopy();
    }

    public boolean isContiguousTo(CurveSegment cs) {
        return this.getEndPosition().equals((Object)cs.getStartPosition());
    }

    @Override
    public SpatialInfo getSpatialInfo() {
        return this.m_spatialInfo;
    }

    @Override
    public CoordSys getCoordSys() {
        return this.m_spatialInfo.getCoordSys();
    }

    @Override
    public abstract CurveSegment reverse();

    @Override
    public abstract CurveSegment getCopy();

    @Override
    public abstract CurveSegment getCopy(CoordSys var1);
}

