/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IDirectPositionMutator;
import com.mapinfo.midev.geometry.MValue;
import com.mapinfo.midev.geometry.impl.DirectPositionTransform;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class DirectPositionArray
implements IDirectPositionList {
    private double[] m_x;
    private double[] m_y;
    private double[] m_z;
    private MValue[] m_m;
    private int m_size = 0;
    private int m_zCount = 0;
    private int m_mCount = 0;
    private long m_modCount = 0L;
    private static final int CAPACITY_GROWTH_FACTOR = 2;
    private static final int CAPACITY_MINIMUM = 16;

    public DirectPositionArray() {
        this(0);
    }

    public DirectPositionArray(int initialSize) {
        this.initializeCapacity(initialSize, false, false);
    }

    public DirectPositionArray(DirectPosition ... dpArray) {
        this.initializeCapacity(dpArray.length, false, false);
        for (DirectPosition dp : dpArray) {
            if (!this.zSet() && dp.zSet() || !this.mSet() && dp.mSet()) {
                this.ensureCapacity(dpArray.length, dp.zSet(), dp.mSet());
            }
            this._add(dp.getX(), dp.getY(), dp.getZ(), dp.getM());
        }
        this.m_size = dpArray.length;
    }

    public DirectPositionArray(DirectPositionArray dpa) {
        this.initializeFromDirectPositionArray(dpa);
    }

    private void initializeFromDirectPositionArray(DirectPositionArray dpa) {
        this.initializeCapacity(dpa.size(), dpa.zSet(), dpa.mSet());
        this.m_size = dpa.size();
        System.arraycopy(dpa.m_x, 0, this.m_x, 0, this.m_size);
        System.arraycopy(dpa.m_y, 0, this.m_y, 0, this.m_size);
        if (dpa.zSet()) {
            System.arraycopy(dpa.m_z, 0, this.m_z, 0, this.m_size);
            this.m_zCount = dpa.m_zCount;
        }
        if (dpa.mSet()) {
            System.arraycopy(dpa.m_m, 0, this.m_m, 0, this.m_size);
            this.m_mCount = dpa.m_mCount;
        }
    }

    public DirectPositionArray(IDirectPositionList dplist) {
        if (dplist instanceof DirectPositionArray) {
            this.initializeFromDirectPositionArray((DirectPositionArray)dplist);
        } else {
            this.initializeCapacity(dplist.size(), dplist.zSet(), dplist.mSet());
            DirectPosition dp = new DirectPosition();
            IDirectPositionIterator i = dplist.getDirectPositionIterator();
            while (i.hasNext()) {
                i.nextDirectPosition(dp);
                this._add(dp.getX(), dp.getY(), dp.getZ(), dp.getM());
            }
            this.m_size = dplist.size();
        }
    }

    public DirectPositionArray(double[] xArray, double[] yArray, int length) {
        this(xArray, yArray, null, null, length);
    }

    public DirectPositionArray(double[] xArray, double[] yArray, double[] zArray, int length) {
        this(xArray, yArray, zArray, null, length);
    }

    public DirectPositionArray(double[] xArray, double[] yArray, MValue[] mArray, int length) {
        this(xArray, yArray, null, mArray, length);
    }

    public DirectPositionArray(double[] xArray, double[] yArray, double[] zArray, MValue[] mArray, int length) {
        if (zArray == null && mArray == null) {
            this.initializeCapacity(length, false, false);
            System.arraycopy(xArray, 0, this.m_x, 0, length);
            System.arraycopy(yArray, 0, this.m_y, 0, length);
        } else if (zArray == null) {
            this.initializeCapacity(length, false, true);
            for (int i = 0; i < length; ++i) {
                this._add(xArray[i], yArray[i], mArray[i]);
            }
        } else if (mArray == null) {
            this.initializeCapacity(length, true, false);
            for (int i = 0; i < length; ++i) {
                this._add(xArray[i], yArray[i], zArray[i]);
            }
        } else {
            this.initializeCapacity(length, true, true);
            for (int i = 0; i < length; ++i) {
                this._add(xArray[i], yArray[i], zArray[i], mArray[i]);
            }
        }
        this.m_size = length;
    }

    @Override
    public IDirectPositionIterator getDirectPositionIterator() {
        return new DPIterator(this.m_modCount);
    }

    @Override
    public DirectPosition getDirectPosition(int index, DirectPosition dp) {
        this.verifyIndex(index, false);
        dp.set(this.m_x[index], this.m_y[index], this._getZ(index), this._getM(index));
        return dp;
    }

    @Override
    public int size() {
        return this.m_size;
    }

    @Override
    public void remove(int index) {
        this.verifyIndex(index, false);
        ++this.m_modCount;
        if (DirectPosition.zSet((double)this._getZ(index))) {
            --this.m_zCount;
            this.m_z[index] = Double.NaN;
        }
        if (DirectPosition.mSet((MValue)this._getM(index))) {
            --this.m_mCount;
            this.m_m[index] = null;
        }
        int srcPos = index + 1;
        int length = this.m_size - index - 1;
        if (length != 0) {
            System.arraycopy(this.m_x, srcPos, this.m_x, index, length);
            System.arraycopy(this.m_y, srcPos, this.m_y, index, length);
            if (this.m_z != null) {
                System.arraycopy(this.m_z, srcPos, this.m_z, index, length);
            }
            if (this.m_m != null) {
                System.arraycopy(this.m_m, srcPos, this.m_m, index, length);
            }
        }
        --this.m_size;
    }

    public double getX(int index) {
        this.verifyIndex(index, false);
        return this.m_x[index];
    }

    public double getY(int index) {
        this.verifyIndex(index, false);
        return this.m_y[index];
    }

    public double getZ(int index) {
        this.verifyIndex(index, false);
        return this._getZ(index);
    }

    private double _getZ(int index) {
        return this.m_z == null ? Double.NaN : this.m_z[index];
    }

    public void dropZ() {
        this.m_z = null;
        this.m_zCount = 0;
    }

    public void scaleZ(double dbl) {
        if (!this.zSet()) {
            return;
        }
        int k = 0;
        while (k < this.m_size) {
            int n = k++;
            this.m_z[n] = this.m_z[n] * dbl;
        }
    }

    public void initializeZ(double dbl) {
        this.ensureCapacity(this.m_size, true, false);
        Arrays.fill(this.m_z, 0, this.m_size, dbl);
        this.m_zCount = Double.isNaN(dbl) ? 0 : this.m_size;
    }

    public MValue getM(int index) {
        this.verifyIndex(index, false);
        return this._getM(index);
    }

    private MValue _getM(int index) {
        return this.m_m == null ? null : this.m_m[index];
    }

    public void dropM() {
        this.m_m = null;
        this.m_mCount = 0;
    }

    @Override
    public void set(int index, DirectPosition dp) {
        this.set(index, dp.getX(), dp.getY(), dp.getZ(), dp.getM());
    }

    @Override
    public void set(int index, double x, double y) {
        this.verifyIndex(index, false);
        this._set(index, x, y);
    }

    @Override
    public void set(int index, double x, double y, double z) {
        this.verifyIndex(index, false);
        this.ensureCapacity(this.m_size, DirectPosition.zSet((double)z), false);
        this._set(index, x, y, z);
    }

    @Override
    public void set(int index, double x, double y, MValue m) {
        this.verifyIndex(index, false);
        this.ensureCapacity(this.m_size, false, DirectPosition.mSet((MValue)m));
        this._set(index, x, y, m);
    }

    @Override
    public void set(int index, double x, double y, double z, MValue m) {
        this.verifyIndex(index, false);
        this.ensureCapacity(this.m_size, DirectPosition.zSet((double)z), DirectPosition.mSet((MValue)m));
        this._set(index, x, y, z, m);
    }

    private void verifyIndex(int index, boolean upperBoundInclusive) {
        if (upperBoundInclusive ? index < 0 || index > this.m_size : index < 0 || index >= this.m_size) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
    }

    private void _set(int index, double x, double y) {
        if (DirectPosition.zSet((double)this._getZ(index))) {
            this.m_z[index] = Double.NaN;
            --this.m_zCount;
        }
        if (DirectPosition.mSet((MValue)this._getM(index))) {
            this.m_m[index] = null;
            --this.m_mCount;
        }
        this.m_x[index] = x;
        this.m_y[index] = y;
    }

    private void _set(int index, double x, double y, double z) {
        if (DirectPosition.zSet((double)this._getZ(index))) {
            this.m_z[index] = Double.NaN;
            --this.m_zCount;
        }
        if (DirectPosition.mSet((MValue)this._getM(index))) {
            this.m_m[index] = null;
            --this.m_mCount;
        }
        this.m_x[index] = x;
        this.m_y[index] = y;
        if (DirectPosition.zSet((double)z)) {
            this.m_z[index] = z;
            ++this.m_zCount;
        }
    }

    private void _set(int index, double x, double y, MValue m) {
        if (DirectPosition.zSet((double)this._getZ(index))) {
            this.m_z[index] = Double.NaN;
            --this.m_zCount;
        }
        if (DirectPosition.mSet((MValue)this._getM(index))) {
            this.m_m[index] = null;
            --this.m_mCount;
        }
        this.m_x[index] = x;
        this.m_y[index] = y;
        if (DirectPosition.mSet((MValue)m)) {
            this.m_m[index] = m;
            ++this.m_mCount;
        }
    }

    private void _set(int index, double x, double y, double z, MValue m) {
        if (DirectPosition.zSet((double)this._getZ(index))) {
            this.m_z[index] = Double.NaN;
            --this.m_zCount;
        }
        if (DirectPosition.mSet((MValue)this._getM(index))) {
            this.m_m[index] = null;
            --this.m_mCount;
        }
        this.m_x[index] = x;
        this.m_y[index] = y;
        if (DirectPosition.zSet((double)z)) {
            this.m_z[index] = z;
            ++this.m_zCount;
        }
        if (DirectPosition.mSet((MValue)m)) {
            this.m_m[index] = m;
            ++this.m_mCount;
        }
    }

    @Override
    public void add(int index, DirectPosition dp) {
        this.add(index, dp.getX(), dp.getY(), dp.getZ(), dp.getM());
    }

    @Override
    public void add(int index, double x, double y) {
        this.verifyIndex(index, true);
        ++this.m_modCount;
        this.ensureCapacity(this.m_size + 1, false, false);
        this.shiftRight(index, 1);
        ++this.m_size;
        this._set(index, x, y);
    }

    @Override
    public void add(int index, double x, double y, double z) {
        this.verifyIndex(index, true);
        ++this.m_modCount;
        this.ensureCapacity(this.m_size + 1, DirectPosition.zSet((double)z), false);
        this.shiftRight(index, 1);
        ++this.m_size;
        this._set(index, x, y, z);
    }

    @Override
    public void add(int index, double x, double y, MValue m) {
        this.verifyIndex(index, true);
        ++this.m_modCount;
        this.ensureCapacity(this.m_size + 1, false, DirectPosition.mSet((MValue)m));
        this.shiftRight(index, 1);
        ++this.m_size;
        this._set(index, x, y, m);
    }

    @Override
    public void add(int index, double x, double y, double z, MValue m) {
        this.verifyIndex(index, true);
        ++this.m_modCount;
        this.ensureCapacity(this.m_size + 1, DirectPosition.zSet((double)z), DirectPosition.mSet((MValue)m));
        this.shiftRight(index, 1);
        ++this.m_size;
        this._set(index, x, y, z, m);
    }

    private void initializeCapacity(int initialCapacity, boolean bInitZ, boolean bInitM) {
        this.m_x = new double[initialCapacity];
        this.m_y = new double[initialCapacity];
        if (bInitZ) {
            this.m_z = new double[initialCapacity];
            Arrays.fill(this.m_z, Double.NaN);
        }
        if (bInitM) {
            this.m_m = new MValue[initialCapacity];
        }
    }

    private void ensureCapacity(int requiredCapacity, boolean bEnsureZ, boolean bEnsureM) {
        if (requiredCapacity <= this.m_x.length && !bEnsureZ && !bEnsureM) {
            return;
        }
        if (requiredCapacity <= this.m_x.length && (bEnsureZ || bEnsureM) && bEnsureZ == (this.m_z != null) && bEnsureM == (this.m_m != null)) {
            return;
        }
        int newCapacity = this.m_x.length;
        while (requiredCapacity > newCapacity) {
            int num = 2 * newCapacity;
            newCapacity = Math.max(num, 16);
        }
        if (newCapacity > this.m_x.length) {
            double[] tmp = new double[newCapacity];
            System.arraycopy(this.m_x, 0, tmp, 0, this.m_size);
            this.m_x = tmp;
            tmp = new double[newCapacity];
            System.arraycopy(this.m_y, 0, tmp, 0, this.m_size);
            this.m_y = tmp;
        }
        if (this.m_z != null || bEnsureZ) {
            double[] tmp = new double[newCapacity];
            if (this.m_z != null) {
                System.arraycopy(this.m_z, 0, tmp, 0, this.m_size);
                Arrays.fill(tmp, this.m_size, tmp.length, Double.NaN);
            } else {
                Arrays.fill(tmp, Double.NaN);
            }
            this.m_z = tmp;
        }
        if (this.m_m != null || bEnsureM) {
            MValue[] tmpmv = new MValue[newCapacity];
            if (this.m_m != null) {
                System.arraycopy(this.m_m, 0, tmpmv, 0, this.m_size);
            }
            this.m_m = tmpmv;
        }
    }

    private void shiftRight(int index, int count) {
        int destIndex = index + count;
        int len = this.m_size - index;
        if (len != 0) {
            System.arraycopy(this.m_x, index, this.m_x, destIndex, len);
            System.arraycopy(this.m_y, index, this.m_y, destIndex, len);
            if (this.zSet()) {
                System.arraycopy(this.m_z, index, this.m_z, destIndex, len);
                Arrays.fill(this.m_z, index, index + len, Double.NaN);
            }
            if (this.mSet()) {
                System.arraycopy(this.m_m, index, this.m_m, destIndex, len);
                Arrays.fill(this.m_m, index, index + len, null);
            }
        }
    }

    @Override
    public int indexOf(DirectPosition dp) {
        int index = -1;
        DirectPosition dpTmp = new DirectPosition();
        for (int k = 0; k < this.size() && index == -1; ++k) {
            dpTmp.set(this.m_x[k], this.m_y[k], this._getZ(k), this._getM(k));
            if (!dp.equals((Object)dpTmp)) continue;
            index = k;
        }
        return index;
    }

    @Override
    public int lastIndexOf(DirectPosition dp) {
        int index = -1;
        DirectPosition dpTmp = new DirectPosition();
        for (int k = this.size() - 1; k >= 0 && index == -1; --k) {
            dpTmp.set(this.m_x[k], this.m_y[k], this._getZ(k), this._getM(k));
            if (!dp.equals((Object)dpTmp)) continue;
            index = k;
        }
        return index;
    }

    @Override
    public void add(DirectPosition dp) {
        this.add(dp.getX(), dp.getY(), dp.getZ(), dp.getM());
    }

    @Override
    public void add(double x, double y) {
        ++this.m_modCount;
        this.ensureCapacity(this.m_size + 1, false, false);
        this._add(x, y);
    }

    @Override
    public void add(double x, double y, double z) {
        ++this.m_modCount;
        this.ensureCapacity(this.m_size + 1, DirectPosition.zSet((double)z), false);
        this._add(x, y, z);
    }

    @Override
    public void add(double x, double y, MValue m) {
        ++this.m_modCount;
        this.ensureCapacity(this.m_size + 1, false, DirectPosition.mSet((MValue)m));
        this._add(x, y, m);
    }

    @Override
    public void add(double x, double y, double z, MValue m) {
        ++this.m_modCount;
        this.ensureCapacity(this.m_size + 1, DirectPosition.zSet((double)z), DirectPosition.mSet((MValue)m));
        this._add(x, y, z, m);
    }

    private void _add(double x, double y) {
        this.m_x[this.m_size] = x;
        this.m_y[this.m_size] = y;
        ++this.m_size;
    }

    private void _add(double x, double y, double z) {
        this.m_x[this.m_size] = x;
        this.m_y[this.m_size] = y;
        if (DirectPosition.zSet((double)z)) {
            this.m_z[this.m_size] = z;
            ++this.m_zCount;
        }
        ++this.m_size;
    }

    private void _add(double x, double y, MValue m) {
        this.m_x[this.m_size] = x;
        this.m_y[this.m_size] = y;
        if (DirectPosition.mSet((MValue)m)) {
            this.m_m[this.m_size] = m;
            ++this.m_mCount;
        }
        ++this.m_size;
    }

    private void _add(double x, double y, double z, MValue m) {
        this.m_x[this.m_size] = x;
        this.m_y[this.m_size] = y;
        if (DirectPosition.zSet((double)z)) {
            this.m_z[this.m_size] = z;
            ++this.m_zCount;
        }
        if (DirectPosition.mSet((MValue)m)) {
            this.m_m[this.m_size] = m;
            ++this.m_mCount;
        }
        ++this.m_size;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return this.indexOf(dp) != -1;
    }

    public void addAll(int index, IDirectPositionList dpl) {
        this.verifyIndex(index, true);
        this.ensureCapacity(this.m_size + dpl.size(), dpl.zSet(), dpl.mSet());
        ++this.m_modCount;
        this.shiftRight(index, dpl.size());
        this.m_size += dpl.size();
        IDirectPositionIterator iter = dpl.getDirectPositionIterator();
        DirectPosition dp = new DirectPosition();
        int pos = index;
        while (iter.hasNext()) {
            iter.nextDirectPosition(dp);
            this._set(pos++, dp.getX(), dp.getY(), dp.getZ(), dp.getM());
        }
    }

    @Override
    public void addAll(IDirectPositionList dpl) {
        if (dpl.isEmpty()) {
            return;
        }
        this.ensureCapacity(this.m_size + dpl.size(), dpl.zSet(), dpl.mSet());
        ++this.m_modCount;
        if (dpl instanceof DirectPositionArray) {
            DirectPositionArray dpa = (DirectPositionArray)dpl;
            System.arraycopy(dpa.m_x, 0, this.m_x, this.m_size, dpa.m_size);
            System.arraycopy(dpa.m_y, 0, this.m_y, this.m_size, dpa.m_size);
            if (dpa.zSet()) {
                System.arraycopy(dpa.m_z, 0, this.m_z, this.m_size, dpa.m_size);
                this.m_zCount += dpa.m_zCount;
            }
            if (dpa.mSet()) {
                System.arraycopy(dpa.m_m, 0, this.m_m, this.m_size, dpa.m_size);
                this.m_mCount += dpa.m_mCount;
            }
            this.m_size += dpa.m_size;
        } else {
            DirectPosition dp = new DirectPosition();
            IDirectPositionIterator dpIter = dpl.getDirectPositionIterator();
            while (dpIter.hasNext()) {
                dp = dpIter.nextDirectPosition(dp);
                this._add(dp.getX(), dp.getY(), dp.getZ(), dp.getM());
            }
        }
    }

    @Override
    public void clear() {
        this.m_z = null;
        this.m_m = null;
        this.m_size = 0;
        this.m_zCount = 0;
        this.m_mCount = 0;
        ++this.m_modCount;
    }

    @Override
    public boolean isEmpty() {
        return this.m_size == 0;
    }

    @Override
    public void applyMutator(IDirectPositionMutator dpm) {
        DirectPosition dp = new DirectPosition();
        for (int k = 0; k < this.size(); ++k) {
            dp.set(this.m_x[k], this.m_y[k], this._getZ(k), this._getM(k));
            dpm.transform(dp, dp);
            this._set(k, dp.getX(), dp.getY(), dp.getZ(), dp.getM());
        }
    }

    public DirectPositionArray getCopy() {
        return new DirectPositionArray(this);
    }

    public DirectPositionArray getCopy(IDirectPositionMutator dpMutator) {
        DirectPositionArray dpa = new DirectPositionArray(this);
        dpa.change(dpMutator);
        return dpa;
    }

    void change(DirectPositionTransform dpXform) {
        if (!(dpXform.changeXY() || this.zSet() && dpXform.changeZ())) {
            return;
        }
        this.change((IDirectPositionMutator)dpXform);
    }

    void change(IDirectPositionMutator dpMutator) {
        DirectPosition dp = new DirectPosition();
        for (int k = 0; k < this.size(); ++k) {
            dp.set(this.m_x[k], this.m_y[k], this._getZ(k), this._getM(k));
            dp = dpMutator.transform(dp, dp);
            if (!this.zSet() && dp.zSet()) {
                this.ensureCapacity(this.size(), true, false);
            }
            if (!this.mSet() && dp.mSet()) {
                this.ensureCapacity(this.size(), false, true);
            }
            this._set(k, dp.getX(), dp.getY(), dp.getZ(), dp.getM());
        }
    }

    @Override
    public boolean zSet() {
        return this.m_zCount != 0;
    }

    @Override
    public boolean zAllSet() {
        return this.m_size != 0 && this.m_size == this.m_zCount;
    }

    @Override
    public boolean mSet() {
        return this.m_mCount != 0;
    }

    @Override
    public boolean mAllSet() {
        return this.m_size != 0 && this.m_size == this.m_mCount;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public DirectPositionArray reverse() {
        double[] x = new double[this.size()];
        double[] y = new double[this.size()];
        double[] z = null;
        if (this.zSet()) {
            z = new double[this.size()];
        }
        MValue[] m = null;
        if (this.mSet()) {
            m = new MValue[this.size()];
        }
        int left = 0;
        for (int right = this.size() - 1; left < right; ++left, --right) {
            x[left] = this.m_x[right];
            x[right] = this.m_x[left];
            y[left] = this.m_y[right];
            y[right] = this.m_y[left];
            if (z != null) {
                z[left] = this.m_z[right];
                z[right] = this.m_z[left];
            }
            y[right] = this.m_y[left];
            if (m == null) continue;
            m[left] = this.m_m[right];
            m[right] = this.m_m[left];
        }
        if (this.size() % 2 != 0) {
            int index = this.size() / 2;
            x[index] = this.m_x[index];
            y[index] = this.m_y[index];
            if (z != null) {
                z[index] = this.m_z[index];
            }
            if (m != null) {
                m[index] = this.m_m[index];
            }
        }
        return new DirectPositionArray(x, y, z, m, this.size());
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DirectPositionArray)) {
            return false;
        }
        DirectPositionArray that = (DirectPositionArray)obj;
        if (this.size() != that.size()) {
            return false;
        }
        if (this.isEmpty() != that.isEmpty()) {
            return false;
        }
        if (this.mSet() != that.mSet()) {
            return false;
        }
        if (this.mAllSet() != that.mAllSet()) {
            return false;
        }
        if (this.zSet() != that.zSet()) {
            return false;
        }
        if (this.zAllSet() != that.zAllSet()) {
            return false;
        }
        if (!Arrays.equals(this.m_x, that.m_x)) {
            return false;
        }
        if (!Arrays.equals(this.m_y, that.m_y)) {
            return false;
        }
        if (!Arrays.equals(this.m_z, that.m_z)) {
            return false;
        }
        return Arrays.equals(this.m_m, that.m_m);
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 31).append(this.m_x).append(this.m_y).append(this.m_z).append((Object[])this.m_m).toHashCode();
    }

    private final class DPIterator
    implements IDirectPositionIterator {
        final long m_expectedModCount;
        int m_next = 0;

        public DPIterator(long modCount) {
            this.m_expectedModCount = modCount;
        }

        @Override
        public boolean hasNext() {
            return this.m_next < DirectPositionArray.this.m_size;
        }

        @Override
        public DirectPosition nextDirectPosition(DirectPosition dp) throws ConcurrentModificationException {
            if (this.m_expectedModCount != DirectPositionArray.this.m_modCount) {
                throw new ConcurrentModificationException();
            }
            return DirectPositionArray.this.getDirectPosition(this.m_next++, dp);
        }
    }
}

