/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.IDirectPositionMutator;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.unit.LinearUnit;

public class DirectPositionTransform
implements IDirectPositionMutator {
    private final CoordTransform m_xform;
    private final double m_zScale;

    public DirectPositionTransform(SpatialInfo spFrom, SpatialInfo spTo) {
        this(spFrom.getCoordSys(), spFrom.getZUnit(), spTo.getCoordSys(), spTo.getZUnit());
    }

    public DirectPositionTransform(CoordSys fromCsys, LinearUnit fromZUnit, CoordSys toCsys, LinearUnit toZUnit) {
        this.m_xform = !fromCsys.equivalent(toCsys) ? fromCsys.createCoordTransform(toCsys) : null;
        this.m_zScale = fromZUnit != null && toZUnit != null && fromZUnit != toZUnit ? fromZUnit.getMetersPerUnit() / toZUnit.getMetersPerUnit() : 1.0;
    }

    public DirectPosition transform(DirectPosition in, DirectPosition out) {
        if (in != out) {
            out.set(in);
        }
        if (this.changeXY()) {
            this.m_xform.transform(out, out);
        }
        if (this.changeZ() && in.zSet()) {
            out.setZ(in.getZ() * this.m_zScale);
        }
        return out;
    }

    public boolean changeXY() {
        return this.m_xform != null;
    }

    public boolean changeZ() {
        return this.m_zScale != 1.0;
    }
}

