/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.ILineString;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.InvalidGeometryTypeException;
import com.mapinfo.midev.geometry.MValue;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.UnsupportedGeometryOperationException;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.DirectPositionTransform;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.geometry.impl.LegacyArc;
import com.mapinfo.midev.geometry.impl.LegacyEllipse;
import com.mapinfo.midev.geometry.impl.LegacyRoundedRectangle;
import com.mapinfo.midev.geometry.impl.LegacyText;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.MultiCurve;
import com.mapinfo.midev.geometry.impl.MultiFeatureGeometry;
import com.mapinfo.midev.geometry.impl.MultiPoint;
import com.mapinfo.midev.geometry.impl.MultiPolygon;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.impl.Polygon;
import com.mapinfo.midev.geometry.impl.Rectangle;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.unit.Angle;
import com.mapinfo.midev.unit.PaperLength;
import com.mapinfo.midev.util.ArgumentValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class GeometryFactory {
    private final SpatialInfo m_spatialInfo;

    public GeometryFactory(SpatialInfo si) {
        ArgumentValidator.assertNotNullReference((String)"si", (Object)si);
        this.m_spatialInfo = si;
    }

    public SpatialInfo getSpatialInfo() {
        return this.m_spatialInfo;
    }

    public CoordSys getCoordSys() {
        return this.m_spatialInfo.getCoordSys();
    }

    public boolean isTransient() {
        return false;
    }

    public Point newPoint(double x, double y) {
        return new Point(this.m_spatialInfo, new DirectPosition(x, y));
    }

    public Point newPoint(double x, double y, double z) {
        return new Point(this.m_spatialInfo, new DirectPosition(x, y, z));
    }

    public Point newPoint(double x, double y, MValue m) {
        return new Point(this.m_spatialInfo, new DirectPosition(x, y, m));
    }

    public Point newPoint(double x, double y, double z, MValue m) {
        return new Point(this.m_spatialInfo, new DirectPosition(x, y, z, m));
    }

    public Point newPoint(DirectPosition dp) {
        return new Point(this.m_spatialInfo, new DirectPosition(dp));
    }

    public Point newPoint(IPoint pt) {
        DirectPosition dp = pt.getDirectPosition();
        DirectPositionTransform dpXform = new DirectPositionTransform(pt.getSpatialInfo(), this.m_spatialInfo);
        dp = dpXform.transform(dp, dp);
        return new Point(this.m_spatialInfo, dp);
    }

    public LineString newLineString(IDirectPositionList dpl) throws InvalidGeometryException {
        if (dpl.isEmpty()) {
            throw new InvalidGeometryException("Invalid empty IDirectPositionList");
        }
        DirectPositionArray dpa = new DirectPositionArray(dpl);
        if (dpa.size() == 1) {
            DirectPosition dp = dpa.getDirectPosition(0, new DirectPosition());
            dpa.add(dp);
        }
        return new LineString(this.m_spatialInfo, dpa);
    }

    public LineString newLineString(ILineString ls) {
        DirectPositionArray dpa = new DirectPositionArray(ls.getControlPoints());
        DirectPositionTransform dpXform = new DirectPositionTransform(ls.getSpatialInfo(), this.m_spatialInfo);
        dpa.change(dpXform);
        return new LineString(this.m_spatialInfo, dpa);
    }

    public Curve newCurve(IDirectPositionList dplist, GeometryType gtype) {
        CurveSegment cs = this.newCurveSegment(dplist, gtype);
        return new Curve(this.m_spatialInfo, cs);
    }

    private CurveSegment newCurveSegment(IDirectPositionList dplist, GeometryType gtype) {
        LineString cs;
        if (!GeometryType.ALL_CURVE_SEGMENT_TYPE.contains((Object)gtype)) {
            throw new InvalidGeometryTypeException(gtype);
        }
        switch (gtype) {
            case LINE_STRING: {
                cs = this.newLineString(dplist);
                break;
            }
            default: {
                throw new UnsupportedGeometryOperationException(gtype.toString());
            }
        }
        return cs;
    }

    public Curve newCurve(ICurveSegment cseg) {
        CurveSegment cs = this.copyAndTransformCurveSegments(Collections.singletonList(cseg).iterator()).get(0);
        return new Curve(this.m_spatialInfo, cs);
    }

    public Curve newCurve(List<ICurveSegment> segList) throws InvalidGeometryException {
        return new Curve(this.m_spatialInfo, this.copyAndTransformCurveSegments(segList.iterator()));
    }

    public Curve newCurve(ICurve curve) {
        List<CurveSegment> newSegList = this.copyAndTransformCurveSegments(curve.iterator());
        return new Curve(this.m_spatialInfo, newSegList);
    }

    private List<CurveSegment> copyAndTransformCurveSegments(Iterator<ICurveSegment> csIter) {
        ArrayList<CurveSegment> newSegList = new ArrayList<CurveSegment>();
        block3: while (csIter.hasNext()) {
            ICurveSegment cseg = csIter.next();
            DirectPositionArray dpa = new DirectPositionArray(cseg.getControlPoints());
            DirectPositionTransform dpXform = new DirectPositionTransform(cseg.getSpatialInfo(), this.m_spatialInfo);
            dpa.change(dpXform);
            GeometryType gtype = cseg.getType();
            switch (gtype) {
                case LINE_STRING: {
                    LineString ls = new LineString(this.m_spatialInfo, dpa);
                    newSegList.add(ls);
                    continue block3;
                }
            }
            throw new UnsupportedGeometryOperationException(gtype.toString());
        }
        return newSegList;
    }

    public MultiCurve newMultiCurve() {
        return new MultiCurve(this.m_spatialInfo);
    }

    public MultiCurve newMultiCurve(IDirectPositionList dpl, GeometryType gtype) {
        Curve curve = this.newCurve(dpl, gtype);
        return new MultiCurve(curve.getSpatialInfo(), curve);
    }

    public MultiCurve newMultiCurve(ICurveSegment cseg) {
        MultiCurve mcCurve;
        GeometryType gtype = cseg.getType();
        switch (gtype) {
            case LINE_STRING: {
                DirectPositionArray dpa = new DirectPositionArray(cseg.getControlPoints());
                if (dpa.size() == 1) {
                    DirectPosition dp = dpa.getDirectPosition(0, new DirectPosition());
                    dpa.add(dp);
                }
                DirectPositionTransform dpXform = new DirectPositionTransform(cseg.getSpatialInfo(), this.m_spatialInfo);
                dpa.change(dpXform);
                LineString ls = new LineString(this.m_spatialInfo, dpa);
                mcCurve = new MultiCurve(ls.getSpatialInfo(), ls);
                break;
            }
            default: {
                throw new UnsupportedGeometryOperationException(gtype.toString());
            }
        }
        return mcCurve;
    }

    public MultiCurve newMultiCurveFromCurveSegments(Collection<? extends ICurveSegment> curveSegmentList) {
        if (curveSegmentList.isEmpty()) {
            return this.newMultiCurve();
        }
        ArrayList<Curve> curveList = new ArrayList<Curve>(curveSegmentList.size());
        for (ICurveSegment iCurveSegment : curveSegmentList) {
            curveList.add(this.newCurve(iCurveSegment));
        }
        return new MultiCurve(this.m_spatialInfo, curveList);
    }

    public MultiCurve newMultiCurve(ICurve curve) {
        return this.newMultiCurve(Collections.singletonList(curve));
    }

    public MultiCurve newMultiCurve(Collection<? extends ICurve> curveList) {
        if (curveList.isEmpty()) {
            return this.newMultiCurve();
        }
        ArrayList<Curve> newCurveList = new ArrayList<Curve>(curveList.size());
        for (ICurve iCurve : curveList) {
            Curve curveCopy = this.newCurve(iCurve);
            newCurveList.add(curveCopy);
        }
        return new MultiCurve(this.m_spatialInfo, newCurveList);
    }

    public MultiCurve newMultiCurve(IMultiCurve multiCurve) {
        if (multiCurve.isEmpty()) {
            return this.newMultiCurve();
        }
        ArrayList<ICurve> curveList = new ArrayList<ICurve>(multiCurve.getCurveCount());
        for (ICurve c : multiCurve) {
            curveList.add(c);
        }
        MultiCurve mCurve = this.newMultiCurve(curveList);
        try {
            DirectPosition rp = multiCurve.getRepresentativePoint();
            DirectPositionTransform dpXform = new DirectPositionTransform(multiCurve.getSpatialInfo(), this.m_spatialInfo);
            rp = dpXform.transform(rp, rp);
            mCurve.setRepresentativePoint(rp);
        }
        catch (Throwable e) {
            // empty catch block
        }
        return mCurve;
    }

    public IFeatureGeometry newFeatureGeometry(IGeometry geom) {
        IFeatureGeometry fg;
        GeometryType gtype = geom.getType();
        if (GeometryType.ALL_FEATURE_GEOMETRY_TYPE.contains((Object)gtype)) {
            fg = this.newFeatureGeometry((IFeatureGeometry)geom);
        } else if (GeometryType.ALL_CURVE_SEGMENT_TYPE.contains((Object)gtype)) {
            fg = this.newMultiCurve((ICurveSegment)geom);
        } else if (GeometryType.CURVE == gtype) {
            fg = this.newMultiCurve((ICurve)geom);
        } else if (GeometryType.RING == gtype) {
            fg = this.newMultiPolygon((IRing)geom);
        } else if (GeometryType.POLYGON == gtype) {
            fg = this.newMultiPolygon((IPolygon)geom);
        } else {
            throw new UnsupportedGeometryOperationException(gtype.toString());
        }
        return fg;
    }

    public IFeatureGeometry newFeatureGeometry(IFeatureGeometry fg) {
        IFeatureGeometry newfg;
        GeometryType fgType = fg.getType();
        switch (fgType) {
            case POINT: {
                newfg = this.newPoint((IPoint)fg);
                break;
            }
            case MULTI_POINT: {
                newfg = this.newMultiPoint((IMultiPoint)fg);
                break;
            }
            case MULTI_CURVE: {
                newfg = this.newMultiCurve((IMultiCurve)fg);
                break;
            }
            case MULTI_POLYGON: {
                newfg = this.newMultiPolygon((IMultiPolygon)fg);
                break;
            }
            case MULTI_FEATURE_GEOMETRY: {
                newfg = this.newMultiFeatureGeometry((IMultiFeatureGeometry)fg);
                break;
            }
            case RECTANGLE: {
                newfg = this.newRectangle((IRectangle)fg);
                break;
            }
            case ROUNDED_RECTANGLE: {
                newfg = this.newRoundedRectangle((ILegacyRoundedRectangle)fg);
                break;
            }
            case ELLIPSE: {
                newfg = this.newEllipse((ILegacyEllipse)fg);
                break;
            }
            case LEGACY_ARC: {
                newfg = this.newLegacyArc((ILegacyArc)fg);
                break;
            }
            case LEGACY_TEXT: {
                newfg = this.newLegacyText((ILegacyText)fg);
                break;
            }
            default: {
                throw new UnsupportedGeometryOperationException(fgType.toString());
            }
        }
        return newfg;
    }

    public IGeometry newGeometry(IGeometry geom) {
        IGeometry g;
        GeometryType gtype = geom.getType();
        if (GeometryType.ALL_FEATURE_GEOMETRY_TYPE.contains((Object)gtype)) {
            g = this.newFeatureGeometry((IFeatureGeometry)geom);
        } else {
            switch (gtype) {
                case LINE_STRING: {
                    g = this.newLineString((ILineString)geom);
                    break;
                }
                case CURVE: {
                    g = this.newCurve((ICurve)geom);
                    break;
                }
                case RING: {
                    g = this.newRing((IRing)geom);
                    break;
                }
                case POLYGON: {
                    g = this.newPolygon((IPolygon)geom);
                    break;
                }
                default: {
                    throw new UnsupportedGeometryOperationException(gtype.toString());
                }
            }
        }
        return g;
    }

    public LegacyArc newLegacyArc(DirectPosition ll, DirectPosition ur, Angle begin, Angle end) {
        Rectangle rect = new Rectangle(this.m_spatialInfo, ll.getCopy(), ur.getCopy());
        return new LegacyArc(rect, begin, end);
    }

    public LegacyArc newLegacyArc(IRectangle rect, Angle begin, Angle end) {
        Rectangle r = this.newRectangle(rect);
        return new LegacyArc(r, begin, end);
    }

    public LegacyArc newLegacyArc(ILegacyArc larc) {
        Envelope env = larc.getCopy(this.getCoordSys()).getEnvelope();
        return this.newLegacyArc(env.getLowerLeft(), env.getUpperRight(), larc.getBeginAngle(), larc.getEndAngle());
    }

    public LegacyText newLegacyText(DirectPosition ll, DirectPosition ur, String text) {
        Rectangle rect = new Rectangle(this.m_spatialInfo, ll, ur);
        return new LegacyText(rect, text);
    }

    public LegacyText newLegacyText(IRectangle rect, String text) {
        return this.newLegacyText(rect, text, null, ILegacyText.TextCalloutType.NONE, null);
    }

    public LegacyText newLegacyText(IRectangle rect, String text, Angle angle) {
        return this.newLegacyText(rect, text, angle, ILegacyText.TextCalloutType.NONE, null);
    }

    public LegacyText newLegacyText(IRectangle rect, String text, Angle angle, ILegacyText.TextCalloutType type, DirectPosition target) {
        Rectangle r = this.newRectangle(rect);
        DirectPosition newTarget = null;
        if (target != null) {
            CoordTransform dpXform = rect.getCoordSys().createCoordTransform(this.getCoordSys());
            newTarget = dpXform.transform(target, new DirectPosition());
        }
        return new LegacyText(r, text, angle, type, newTarget);
    }

    public ILegacyText newLegacyText(ILegacyText ltext) {
        return this.newLegacyText(ltext.getRectangle(), ltext.getText(), ltext.getAngle(), ltext.getTextCalloutType(), ltext.getCalloutTarget());
    }

    public MultiFeatureGeometry newMultiFeatureGeometry() {
        return new MultiFeatureGeometry(this.m_spatialInfo);
    }

    public MultiFeatureGeometry newMultiFeatureGeometry(IGeometry geom) {
        MultiFeatureGeometry mfg = geom.getType() == GeometryType.MULTI_FEATURE_GEOMETRY ? this.newMultiFeatureGeometry((IMultiFeatureGeometry)geom) : this.newMultiFeatureGeometryFromGeometry(Collections.singletonList(geom));
        return mfg;
    }

    public MultiFeatureGeometry newMultiFeatureGeometry(IFeatureGeometry fg) {
        MultiFeatureGeometry mfg = fg.getType() == GeometryType.MULTI_FEATURE_GEOMETRY ? this.newMultiFeatureGeometry((IMultiFeatureGeometry)fg) : this.newMultiFeatureGeometry(Collections.singletonList(fg));
        return mfg;
    }

    public MultiFeatureGeometry newMultiFeatureGeometry(Collection<? extends IFeatureGeometry> fgeom) {
        ArrayList<FeatureGeometry> newfgList = new ArrayList<FeatureGeometry>(fgeom.size());
        for (IFeatureGeometry iFeatureGeometry : fgeom) {
            if (iFeatureGeometry == null || iFeatureGeometry.isEmpty()) continue;
            GeometryType gtype = iFeatureGeometry.getType();
            if (!GeometryType.MULTI_FEATURE_GEOMETRY_CONTENTS_TYPE.contains((Object)gtype)) {
                throw new InvalidGeometryTypeException(gtype);
            }
            FeatureGeometry newfg = (FeatureGeometry)this.newFeatureGeometry(iFeatureGeometry);
            newfgList.add(newfg);
        }
        return new MultiFeatureGeometry(this.m_spatialInfo, newfgList);
    }

    public MultiFeatureGeometry newMultiFeatureGeometryFromGeometry(Collection<? extends IGeometry> geom) {
        ArrayList<FeatureGeometry> newfgList = new ArrayList<FeatureGeometry>(geom.size());
        for (IGeometry iGeometry : geom) {
            FeatureGeometry newfg;
            if (iGeometry == null || iGeometry.isEmpty()) continue;
            GeometryType gtype = iGeometry.getType();
            if (GeometryType.MULTI_FEATURE_GEOMETRY_CONTENTS_TYPE.contains((Object)gtype)) {
                newfg = (FeatureGeometry)this.newFeatureGeometry(iGeometry);
            } else if (GeometryType.ALL_NON_FEATURE_GEOMETRY_TYPE.contains((Object)gtype)) {
                newfg = (FeatureGeometry)this.newFeatureGeometry(iGeometry);
            } else {
                throw new InvalidGeometryTypeException(gtype);
            }
            newfgList.add(newfg);
        }
        return new MultiFeatureGeometry(this.m_spatialInfo, newfgList);
    }

    public MultiFeatureGeometry newMultiFeatureGeometry(IMultiFeatureGeometry mfg) {
        ArrayList<FeatureGeometry> newfg = new ArrayList<FeatureGeometry>(mfg.getFeatureGeometryCount());
        for (IFeatureGeometry fg : mfg) {
            newfg.add((FeatureGeometry)this.newFeatureGeometry(fg));
        }
        return new MultiFeatureGeometry(this.m_spatialInfo, newfg);
    }

    public MultiPoint newMultiPoint() {
        return new MultiPoint(this.m_spatialInfo);
    }

    public MultiPoint newMultiPoint(DirectPosition dp) {
        return new MultiPoint(this.m_spatialInfo, dp);
    }

    public MultiPoint newMultiPoint(IDirectPositionList dpl) {
        DirectPositionArray dpa = new DirectPositionArray(dpl);
        return new MultiPoint(this.m_spatialInfo, dpa);
    }

    public MultiPoint newMultiPoint(IPoint point) {
        DirectPosition dp = point.getDirectPosition();
        DirectPositionTransform dpXform = new DirectPositionTransform(point.getSpatialInfo(), this.m_spatialInfo);
        dpXform.transform(dp, dp);
        return new MultiPoint(this.m_spatialInfo, dp);
    }

    public MultiPoint newMultiPoint(Collection<? extends IPoint> pointList) {
        if (pointList.isEmpty()) {
            return this.newMultiPoint();
        }
        DirectPositionArray dpa = new DirectPositionArray(pointList.size());
        Iterator<? extends IPoint> iter = pointList.iterator();
        IPoint point = iter.next();
        SpatialInfo si = point.getSpatialInfo();
        DirectPosition dp = point.getDirectPosition();
        dpa.add(dp);
        while (iter.hasNext()) {
            dp = iter.next().getDirectPosition();
            dpa.add(dp);
        }
        DirectPositionTransform dpXform = new DirectPositionTransform(si, this.m_spatialInfo);
        dpa.change(dpXform);
        return new MultiPoint(this.m_spatialInfo, dpa);
    }

    public MultiPoint newMultiPoint(IMultiPoint multiPoint) {
        DirectPositionArray dpa = new DirectPositionArray(multiPoint.getPositions());
        DirectPositionTransform dpXform = new DirectPositionTransform(multiPoint.getSpatialInfo(), this.m_spatialInfo);
        dpa.change(dpXform);
        return new MultiPoint(this.m_spatialInfo, dpa);
    }

    public MultiPolygon newMultiPolygon() {
        return new MultiPolygon(this.m_spatialInfo);
    }

    public MultiPolygon newMultiPolygon(IDirectPositionList dplist, GeometryType gtype) throws InvalidGeometryException {
        Polygon poly = this.newPolygon(dplist, gtype);
        return new MultiPolygon(this.m_spatialInfo, poly);
    }

    public MultiPolygon newMultiPolygon(ICurveSegment cseg) throws InvalidGeometryException {
        Polygon poly = this.newPolygon(cseg);
        return new MultiPolygon(this.m_spatialInfo, poly);
    }

    public MultiPolygon newMultiPolygonFromCurveSegments(List<ICurveSegment> curveSegments) {
        Polygon poly = this.newPolygon(curveSegments);
        return new MultiPolygon(this.m_spatialInfo, poly);
    }

    public MultiPolygon newMultiPolygon(ICurve curve) {
        List<CurveSegment> newSegList = this.copyAndTransformCurveSegments(curve.iterator());
        Ring newRing = new Ring(this.m_spatialInfo, newSegList);
        Polygon newPoly = new Polygon(this.m_spatialInfo, newRing);
        return new MultiPolygon(this.m_spatialInfo, newPoly);
    }

    public MultiPolygon newMultiPolygon(IRing ring) {
        Polygon poly = this.newPolygon(ring);
        return new MultiPolygon(this.m_spatialInfo, poly);
    }

    public MultiPolygon newMultiPolygon(IRectangle rect) {
        return this.newRectangle(rect).asMultiPolygon();
    }

    public MultiPolygon newMultiPolygon(ILegacyRoundedRectangle rrect) {
        return this.newRoundedRectangle(rrect).asRectangle().asMultiPolygon();
    }

    public MultiPolygon newMultiPolygon(ILegacyEllipse ellipse) {
        return this.newEllipse(ellipse).asMultiPolygon();
    }

    public MultiCurve newMultiCurve(ILegacyArc larc) {
        return this.newLegacyArc(larc).asMultiCurve();
    }

    public MultiPolygon newMultiPolygon(ILegacyText ltext) {
        Rectangle rect = this.newRectangle(ltext.getEnvelope());
        return rect.asMultiPolygon();
    }

    public MultiPolygon newMultiPolygon(IPolygon poly) {
        Polygon newPoly = this.newPolygon(poly);
        return new MultiPolygon(this.m_spatialInfo, newPoly);
    }

    public MultiPolygon newMultiPolygon(Collection<? extends IPolygon> polys) {
        ArrayList<Polygon> newPolys = new ArrayList<Polygon>(polys.size());
        for (IPolygon iPolygon : polys) {
            newPolys.add(this.newPolygon(iPolygon));
        }
        return new MultiPolygon(this.m_spatialInfo, newPolys);
    }

    public MultiPolygon newMultiPolygon(IMultiPolygon multiPoly) {
        ArrayList<Polygon> newPolys = new ArrayList<Polygon>(multiPoly.getPolygonCount());
        for (IPolygon p : multiPoly) {
            newPolys.add(this.newPolygon(p));
        }
        return new MultiPolygon(this.m_spatialInfo, newPolys);
    }

    public Polygon newPolygon(IDirectPositionList dplist, GeometryType gtype) throws InvalidGeometryException {
        Ring ring = this.newRing(dplist, gtype);
        return new Polygon(this.m_spatialInfo, ring);
    }

    public Polygon newPolygon(ICurveSegment cseg) throws InvalidGeometryException {
        return this.newPolygon(Collections.singletonList(cseg));
    }

    public Polygon newPolygon(List<ICurveSegment> curveSegments) throws InvalidGeometryException {
        List<CurveSegment> newSegList = this.copyAndTransformCurveSegments(curveSegments.iterator());
        Ring newRing = new Ring(this.m_spatialInfo, newSegList);
        return new Polygon(this.m_spatialInfo, newRing);
    }

    public Polygon newPolygon(IRing ring) {
        List<CurveSegment> newSegList = this.copyAndTransformCurveSegments(ring.iterator());
        Ring newRing = new Ring(this.m_spatialInfo, newSegList);
        return new Polygon(this.m_spatialInfo, newRing);
    }

    public Polygon newPolygon(IRing outerRing, Collection<? extends IRing> innerRings) {
        List<CurveSegment> segList = this.copyAndTransformCurveSegments(outerRing.iterator());
        Ring newOuterRing = new Ring(this.m_spatialInfo, segList);
        ArrayList<Ring> newInnerRings = new ArrayList<Ring>(innerRings.size());
        for (IRing iRing : innerRings) {
            List<CurveSegment> newSegList = this.copyAndTransformCurveSegments(iRing.iterator());
            newInnerRings.add(new Ring(this.m_spatialInfo, newSegList));
        }
        return new Polygon(this.m_spatialInfo, newOuterRing, newInnerRings);
    }

    public Polygon newPolygon(IPolygon poly) {
        ArrayList<IRing> innerRings = new ArrayList<IRing>(poly.getInteriorRingCount());
        Iterator<IRing> iter = poly.getInteriorRingIterator();
        while (iter.hasNext()) {
            innerRings.add(iter.next());
        }
        return this.newPolygon(poly.getExteriorRing(), innerRings);
    }

    public Ring newRing(IDirectPositionList dplist, GeometryType gtype) throws InvalidGeometryException {
        CurveSegment cs = this.newCurveSegment(dplist, gtype);
        return new Ring(cs.getSpatialInfo(), cs);
    }

    public Ring newRing(ICurveSegment cseg) throws InvalidGeometryException {
        return this.newRing(Collections.singletonList(cseg));
    }

    public Ring newRing(List<ICurveSegment> segList) throws InvalidGeometryException {
        List<CurveSegment> newSegList = this.copyAndTransformCurveSegments(segList.iterator());
        return new Ring(this.m_spatialInfo, newSegList);
    }

    public Ring newRing(ICurve curve) throws InvalidGeometryException {
        List<CurveSegment> newSegList = this.copyAndTransformCurveSegments(curve.iterator());
        return new Ring(this.m_spatialInfo, newSegList);
    }

    public Ring newRing(IRing ring) {
        List<CurveSegment> newSegList = this.copyAndTransformCurveSegments(ring.iterator());
        return new Ring(this.m_spatialInfo, newSegList);
    }

    public Rectangle newRectangle(DirectPosition ll, DirectPosition ur) {
        return new Rectangle(this.m_spatialInfo, ll.getCopy(), ur.getCopy());
    }

    public Rectangle newRectangle(IRectangle rect) {
        DirectPositionTransform dpXform = new DirectPositionTransform(rect.getSpatialInfo(), this.m_spatialInfo);
        DirectPosition ll = rect.getLowerLeft();
        DirectPosition ur = rect.getUpperRight();
        dpXform.transform(ll, ll);
        dpXform.transform(ur, ur);
        return new Rectangle(this.m_spatialInfo, ll, ur);
    }

    public Rectangle newRectangle(Envelope env) throws InvalidGeometryException {
        if (env.isEmpty()) {
            throw new InvalidGeometryException("Specified Envelope cannot be empty.");
        }
        DirectPositionTransform dpXform = new DirectPositionTransform(env.getSpatialInfo(), this.getSpatialInfo());
        DirectPosition ell = env.getLowerLeft();
        DirectPosition eur = env.getUpperRight();
        DirectPosition ll = new DirectPosition();
        DirectPosition ur = new DirectPosition();
        if (env.isExtentZEmpty()) {
            ll.setXY(ell.getX(), ell.getY());
            ur.setXY(eur.getX(), eur.getY());
        } else {
            ll.setXYZ(ell.getX(), ell.getY(), ell.getZ());
            ur.setXYZ(eur.getX(), eur.getY(), eur.getZ());
        }
        dpXform.transform(ll, ll);
        dpXform.transform(ur, ur);
        return new Rectangle(this.m_spatialInfo, ll, ur);
    }

    public LegacyRoundedRectangle newRoundedRectangle(DirectPosition ll, DirectPosition ur, PaperLength cornerRadiusX, PaperLength cornerRadiusY) {
        return new LegacyRoundedRectangle(this.m_spatialInfo, ll.getCopy(), ur.getCopy(), cornerRadiusX, cornerRadiusY);
    }

    public LegacyRoundedRectangle newRoundedRectangle(ILegacyRoundedRectangle rrect) {
        DirectPositionTransform dpXform = new DirectPositionTransform(rrect.getSpatialInfo(), this.m_spatialInfo);
        DirectPosition ll = rrect.getLowerLeft();
        DirectPosition ur = rrect.getUpperRight();
        dpXform.transform(ll, ll);
        dpXform.transform(ur, ur);
        return this.newRoundedRectangle(ll, ur, rrect.getCornerRadiusX(), rrect.getCornerRadiusY());
    }

    public LegacyEllipse newEllipse(DirectPosition ll, DirectPosition ur) {
        Rectangle rect = this.newRectangle(ll, ur);
        return new LegacyEllipse(rect);
    }

    public LegacyEllipse newEllipse(ILegacyEllipse e) {
        DirectPositionTransform dpXform = new DirectPositionTransform(e.getSpatialInfo(), this.m_spatialInfo);
        DirectPosition ll = e.getLowerLeft();
        DirectPosition ur = e.getUpperRight();
        dpXform.transform(ll, ll);
        dpXform.transform(ur, ur);
        Rectangle rect = new Rectangle(this.m_spatialInfo, ll, ur);
        return new LegacyEllipse(rect);
    }
}

