/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.GeometryUtilities;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.MultiCurve;
import com.mapinfo.midev.geometry.impl.Rectangle;
import com.mapinfo.midev.unit.Angle;
import com.mapinfo.midev.unit.AngularUnit;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.AreaUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;

public class LegacyArc
extends FeatureGeometry
implements ILegacyArc {
    private final Rectangle m_rect;
    private final Angle m_begin;
    private final Angle m_end;
    private DirectPosition m_beginPosition = null;
    private DirectPosition m_endPosition = null;

    public LegacyArc(Rectangle rect, Angle begin, Angle end) {
        super(rect.getSpatialInfo());
        this.m_rect = rect;
        this.m_begin = begin;
        this.m_end = end;
    }

    @Override
    public boolean zSet() {
        return this.m_rect.zSet();
    }

    @Override
    public boolean zAllSet() {
        return this.m_rect.zAllSet();
    }

    @Override
    public boolean mSet() {
        return this.m_rect.mSet();
    }

    @Override
    public boolean mAllSet() {
        return this.m_rect.mAllSet();
    }

    @Override
    public int getDimension() {
        return 1;
    }

    @Override
    public Envelope getEnvelope() {
        Envelope env;
        block2: {
            if (this.isEmpty()) {
                return this.m_rect.getEnvelope();
            }
            env = new Envelope(this.getSpatialInfo());
            double begin = this.m_begin.getValue(AngularUnit.RADIAN);
            double end = this.m_end.getValue(AngularUnit.RADIAN);
            DirectPosition ur = this.m_rect.getUpperRight();
            DirectPosition ll = this.m_rect.getLowerLeft();
            DirectPosition ct = this.getCenter();
            DirectPosition e0 = new DirectPosition(ct.getX(), ur.getY());
            DirectPosition e1 = new DirectPosition(ll.getX(), ct.getY());
            DirectPosition e2 = new DirectPosition(ct.getX(), ll.getY());
            DirectPosition e3 = new DirectPosition(ur.getX(), ct.getY());
            DirectPosition[] exitPoints = new DirectPosition[]{e0, e1, e2, e3};
            long beginQuadrant = begin == 0.0 ? 0L : Math.round(Math.ceil(begin / 1.5707963267948966)) - 1L;
            long endQuadrant = end == 0.0 ? 0L : Math.round(Math.ceil(end / 1.5707963267948966)) - 1L;
            env.extend(this.getBeginPosition());
            env.extend(this.getEndPosition());
            int nextQuadrant = (int)beginQuadrant;
            if (beginQuadrant == endQuadrant && (beginQuadrant != endQuadrant || !(begin > end))) break block2;
            do {
                int previousQuadrant = nextQuadrant;
                nextQuadrant = (previousQuadrant + 1) % 4;
                env.extend(exitPoints[previousQuadrant]);
            } while ((long)nextQuadrant != endQuadrant);
        }
        return env;
    }

    @Override
    public boolean isEmpty() {
        return this.m_rect.isEmpty();
    }

    @Override
    public GeometryType getType() {
        return GeometryType.LEGACY_ARC;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return this.asLineString().contains(dp);
    }

    @Override
    public LegacyArc getCopy() {
        return new LegacyArc(this.m_rect.getCopy(), this.m_begin, this.m_end);
    }

    @Override
    public LegacyArc getCopy(CoordSys csys) {
        return new LegacyArc(this.m_rect.getCopy(csys), this.m_begin, this.m_end);
    }

    @Override
    public DirectPosition getRepresentativePoint() throws InvalidGeometryException {
        return this.m_rect.getRepresentativePoint();
    }

    @Override
    public void setRepresentativePoint(DirectPosition dp) {
        this.m_rect.setRepresentativePoint(dp);
    }

    @Override
    public void initializeRepresentativePoint() throws InvalidGeometryException {
        this.m_rect.initializeRepresentativePoint();
    }

    @Override
    public Rectangle getRectangle() {
        return this.m_rect.getCopy();
    }

    @Override
    public Angle getBeginAngle() {
        return this.m_begin;
    }

    @Override
    public Angle getEndAngle() {
        return this.m_end;
    }

    @Override
    public DirectPosition getCenter() {
        return this.m_rect.getEnvelope().getCenter();
    }

    @Override
    public DirectPosition getBeginPosition() {
        if (this.m_beginPosition == null) {
            this.initializeBeginAndEndPositions();
        }
        return this.m_beginPosition.getCopy();
    }

    @Override
    public DirectPosition getEndPosition() {
        if (this.m_endPosition == null) {
            this.initializeBeginAndEndPositions();
        }
        return this.m_endPosition.getCopy();
    }

    private void initializeBeginAndEndPositions() {
        DirectPositionArray dpa = this.linearizeArc(1);
        this.m_beginPosition = dpa.getDirectPosition(0, new DirectPosition());
        this.m_endPosition = dpa.getDirectPosition(1, new DirectPosition());
    }

    @Override
    public Length getXRadius() {
        ComputationType ct = GeometryUtilities.getDefaultComputationType(this.getCoordSys());
        Length width = this.m_rect.getWidth(ct);
        return new Length(width.getValue() / 2.0, width.getUnit(), ct);
    }

    @Override
    public Length getYRadius() {
        ComputationType ct = GeometryUtilities.getDefaultComputationType(this.getCoordSys());
        Length height = this.m_rect.getHeight(ct);
        return new Length(height.getValue() / 2.0, height.getUnit(), ct);
    }

    @Override
    public LineString asLineString() {
        double arc = this.getNormalizedArcMeasureInRadians();
        int resolution = (int)Math.round(100.0 * (arc / (Math.PI * 2)));
        return this.asLineString(resolution);
    }

    @Override
    public LineString asLineString(int resolution) {
        resolution = Math.max(4, resolution);
        resolution = Math.min(1048568, resolution);
        DirectPositionArray dpa = this.linearizeArc(resolution);
        return new LineString(this.getSpatialInfo(), dpa);
    }

    private DirectPositionArray linearizeArc(int resolution) {
        double begin = this.m_begin.getNormalizedValue(AngularUnit.RADIAN);
        double end = this.m_end.getNormalizedValue(AngularUnit.RADIAN);
        double arc = this.getNormalizedArcMeasureInRadians();
        DirectPosition c = this.m_rect.getEnvelope().getCenter();
        DirectPosition ll = this.m_rect.getLowerLeft();
        DirectPosition ur = this.m_rect.getUpperRight();
        double a = (ur.getX() - ll.getX()) / 2.0;
        double b = (ur.getY() - ll.getY()) / 2.0;
        double t = arc / (double)resolution;
        DirectPositionArray dpa = new DirectPositionArray(resolution + 1);
        for (int k = 0; k < resolution; ++k) {
            dpa.add(a * Math.cos(begin + (double)k * t) + c.getX(), b * Math.sin(begin + (double)k * t) + c.getY());
        }
        dpa.add(a * Math.cos(end) + c.getX(), b * Math.sin(end) + c.getY());
        return dpa;
    }

    private double getNormalizedArcMeasureInRadians() {
        double end;
        double begin = this.m_begin.getNormalizedValue(AngularUnit.RADIAN);
        double arc = begin <= (end = this.m_end.getNormalizedValue(AngularUnit.RADIAN)) ? end - begin : Math.PI * 2 - (begin - end);
        return arc;
    }

    @Override
    public MultiCurve asMultiCurve() {
        double arc = this.getNormalizedArcMeasureInRadians();
        int resolution = (int)Math.round(100.0 * (arc / (Math.PI * 2)));
        return this.asMultiCurve(resolution);
    }

    @Override
    public MultiCurve asMultiCurve(int resolution) {
        LineString ls = this.asLineString(resolution);
        return new MultiCurve(ls.getSpatialInfo(), ls);
    }

    @Override
    public Area getArea(ComputationType ct) {
        return new Area(0.0, AreaUnit.SQUARE_METER, ct);
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        return new Length(0.0, LinearUnit.METER, ct);
    }
}

