/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.CentroidUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IDirectPositionMutator;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.InvalidGeometryOperationException;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.impl.UnmodifiableDirectPositionArray;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.AreaUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import java.util.Iterator;

public class MultiPoint
extends FeatureGeometry
implements IMultiPoint {
    private final IDirectPositionList m_dpArray;
    private Envelope m_envelope = null;
    private DirectPosition m_representativePoint = null;

    public MultiPoint(SpatialInfo si) {
        this(si, new DirectPositionArray());
    }

    public MultiPoint(SpatialInfo si, DirectPosition dp) {
        this(si, new DirectPositionArray(1));
        this.m_dpArray.add(dp);
    }

    public MultiPoint(SpatialInfo si, IDirectPositionList dpa) {
        super(si);
        this.m_dpArray = dpa;
    }

    @Override
    public boolean zSet() {
        return this.m_dpArray.zSet();
    }

    @Override
    public boolean zAllSet() {
        return this.m_dpArray.zAllSet();
    }

    @Override
    public boolean mSet() {
        return this.m_dpArray.mSet();
    }

    @Override
    public boolean mAllSet() {
        return this.m_dpArray.mAllSet();
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public Envelope getEnvelope() {
        if (this.m_envelope == null) {
            this.m_envelope = new Envelope(this.getSpatialInfo());
            this.m_envelope.extend(this.m_dpArray);
        }
        return this.m_envelope.getCopy();
    }

    @Override
    public boolean isEmpty() {
        return this.m_dpArray.isEmpty();
    }

    @Override
    public GeometryType getType() {
        return GeometryType.MULTI_POINT;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return this.m_dpArray.contains(dp);
    }

    @Override
    public int getPointCount() {
        return this.m_dpArray.size();
    }

    @Override
    public IDirectPositionList getPositions() {
        return new UnmodifiableDirectPositionArray(this.m_dpArray);
    }

    @Override
    public Iterator<IPoint> iterator() {
        return new _PointIterator(this.getDirectPositionIterator(), this.getSpatialInfo());
    }

    @Override
    public IDirectPositionIterator getDirectPositionIterator() {
        return this.m_dpArray.getDirectPositionIterator();
    }

    @Override
    public MultiPoint getCopy() {
        return this.getCopy(this.getSpatialInfo().getCoordSys());
    }

    @Override
    public MultiPoint getCopy(CoordSys csys) {
        CoordTransform dpXform = this.getCoordSys().createCoordTransform(csys);
        DirectPositionArray dpa = new DirectPositionArray(this.m_dpArray);
        dpa.change((IDirectPositionMutator)dpXform);
        SpatialInfo si = new SpatialInfo(csys, this.getSpatialInfo().getZUnit(), this.getSpatialInfo().getToleranceLength());
        MultiPoint mp = new MultiPoint(si, dpa);
        if (this.m_representativePoint != null) {
            mp.m_representativePoint = dpXform.transform(this.m_representativePoint, new DirectPosition());
        }
        return mp;
    }

    @Override
    public DirectPosition getRepresentativePoint() throws InvalidGeometryException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot get representative point of an empty geometry.");
        }
        if (this.m_representativePoint == null) {
            this.initializeRepresentativePoint();
        }
        return this.m_representativePoint.getCopy();
    }

    @Override
    public void setRepresentativePoint(DirectPosition dp) throws InvalidGeometryException, InvalidGeometryOperationException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot set representative point of an empty geometry.");
        }
        if (!this.contains(dp)) {
            throw new InvalidGeometryOperationException("The direct position (" + dp + ") is not contained by this geometry.");
        }
        if (this.m_representativePoint == null) {
            this.m_representativePoint = new DirectPosition(dp);
        } else {
            this.m_representativePoint.set(dp);
        }
    }

    @Override
    public void initializeRepresentativePoint() throws InvalidGeometryException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot initialize representative point of an empty geometry.");
        }
        if (this.m_representativePoint == null) {
            this.m_representativePoint = new DirectPosition();
        }
        this.m_representativePoint.set(CentroidUtilities.calculateCentroid(this));
    }

    @Override
    public Area getArea(ComputationType ct) {
        return new Area(0.0, AreaUnit.SQUARE_METER, ct);
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        return new Length(0.0, LinearUnit.METER, ct);
    }

    private static class _PointIterator
    implements Iterator<IPoint> {
        private final IDirectPositionIterator m_dpIter;
        private final SpatialInfo m_spatialInfo;

        _PointIterator(IDirectPositionIterator dpIter, SpatialInfo spatialInfo) {
            this.m_dpIter = dpIter;
            this.m_spatialInfo = spatialInfo;
        }

        @Override
        public boolean hasNext() {
            return this.m_dpIter.hasNext();
        }

        @Override
        public IPoint next() {
            return new Point(this.m_spatialInfo, this.m_dpIter.nextDirectPosition(new DirectPosition()));
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

