/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.geometry.CentroidUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.InvalidComputationTypeException;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.InvalidGeometryOperationException;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.CurveSegment;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.geometry.impl.Polygon;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.operations.cartesian.contains.CartesianContains;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class MultiPolygon
extends FeatureGeometry
implements IMultiPolygon {
    private final List<Polygon> m_polygonList = new ArrayList<Polygon>();
    private DirectPosition m_representativePoint = null;
    private Length m_sphericalPerimeter = null;
    private Length m_cartesianPerimeter = null;
    private Area m_sphericalArea = null;
    private Area m_cartesianArea = null;
    private Envelope m_envelope = null;

    public MultiPolygon(SpatialInfo si) {
        super(si);
    }

    public MultiPolygon(SpatialInfo si, CurveSegment cs) throws InvalidGeometryException {
        this(si, new Ring(si, cs));
    }

    public MultiPolygon(SpatialInfo si, Ring ring) {
        this(si, new Polygon(si, ring));
    }

    public MultiPolygon(SpatialInfo si, Polygon poly) {
        super(si);
        this.m_polygonList.add(poly);
    }

    public MultiPolygon(SpatialInfo si, List<Polygon> polyList) {
        this(si, polyList, (Envelope)null);
    }

    public MultiPolygon(SpatialInfo si, List<Polygon> polyList, Envelope bounds) {
        super(si);
        this.m_polygonList.addAll(polyList);
        this.m_envelope = bounds;
    }

    public MultiPolygon(SpatialInfo si, List<Polygon> polyList, DirectPosition rp) {
        this(si, polyList);
        if (!this.isEmpty()) {
            this.m_representativePoint = rp;
        }
    }

    @Override
    public boolean zSet() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bZSet = false;
        Iterator<IPolygon> iter = this.iterator();
        while (iter.hasNext() && !bZSet) {
            bZSet = iter.next().zSet();
        }
        return bZSet;
    }

    @Override
    public boolean zAllSet() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bZAllSet = true;
        Iterator<IPolygon> iter = this.iterator();
        while (iter.hasNext() && bZAllSet) {
            bZAllSet = iter.next().zAllSet();
        }
        return bZAllSet;
    }

    @Override
    public boolean mSet() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bMSet = false;
        Iterator<IPolygon> iter = this.iterator();
        while (iter.hasNext() && !bMSet) {
            bMSet = iter.next().mSet();
        }
        return bMSet;
    }

    @Override
    public boolean mAllSet() {
        if (this.isEmpty()) {
            return false;
        }
        boolean bMAllSet = true;
        Iterator<IPolygon> iter = this.iterator();
        while (iter.hasNext() && bMAllSet) {
            bMAllSet = iter.next().mAllSet();
        }
        return bMAllSet;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Envelope getEnvelope() {
        if (this.m_envelope == null) {
            this.m_envelope = new Envelope(this.getSpatialInfo());
            for (IPolygon p : this) {
                this.m_envelope.extend(p.getEnvelope());
            }
        }
        return this.m_envelope.getCopy();
    }

    @Override
    public boolean isEmpty() {
        return this.m_polygonList.isEmpty();
    }

    @Override
    public GeometryType getType() {
        return GeometryType.MULTI_POLYGON;
    }

    @Override
    public Iterator<IPolygon> iterator() {
        return new _PolygonIterator(this.m_polygonList.iterator());
    }

    @Override
    public int getPolygonCount() {
        return this.m_polygonList.size();
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return CartesianContains.contains(this, dp);
    }

    @Override
    public Area getArea(ComputationType ct) {
        Area area;
        switch (ct) {
            case SPHERICAL: {
                area = this.m_sphericalArea == null ? (this.m_sphericalArea = MeasurementUtilities.area(this, ct)) : this.m_sphericalArea;
                break;
            }
            case CARTESIAN: {
                area = this.m_cartesianArea == null ? (this.m_cartesianArea = MeasurementUtilities.area(this, ct)) : this.m_cartesianArea;
                break;
            }
            default: {
                throw new InvalidComputationTypeException(ct);
            }
        }
        return area;
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        Length len;
        switch (ct) {
            case SPHERICAL: {
                len = this.m_sphericalPerimeter == null ? (this.m_sphericalPerimeter = MeasurementUtilities.perimeter(this, ct)) : this.m_sphericalPerimeter;
                break;
            }
            case CARTESIAN: {
                len = this.m_cartesianPerimeter == null ? (this.m_cartesianPerimeter = MeasurementUtilities.perimeter(this, ct)) : this.m_cartesianPerimeter;
                break;
            }
            default: {
                throw new InvalidComputationTypeException(ct);
            }
        }
        return len;
    }

    @Override
    public MultiPolygon getCopy() {
        return this.getCopy(this.getSpatialInfo().getCoordSys());
    }

    @Override
    public MultiPolygon getCopy(CoordSys csys) {
        ArrayList<Polygon> newPolyList = new ArrayList<Polygon>(this.getPolygonCount());
        for (Polygon p : this.m_polygonList) {
            newPolyList.add(p.getCopy(csys));
        }
        DirectPosition representativePoint = this.m_representativePoint == null ? null : new DirectPosition(this.m_representativePoint);
        SpatialInfo si = this.getSpatialInfo();
        if (!csys.equivalent(si.getCoordSys())) {
            si = new SpatialInfo(csys, this.getSpatialInfo().getZUnit(), this.getSpatialInfo().getToleranceLength());
            if (representativePoint != null) {
                this.getCoordSys().createCoordTransform(csys).transform(representativePoint, representativePoint);
            }
        }
        return new MultiPolygon(si, newPolyList, representativePoint);
    }

    @Override
    public DirectPosition getRepresentativePoint() throws InvalidGeometryException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot get representative point of an empty geometry.");
        }
        if (this.m_representativePoint == null) {
            this.initializeRepresentativePoint();
        }
        return this.m_representativePoint.getCopy();
    }

    @Override
    public void setRepresentativePoint(DirectPosition dp) throws InvalidGeometryException, InvalidGeometryOperationException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot set representative point of an empty geometry.");
        }
        if (!this.contains(dp)) {
            throw new InvalidGeometryOperationException("The direct position (" + dp + ") is not contained by this geometry.");
        }
        if (this.m_representativePoint == null) {
            this.m_representativePoint = dp.getCopy();
        } else {
            this.m_representativePoint.set(dp);
        }
    }

    @Override
    public void initializeRepresentativePoint() throws InvalidGeometryException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot initialize representative point of an empty geometry.");
        }
        if (this.m_representativePoint == null) {
            this.m_representativePoint = CentroidUtilities.calculateCentroid(this);
        } else {
            this.m_representativePoint.set(CentroidUtilities.calculateCentroid(this));
        }
    }

    private static class _PolygonIterator
    implements Iterator<IPolygon> {
        private final Iterator<Polygon> m_iter;

        private _PolygonIterator(Iterator<Polygon> iter) {
            this.m_iter = iter;
        }

        @Override
        public boolean hasNext() {
            return this.m_iter.hasNext();
        }

        @Override
        public IPolygon next() {
            return this.m_iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

