/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.MValue;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.AreaUnit;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.unit.LinearUnit;
import com.mapinfo.midev.util.Code;

public class Point
extends FeatureGeometry
implements IPoint {
    private final DirectPosition m_dp;

    public Point(SpatialInfo si, DirectPosition dp) {
        super(si);
        this.m_dp = dp;
    }

    @Override
    public DirectPosition getDirectPosition() {
        return this.m_dp.getCopy();
    }

    @Override
    public Point getCopy() {
        return new Point(this.getSpatialInfo(), new DirectPosition(this.m_dp));
    }

    @Override
    public Point getCopy(CoordSys crs) {
        DirectPosition dp = new DirectPosition();
        CoordTransform dpt = this.getCoordSys().createCoordTransform(crs);
        dpt.transform(this.m_dp, dp);
        SpatialInfo si = new SpatialInfo(crs, this.getSpatialInfo().getZUnit(), this.getSpatialInfo().getToleranceLength());
        return new Point(si, dp);
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public DirectPosition getRepresentativePoint() {
        return this.getDirectPosition();
    }

    @Override
    public void setRepresentativePoint(DirectPosition dp) {
        if (!this.m_dp.equals((Object)dp)) {
            throw new IllegalArgumentException("The direct position (" + dp + ") is not contained by this geometry.");
        }
    }

    @Override
    public void initializeRepresentativePoint() {
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return this.m_dp.equalsXY(dp);
    }

    @Override
    public GeometryType getType() {
        return GeometryType.POINT;
    }

    @Override
    public MValue getM() {
        return this.m_dp.getM();
    }

    @Override
    public double getX() {
        return this.m_dp.getX();
    }

    @Override
    public double getY() {
        return this.m_dp.getY();
    }

    @Override
    public double getZ() {
        return this.m_dp.getZ();
    }

    @Override
    public boolean zSet() {
        return this.m_dp.zSet();
    }

    @Override
    public boolean zAllSet() {
        return this.zSet();
    }

    @Override
    public boolean mSet() {
        return this.m_dp.mSet();
    }

    @Override
    public boolean mAllSet() {
        return this.mSet();
    }

    @Override
    public int getDimension() {
        return 0;
    }

    @Override
    public Envelope getEnvelope() {
        return new Envelope(this.m_dp, this.m_dp, this.getSpatialInfo());
    }

    @Override
    public Area getArea(ComputationType ct) {
        return new Area(0.0, AreaUnit.SQUARE_METER, ct);
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        return new Length(0.0, LinearUnit.METER, ct);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Point {");
        sb.append(this.m_dp).append(',');
        CoordSys coordSys = this.getCoordSys();
        CodeSet codes = coordSys.getCodes();
        Code code = codes.getFirstCode("epsg");
        if (code == null) {
            code = codes.getFirstCode("mapinfo");
        }
        sb.append(code);
        return sb.append('}').toString();
    }
}

