/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.impl;

import com.mapinfo.midev.coordsys.CodeSet;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.transform.CoordTransform;
import com.mapinfo.midev.geometry.CentroidUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.GeometryType;
import com.mapinfo.midev.geometry.IRectangle;
import com.mapinfo.midev.geometry.InvalidGeometryException;
import com.mapinfo.midev.geometry.InvalidGeometryOperationException;
import com.mapinfo.midev.geometry.MeasurementUtilities;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.geometry.impl.LineString;
import com.mapinfo.midev.geometry.impl.MultiPolygon;
import com.mapinfo.midev.unit.Area;
import com.mapinfo.midev.unit.ComputationType;
import com.mapinfo.midev.unit.Length;
import com.mapinfo.midev.util.Code;
import com.mapinfo.midev.util.DoubleRect;

public final class Rectangle
extends FeatureGeometry
implements IRectangle {
    private final DirectPosition m_ll;
    private final DirectPosition m_ur;
    private DirectPosition m_representativePoint = null;

    public Rectangle(SpatialInfo si, DirectPosition ll, DirectPosition ur) {
        super(si);
        if (ll.getX() <= ur.getX() && ll.getY() <= ur.getY()) {
            this.m_ll = new DirectPosition(ll);
            this.m_ur = new DirectPosition(ur);
        } else if (ll.getX() > ur.getX() && ll.getY() > ur.getY()) {
            this.m_ll = new DirectPosition(ur);
            this.m_ur = new DirectPosition(ll);
        } else {
            this.m_ll = new DirectPosition(Math.min(ll.getX(), ur.getX()), Math.min(ll.getY(), ur.getY()));
            this.m_ur = new DirectPosition(Math.max(ll.getX(), ur.getX()), Math.max(ll.getY(), ur.getY()));
        }
    }

    Rectangle(Rectangle rect) {
        this(rect.getSpatialInfo(), rect.getLowerLeft(), rect.getUpperRight());
    }

    @Override
    public DirectPosition getLowerLeft() {
        return this.m_ll.getCopy();
    }

    @Override
    public DirectPosition getUpperRight() {
        return this.m_ur.getCopy();
    }

    @Override
    public Length getWidth(ComputationType ct) {
        DirectPosition lowerRight = new DirectPosition(this.m_ur.getX(), this.m_ll.getY());
        return MeasurementUtilities.length(this.m_ll, lowerRight, this.getCoordSys(), ct);
    }

    @Override
    public Length getHeight(ComputationType ct) {
        DirectPosition upperLeft = new DirectPosition(this.m_ll.getX(), this.m_ur.getY());
        return MeasurementUtilities.length(this.m_ll, upperLeft, this.getCoordSys(), ct);
    }

    @Override
    public Area getArea(ComputationType ct) {
        return this.asMultiPolygon().getArea(ct);
    }

    @Override
    public Length getPerimeter(ComputationType ct) {
        return this.asMultiPolygon().getPerimeter(ct);
    }

    @Override
    public MultiPolygon asMultiPolygon() {
        double[] xArray = new double[]{this.m_ll.getX(), this.m_ll.getX(), this.m_ur.getX(), this.m_ur.getX(), this.m_ll.getX()};
        double[] yArray = new double[]{this.m_ll.getY(), this.m_ur.getY(), this.m_ur.getY(), this.m_ll.getY(), this.m_ll.getY()};
        DirectPositionArray dpa = new DirectPositionArray(xArray, yArray, xArray.length);
        LineString ls = new LineString(this.getSpatialInfo(), dpa);
        return new MultiPolygon(this.getSpatialInfo(), ls);
    }

    @Override
    public DirectPosition getRepresentativePoint() throws InvalidGeometryException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot get representative point of an empty geometry.");
        }
        if (this.m_representativePoint == null) {
            this.initializeRepresentativePoint();
        }
        return this.m_representativePoint.getCopy();
    }

    @Override
    public void setRepresentativePoint(DirectPosition dp) throws InvalidGeometryException, InvalidGeometryOperationException {
        if (this.isEmpty()) {
            throw new InvalidGeometryException("Cannot set representative point of an empty geometry.");
        }
        if (!this.contains(dp)) {
            throw new InvalidGeometryOperationException("The direct position (" + dp + ") is not contained by this geometry.");
        }
        if (this.m_representativePoint == null) {
            this.m_representativePoint = new DirectPosition(dp);
        } else {
            this.m_representativePoint.set(dp);
        }
    }

    @Override
    public void initializeRepresentativePoint() {
        if (this.m_representativePoint == null) {
            this.m_representativePoint = CentroidUtilities.calculateCentroid(this);
        } else {
            this.m_representativePoint.set(CentroidUtilities.calculateCentroid(this));
        }
    }

    @Override
    public boolean zSet() {
        return this.m_ll.zSet() || this.m_ur.zSet();
    }

    @Override
    public boolean zAllSet() {
        return this.m_ll.zSet() && this.m_ur.zSet();
    }

    @Override
    public boolean mSet() {
        return this.m_ll.mSet() || this.m_ur.mSet();
    }

    @Override
    public boolean mAllSet() {
        return this.m_ll.mSet() && this.m_ur.mSet();
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public Envelope getEnvelope() {
        return new Envelope(this.m_ll, this.m_ur, this.getSpatialInfo());
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public GeometryType getType() {
        return GeometryType.RECTANGLE;
    }

    @Override
    public boolean contains(DirectPosition dp) {
        return this.getEnvelope().contains(dp);
    }

    @Override
    public Rectangle getCopy() {
        return new Rectangle(this);
    }

    @Override
    public Rectangle getCopy(CoordSys csys) {
        CoordTransform dpXform = this.getCoordSys().createCoordTransform(csys);
        DoubleRect rect = new DoubleRect(this.m_ll.getX(), this.m_ll.getY(), this.m_ur.getX(), this.m_ur.getY());
        rect = dpXform.transform(rect);
        SpatialInfo si = new SpatialInfo(csys, this.getSpatialInfo().getZUnit(), this.getSpatialInfo().getToleranceLength());
        return new Rectangle(si, new DirectPosition(rect.getMinX(), rect.getMinY()), new DirectPosition(rect.getMaxX(), rect.getMaxY()));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Rectangle {");
        sb.append(this.m_ll).append(',');
        sb.append(this.m_ur).append(',');
        CoordSys coordSys = this.getCoordSys();
        CodeSet codes = coordSys.getCodes();
        Code code = codes.getFirstCode("epsg");
        if (code == null) {
            code = codes.getFirstCode("mapinfo");
        }
        sb.append(code);
        return sb.append('}').toString();
    }
}

