/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.midev.geometry.jts;

import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.ICurve;
import com.mapinfo.midev.geometry.ICurveSegment;
import com.mapinfo.midev.geometry.IDirectPositionIterator;
import com.mapinfo.midev.geometry.IDirectPositionList;
import com.mapinfo.midev.geometry.IFeatureGeometry;
import com.mapinfo.midev.geometry.IGeometry;
import com.mapinfo.midev.geometry.ILegacyArc;
import com.mapinfo.midev.geometry.ILegacyEllipse;
import com.mapinfo.midev.geometry.ILegacyRoundedRectangle;
import com.mapinfo.midev.geometry.ILegacyText;
import com.mapinfo.midev.geometry.ILineString;
import com.mapinfo.midev.geometry.IMultiCurve;
import com.mapinfo.midev.geometry.IMultiFeatureGeometry;
import com.mapinfo.midev.geometry.IMultiPoint;
import com.mapinfo.midev.geometry.IMultiPolygon;
import com.mapinfo.midev.geometry.IPoint;
import com.mapinfo.midev.geometry.IPolygon;
import com.mapinfo.midev.geometry.IRing;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.geometry.impl.Curve;
import com.mapinfo.midev.geometry.impl.DirectPositionArray;
import com.mapinfo.midev.geometry.impl.FeatureGeometry;
import com.mapinfo.midev.geometry.impl.MultiCurve;
import com.mapinfo.midev.geometry.impl.MultiFeatureGeometry;
import com.mapinfo.midev.geometry.impl.MultiPolygon;
import com.mapinfo.midev.geometry.impl.Point;
import com.mapinfo.midev.geometry.impl.Ring;
import com.mapinfo.midev.geometry.jts.DirectPositionSequence;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.CoordinateSequence;
import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.Lineal;
import com.vividsolutions.jts.geom.LinearRing;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.Polygonal;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedLineString;
import com.vividsolutions.jts.geom.prep.PreparedPolygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;

public final class JTSGeometryConvertor {
    private static final DirectPositionSequenceFactory DIRECT_POSITION_SEQUENCE_FACTORY = new DirectPositionSequenceFactory();
    private static final GeometryFactory GEOMETRY_FACTORY_FLOATING = new GeometryFactory((CoordinateSequenceFactory)DIRECT_POSITION_SEQUENCE_FACTORY);

    private JTSGeometryConvertor() {
    }

    private static Polygon convert(Envelope envelope, GeometryFactory geometryFactory) {
        PrecisionModel precisionModel = geometryFactory.getPrecisionModel();
        double envLLX = precisionModel.makePrecise(envelope.getLLX());
        double envURX = precisionModel.makePrecise(envelope.getURX());
        double envLLY = precisionModel.makePrecise(envelope.getLLY());
        double envURY = precisionModel.makePrecise(envelope.getURY());
        DirectPositionArray dpl = new DirectPositionArray(new double[]{envLLX, envLLX, envURX, envURX, envLLX}, new double[]{envLLY, envURY, envURY, envLLY, envLLY}, 5);
        return geometryFactory.createPolygon(geometryFactory.createLinearRing(JTSGeometryConvertor.convert(dpl, geometryFactory)), null);
    }

    public static Polygon convert(Envelope envelope) {
        return JTSGeometryConvertor.convert(envelope, GEOMETRY_FACTORY_FLOATING);
    }

    private static Geometry convert(IGeometry geometry, GeometryFactory geometryFactory) {
        com.vividsolutions.jts.geom.Envelope e;
        LinearRing result;
        switch (geometry.getType()) {
            case RING: {
                result = JTSGeometryConvertor.convert((IRing)geometry, geometryFactory);
                break;
            }
            case CURVE: {
                result = JTSGeometryConvertor.convert((ICurve)geometry, geometryFactory);
                break;
            }
            case LINE_STRING: {
                result = JTSGeometryConvertor.convert((ILineString)geometry, geometryFactory);
                break;
            }
            case POLYGON: {
                result = JTSGeometryConvertor.convert((IPolygon)geometry, geometryFactory);
                break;
            }
            case ELLIPSE: {
                result = JTSGeometryConvertor.convert(((ILegacyEllipse)geometry).asMultiPolygon(), geometryFactory);
                break;
            }
            case LEGACY_ARC: {
                result = JTSGeometryConvertor.convert(((ILegacyArc)geometry).asLineString(), geometryFactory);
                break;
            }
            case LEGACY_TEXT: {
                result = JTSGeometryConvertor.convert(((ILegacyText)geometry).getRectangle().asMultiPolygon(), geometryFactory);
                break;
            }
            case MULTI_CURVE: {
                IMultiCurve mc = (IMultiCurve)geometry;
                if (mc.getCurveCount() == 0) {
                    return geometryFactory.createMultiLineString(null);
                }
                if (mc.getCurveCount() == 1) {
                    result = JTSGeometryConvertor.convert((ICurve)mc.iterator().next(), geometryFactory);
                    break;
                }
                result = JTSGeometryConvertor.convert(mc, geometryFactory);
                break;
            }
            case MULTI_FEATURE_GEOMETRY: {
                IMultiFeatureGeometry multiFeatureGeometry = (IMultiFeatureGeometry)geometry;
                ArrayList<Geometry> geometryList = new ArrayList<Geometry>();
                for (IFeatureGeometry featureGeometry : multiFeatureGeometry) {
                    Geometry g = JTSGeometryConvertor.convert(featureGeometry, geometryFactory);
                    for (int n = 0; n < g.getNumGeometries(); ++n) {
                        geometryList.add(g.getGeometryN(n));
                    }
                }
                return JTSGeometryConvertor.prepareGeometryForOperations((Geometry)geometryFactory.createGeometryCollection(geometryList.toArray(new Geometry[geometryList.size()])));
            }
            case MULTI_POINT: {
                IMultiPoint multiPoint = (IMultiPoint)geometry;
                if (multiPoint.getPointCount() == 0) {
                    return geometryFactory.createMultiPoint((CoordinateSequence)null);
                }
                if (multiPoint.getPointCount() == 1) {
                    result = JTSGeometryConvertor.convert((IPoint)multiPoint.iterator().next(), geometryFactory);
                    break;
                }
                result = JTSGeometryConvertor.convert(multiPoint, geometryFactory);
                break;
            }
            case MULTI_POLYGON: {
                IMultiPolygon multiPolygon = (IMultiPolygon)geometry;
                if (multiPolygon.getPolygonCount() == 0) {
                    return geometryFactory.createMultiPolygon(null);
                }
                if (multiPolygon.getPolygonCount() == 1) {
                    result = JTSGeometryConvertor.convert((IPolygon)multiPolygon.iterator().next(), geometryFactory);
                    break;
                }
                result = JTSGeometryConvertor.convert(multiPolygon, geometryFactory);
                break;
            }
            case POINT: {
                result = JTSGeometryConvertor.convert((IPoint)geometry, geometryFactory);
                break;
            }
            case RECTANGLE: {
                result = JTSGeometryConvertor.convert(geometry.getEnvelope(), geometryFactory);
                break;
            }
            case ROUNDED_RECTANGLE: {
                result = JTSGeometryConvertor.convert(((ILegacyRoundedRectangle)geometry).asRectangle().asMultiPolygon(), geometryFactory);
                break;
            }
            default: {
                throw new UnsupportedOperationException("IGeometry not supported: " + geometry.getClass());
            }
        }
        if (result.getDimension() == 2 && ((e = result.getEnvelopeInternal()).getWidth() == 0.0 || e.getHeight() == 0.0)) {
            result = result.getBoundary();
        }
        if (result.getDimension() == 1 && result.getLength() == 0.0) {
            result = geometryFactory.createPoint(result.getCoordinate());
        }
        return result;
    }

    public static Geometry convert(IGeometry geometry) {
        return JTSGeometryConvertor.convert(geometry, GEOMETRY_FACTORY_FLOATING);
    }

    public static IFeatureGeometry convert(Geometry geometry, SpatialInfo spatialInfo) {
        return JTSGeometryConvertor._convert(geometry, spatialInfo);
    }

    private static FeatureGeometry _convert(Geometry geometry, SpatialInfo spatialInfo) {
        FeatureGeometry result;
        if (geometry.isEmpty()) {
            result = new MultiFeatureGeometry(spatialInfo);
        } else if (geometry instanceof com.vividsolutions.jts.geom.Point) {
            result = JTSGeometryConvertor._convert((com.vividsolutions.jts.geom.Point)geometry, spatialInfo);
        } else if (geometry instanceof LinearRing) {
            result = new MultiPolygon(spatialInfo, JTSGeometryConvertor._convert((LinearRing)geometry, spatialInfo));
        } else if (geometry instanceof LineString) {
            result = new MultiCurve(spatialInfo, JTSGeometryConvertor._convert((LineString)geometry, spatialInfo));
        } else if (geometry instanceof Polygon) {
            result = new MultiPolygon(spatialInfo, JTSGeometryConvertor._convert((Polygon)geometry, spatialInfo));
        } else if (geometry instanceof MultiPoint) {
            result = JTSGeometryConvertor._convert((MultiPoint)geometry, spatialInfo);
        } else if (geometry instanceof MultiLineString) {
            result = JTSGeometryConvertor._convert((MultiLineString)geometry, spatialInfo);
        } else if (geometry instanceof com.vividsolutions.jts.geom.MultiPolygon) {
            result = JTSGeometryConvertor._convert((com.vividsolutions.jts.geom.MultiPolygon)geometry, spatialInfo);
        } else if (geometry instanceof GeometryCollection) {
            result = JTSGeometryConvertor._convert((GeometryCollection)geometry, spatialInfo);
        } else {
            throw new UnsupportedOperationException();
        }
        return result;
    }

    private static Point _convert(com.vividsolutions.jts.geom.Point geometry, SpatialInfo spatialInfo) {
        Coordinate coord = geometry.getCoordinate();
        return new Point(spatialInfo, new DirectPosition(coord.x, coord.y, coord.z));
    }

    private static Ring _convert(LinearRing geometry, SpatialInfo spatialInfo) {
        return new Ring(spatialInfo, new com.mapinfo.midev.geometry.impl.LineString(spatialInfo, JTSGeometryConvertor._convert(geometry.getCoordinateSequence())));
    }

    private static Curve _convert(LineString geometry, SpatialInfo spatialInfo) {
        return new Curve(spatialInfo, new com.mapinfo.midev.geometry.impl.LineString(spatialInfo, JTSGeometryConvertor._convert(geometry.getCoordinateSequence())));
    }

    private static com.mapinfo.midev.geometry.impl.Polygon _convert(Polygon geometry, SpatialInfo spatialInfo) {
        Ring exteriorRing = new Ring(spatialInfo, new com.mapinfo.midev.geometry.impl.LineString(spatialInfo, JTSGeometryConvertor._convert(JTSGeometryConvertor.assertClosed(geometry.getExteriorRing().getCoordinateSequence()))));
        Ring[] interiorRings = new Ring[geometry.getNumInteriorRing()];
        for (int n = 0; n < geometry.getNumInteriorRing(); ++n) {
            interiorRings[n] = new Ring(spatialInfo, new com.mapinfo.midev.geometry.impl.LineString(spatialInfo, JTSGeometryConvertor._convert(JTSGeometryConvertor.assertClosed(geometry.getInteriorRingN(n).getCoordinateSequence()))));
        }
        return new com.mapinfo.midev.geometry.impl.Polygon(spatialInfo, exteriorRing, Arrays.asList(interiorRings));
    }

    private static CoordinateSequence assertClosed(CoordinateSequence cs) {
        if (cs instanceof DirectPositionSequence) {
            DirectPositionSequence dps = (DirectPositionSequence)cs;
            if (dps.zSet()) {
                int lastIndex = cs.size() - 1;
                IDirectPositionList dpa = dps.getDirectPositionList();
                if (dpa.isReadOnly()) {
                    dpa = new DirectPositionArray(dpa);
                }
                DirectPosition firstPt = dpa.getDirectPosition(0, new DirectPosition());
                DirectPosition lastPt = dpa.getDirectPosition(lastIndex, new DirectPosition());
                if (firstPt.getX() != lastPt.getZ()) {
                    dpa.set(lastIndex, firstPt);
                }
            }
        } else {
            int lastIndex;
            double startZ = cs.getOrdinate(0, 2);
            if (startZ != cs.getOrdinate(lastIndex = cs.size() - 1, 2)) {
                cs.setOrdinate(lastIndex, 2, startZ);
            }
        }
        return cs;
    }

    private static com.mapinfo.midev.geometry.impl.MultiPoint _convert(MultiPoint geometry, SpatialInfo spatialInfo) {
        DirectPositionArray result = new DirectPositionArray(geometry.getNumPoints());
        for (int n = 0; n < geometry.getNumGeometries(); ++n) {
            Coordinate coord = geometry.getGeometryN(n).getCoordinate();
            result.add(coord.x, coord.y, coord.z);
        }
        return new com.mapinfo.midev.geometry.impl.MultiPoint(spatialInfo, result);
    }

    private static MultiCurve _convert(MultiLineString geometry, SpatialInfo spatialInfo) {
        Curve[] curveList = new Curve[geometry.getNumGeometries()];
        for (int n = 0; n < geometry.getNumGeometries(); ++n) {
            curveList[n] = JTSGeometryConvertor._convert((LineString)geometry.getGeometryN(n), spatialInfo);
        }
        return new MultiCurve(spatialInfo, Arrays.asList(curveList));
    }

    private static MultiPolygon _convert(com.vividsolutions.jts.geom.MultiPolygon geometry, SpatialInfo spatialInfo) {
        com.mapinfo.midev.geometry.impl.Polygon[] curveList = new com.mapinfo.midev.geometry.impl.Polygon[geometry.getNumGeometries()];
        for (int n = 0; n < geometry.getNumGeometries(); ++n) {
            curveList[n] = JTSGeometryConvertor._convert((Polygon)geometry.getGeometryN(n), spatialInfo);
        }
        return new MultiPolygon(spatialInfo, Arrays.asList(curveList));
    }

    private static MultiFeatureGeometry _convert(GeometryCollection geometry, SpatialInfo spatialInfo) {
        FeatureGeometry[] geometryList = new FeatureGeometry[geometry.getNumGeometries()];
        for (int n = 0; n < geometry.getNumGeometries(); ++n) {
            geometryList[n] = JTSGeometryConvertor._convert(geometry.getGeometryN(n), spatialInfo);
        }
        return new MultiFeatureGeometry(spatialInfo, Arrays.asList(geometryList));
    }

    private static IDirectPositionList _convert(CoordinateSequence geometry) {
        if (geometry instanceof DirectPositionSequence) {
            return ((DirectPositionSequence)geometry).getDirectPositionList();
        }
        DirectPositionArray result = new DirectPositionArray(geometry.size());
        for (int n = 0; n < geometry.size(); ++n) {
            result.add(geometry.getOrdinate(n, 0), geometry.getOrdinate(n, 1), geometry.getOrdinate(n, 2));
        }
        return result;
    }

    public static PreparedGeometry createPreparedGeometry(Geometry geometry) {
        if (geometry instanceof Polygonal) {
            return new PreparedPolygon((Polygonal)geometry);
        }
        if (geometry instanceof Lineal) {
            return new PreparedLineString((Lineal)geometry);
        }
        return null;
    }

    private static MultiLineString convert(IMultiCurve geometry, GeometryFactory geometryFactory) {
        if (geometry.getCurveCount() == 0) {
            return geometryFactory.createMultiLineString(null);
        }
        LineString[] lineStrings = new LineString[geometry.getCurveCount()];
        int index = 0;
        for (ICurve curve : geometry) {
            lineStrings[index++] = JTSGeometryConvertor.convert(curve, geometryFactory);
        }
        return geometryFactory.createMultiLineString(lineStrings);
    }

    private static com.vividsolutions.jts.geom.MultiPolygon convert(IMultiPolygon multiPolygon, GeometryFactory geometryFactory) {
        Polygon[] polygons = new Polygon[multiPolygon.getPolygonCount()];
        int index = 0;
        for (IPolygon polygon : multiPolygon) {
            polygons[index++] = JTSGeometryConvertor.convert(polygon, geometryFactory);
        }
        return geometryFactory.createMultiPolygon(polygons);
    }

    private static MultiPoint convert(IMultiPoint geometry, GeometryFactory geometryFactory) {
        DirectPositionArray dpa = new DirectPositionArray();
        IDirectPositionIterator i = geometry.getDirectPositionIterator();
        DirectPosition tmp = new DirectPosition();
        while (i.hasNext()) {
            dpa.add(i.nextDirectPosition(tmp));
        }
        return geometryFactory.createMultiPoint(JTSGeometryConvertor.convert(dpa, geometryFactory));
    }

    private static com.vividsolutions.jts.geom.Point convert(IPoint geometry, GeometryFactory geometryFactory) {
        PrecisionModel precisionModel = geometryFactory.getPrecisionModel();
        Coordinate coordinate = !Double.isNaN(geometry.getZ()) ? new Coordinate(precisionModel.makePrecise(geometry.getX()), precisionModel.makePrecise(geometry.getY()), precisionModel.makePrecise(geometry.getZ())) : new Coordinate(precisionModel.makePrecise(geometry.getX()), precisionModel.makePrecise(geometry.getY()), geometry.getZ());
        return geometryFactory.createPoint(coordinate);
    }

    private static Polygon convert(IPolygon geometry, GeometryFactory geometryFactory) {
        LinearRing[] interiorRings = new LinearRing[geometry.getInteriorRingCount()];
        int index = 0;
        Iterator<IRing> i = geometry.getInteriorRingIterator();
        while (i.hasNext()) {
            interiorRings[index++] = JTSGeometryConvertor.convert(i.next(), geometryFactory);
        }
        return geometryFactory.createPolygon(JTSGeometryConvertor.convert(geometry.getExteriorRing(), geometryFactory), interiorRings);
    }

    private static LinearRing convert(IRing geometry, GeometryFactory geometryFactory) {
        return geometryFactory.createLinearRing(JTSGeometryConvertor.convert(geometry.asLineString().getControlPoints(), geometryFactory));
    }

    private static LineString convert(ICurve geometry, GeometryFactory geometryFactory) {
        return geometryFactory.createLineString(JTSGeometryConvertor.convert(geometry.asLineString().getControlPoints(), geometryFactory));
    }

    private static LineString convert(ICurveSegment geometry, GeometryFactory geometryFactory) {
        return geometryFactory.createLineString(JTSGeometryConvertor.convert(geometry.asLineString().getControlPoints(), geometryFactory));
    }

    private static CoordinateSequence convert(IDirectPositionList dpl, GeometryFactory geometryFactory) {
        IDirectPositionIterator directPositionIterator = dpl.getDirectPositionIterator();
        DirectPositionArray modifiedDirectPositionList = new DirectPositionArray(dpl.size());
        PrecisionModel precisionModel = geometryFactory.getPrecisionModel();
        DirectPosition tmp = new DirectPosition();
        while (directPositionIterator.hasNext()) {
            tmp = directPositionIterator.nextDirectPosition(tmp);
            tmp.setXY(precisionModel.makePrecise(tmp.getX()), precisionModel.makePrecise(tmp.getY()));
            if (tmp.zSet()) {
                tmp.setZ(precisionModel.makePrecise(tmp.getZ()));
            }
            modifiedDirectPositionList.add(tmp);
        }
        return new DirectPositionSequence(modifiedDirectPositionList);
    }

    public static Geometry prepareGeometryForOperations(Geometry geometry) {
        if (geometry.getClass().getName().equals("com.vividsolutions.jts.geom.GeometryCollection")) {
            geometry = new MIGeometryCollection((GeometryCollection)geometry);
        }
        return geometry;
    }

    public static Geometry createEmptyGeometry() {
        return GEOMETRY_FACTORY_FLOATING.createGeometryCollection(null);
    }

    private static class MIGeometryCollection
    extends GeometryCollection {
        private MIGeometryCollection(GeometryCollection geometryCollection) {
            super(MIGeometryCollection.getGeometries(geometryCollection), geometryCollection.getFactory());
        }

        private static Geometry[] getGeometries(GeometryCollection geometryCollection) {
            Geometry[] result = new Geometry[geometryCollection.getNumGeometries()];
            for (int n = 0; n < geometryCollection.getNumGeometries(); ++n) {
                result[n] = geometryCollection.getGeometryN(n);
            }
            return result;
        }
    }

    private static class DirectPositionSequenceFactory
    implements CoordinateSequenceFactory {
        private DirectPositionSequenceFactory() {
        }

        public CoordinateSequence create(Coordinate[] coordinates) {
            DirectPositionArray result = new DirectPositionArray(coordinates.length);
            for (Coordinate coordinate : coordinates) {
                result.add(coordinate.x, coordinate.y, coordinate.z);
            }
            return new DirectPositionSequence(result);
        }

        public CoordinateSequence create(CoordinateSequence coordinateSequence) {
            if (coordinateSequence instanceof DirectPositionSequence) {
                DirectPositionSequence dpSequence = (DirectPositionSequence)coordinateSequence;
                return new DirectPositionSequence(new DirectPositionArray(dpSequence.getDirectPositionList()));
            }
            DirectPositionArray result = new DirectPositionArray(coordinateSequence.size());
            Coordinate tmp = new Coordinate();
            for (int n = 0; n < coordinateSequence.size(); ++n) {
                coordinateSequence.getCoordinate(n, tmp);
                result.add(tmp.x, tmp.y, tmp.z);
            }
            return new DirectPositionSequence(result);
        }

        public CoordinateSequence create(int size, int dimension) {
            DirectPositionArray result = new DirectPositionArray(size);
            DirectPosition tmp = new DirectPosition();
            for (int n = 0; n < size; ++n) {
                result.add(tmp);
            }
            return new DirectPositionSequence(result);
        }
    }
}

